/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.data.nsp;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.annotation.concurrent.ThreadSafe;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonValue;

@ThreadSafe
public final class SanitizePackage {
    private static final List<String> WHITELIST = new ArrayList<String>(Arrays.asList("name", "version", "engine", "dependencies", "devDependencies", "optionalDependencies", "peerDependencies", "bundleDependencies", "bundledDependencies"));

    private SanitizePackage() {
    }

    public static JsonObject sanitize(JsonObject rawPackage) {
        JsonObjectBuilder builder = Json.createObjectBuilder();
        for (Map.Entry entry : rawPackage.entrySet()) {
            if (!WHITELIST.contains(entry.getKey())) continue;
            builder.add((String)entry.getKey(), (JsonValue)entry.getValue());
        }
        return builder.build();
    }
}

