/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.analyzer;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import org.apache.commons.compress.utils.IOUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.jsoup.Jsoup;
import org.owasp.dependencycheck.Engine;
import org.owasp.dependencycheck.analyzer.AbstractFileTypeAnalyzer;
import org.owasp.dependencycheck.analyzer.AnalysisPhase;
import org.owasp.dependencycheck.analyzer.exception.AnalysisException;
import org.owasp.dependencycheck.dependency.Confidence;
import org.owasp.dependencycheck.dependency.Dependency;
import org.owasp.dependencycheck.dependency.EvidenceCollection;
import org.owasp.dependencycheck.exception.InitializationException;
import org.owasp.dependencycheck.utils.FileFilterBuilder;
import org.owasp.dependencycheck.utils.FileUtils;
import org.owasp.dependencycheck.utils.Settings;
import org.owasp.dependencycheck.xml.pom.License;
import org.owasp.dependencycheck.xml.pom.Model;
import org.owasp.dependencycheck.xml.pom.PomUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JarAnalyzer
extends AbstractFileTypeAnalyzer {
    private static final Logger LOGGER = LoggerFactory.getLogger(JarAnalyzer.class);
    private static final AtomicInteger DIR_COUNT = new AtomicInteger(0);
    private static final String NEWLINE = System.getProperty("line.separator");
    private static final Set<String> IGNORE_VALUES = JarAnalyzer.newHashSet("Sun Java System Application Server");
    private static final Set<String> IGNORE_KEYS = JarAnalyzer.newHashSet("built-by", "created-by", "builtby", "createdby", "build-jdk", "buildjdk", "ant-version", "antversion", "dynamicimportpackage", "dynamicimport-package", "dynamic-importpackage", "dynamic-import-package", "import-package", "ignore-package", "export-package", "importpackage", "ignorepackage", "exportpackage", "sealed", "manifest-version", "archiver-version", "manifestversion", "archiverversion", "classpath", "class-path", "tool", "bundle-manifestversion", "bundlemanifestversion", "bundle-vendor", "include-resource", "embed-dependency", "ipojo-components", "ipojo-extension", "eclipse-sourcereferences");
    private static final String IMPLEMENTATION_VENDOR_ID = Attributes.Name.IMPLEMENTATION_VENDOR_ID.toString();
    private static final String BUNDLE_VERSION = "Bundle-Version";
    private static final String BUNDLE_DESCRIPTION = "Bundle-Description";
    private static final String BUNDLE_NAME = "Bundle-Name";
    private static final Pattern HTML_DETECTION_PATTERN = Pattern.compile("\\<[a-z]+.*/?\\>", 2);
    private static final String ANALYZER_NAME = "Jar Analyzer";
    private static final AnalysisPhase ANALYSIS_PHASE = AnalysisPhase.INFORMATION_COLLECTION;
    private static final String[] EXTENSIONS = new String[]{"jar", "war"};
    private static final FileFilter FILTER = FileFilterBuilder.newInstance().addExtensions(EXTENSIONS).build();
    private static final byte[] ZIP_FIRST_BYTES = new byte[]{80, 75, 3, 4};
    private static final byte[] ZIP_EMPTY_FIRST_BYTES = new byte[]{80, 75, 5, 6};
    private static final byte[] ZIP_SPANNED_FIRST_BYTES = new byte[]{80, 75, 7, 8};
    private File tempFileLocation = null;

    @Override
    protected FileFilter getFileFilter() {
        return FILTER;
    }

    @Override
    public String getName() {
        return ANALYZER_NAME;
    }

    @Override
    public AnalysisPhase getAnalysisPhase() {
        return ANALYSIS_PHASE;
    }

    @Override
    protected String getAnalyzerEnabledSettingKey() {
        return "analyzer.jar.enabled";
    }

    @Override
    public void analyzeDependency(Dependency dependency, Engine engine) throws AnalysisException {
        try {
            List<ClassNameInformation> classNames = this.collectClassNames(dependency);
            String fileName = dependency.getFileName().toLowerCase();
            if (classNames.isEmpty() && (fileName.endsWith("-sources.jar") || fileName.endsWith("-javadoc.jar") || fileName.endsWith("-src.jar") || fileName.endsWith("-doc.jar") || this.isMacOSMetaDataFile(dependency, engine)) || !this.isZipFile(dependency)) {
                engine.getDependencies().remove(dependency);
                return;
            }
            boolean hasManifest = this.parseManifest(dependency, classNames);
            boolean hasPOM = this.analyzePOM(dependency, classNames, engine);
            boolean addPackagesAsEvidence = !hasManifest || !hasPOM;
            this.analyzePackageNames(classNames, dependency, addPackagesAsEvidence);
        }
        catch (IOException ex) {
            throw new AnalysisException("Exception occurred reading the JAR file (" + dependency.getFileName() + ").", ex);
        }
    }

    private boolean isMacOSMetaDataFile(Dependency dependency, Engine engine) {
        String fileName = Paths.get(dependency.getActualFilePath(), new String[0]).getFileName().toString();
        return fileName.startsWith("._") && this.hasDependencyWithFilename(engine.getDependencies(), fileName.substring(2));
    }

    private boolean hasDependencyWithFilename(List<Dependency> dependencies, String fileName) {
        for (Dependency dependency : dependencies) {
            if (!Paths.get(dependency.getActualFilePath(), new String[0]).getFileName().toString().toLowerCase().equals(fileName.toLowerCase())) continue;
            return true;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isZipFile(Dependency dependency) {
        byte[] buffer = new byte[4];
        try (FileInputStream fileInputStream = new FileInputStream(dependency.getActualFilePath());){
            fileInputStream.read(buffer);
            if (!Arrays.equals(buffer, ZIP_FIRST_BYTES) && !Arrays.equals(buffer, ZIP_EMPTY_FIRST_BYTES)) {
                if (!Arrays.equals(buffer, ZIP_SPANNED_FIRST_BYTES)) return false;
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            LOGGER.warn("Unable to check if '{}' is a zip file", (Object)dependency.getActualFilePath());
            LOGGER.trace("", (Throwable)e);
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean analyzePOM(Dependency dependency, List<ClassNameInformation> classes, Engine engine) throws AnalysisException {
        try (JarFile jar = new JarFile(dependency.getActualFilePath());){
            List<String> pomEntries = this.retrievePomListing(jar);
            if (pomEntries != null && pomEntries.size() <= 1) {
                File pomFile;
                Properties pomProperties = null;
                if (pomEntries.size() == 1) {
                    String path = pomEntries.get(0);
                    pomFile = this.extractPom(path, jar);
                    pomProperties = this.retrievePomProperties(path, jar);
                } else {
                    String path = FilenameUtils.removeExtension((String)dependency.getActualFilePath()) + ".pom";
                    pomFile = new File(path);
                }
                if (!pomFile.isFile()) {
                    boolean pom = false;
                    return pom;
                }
                Model pom = PomUtils.readPom(pomFile);
                if (pom != null && pomProperties != null) {
                    pom.processProperties(pomProperties);
                }
                boolean bl = pom != null && JarAnalyzer.setPomEvidence(dependency, pom, classes);
                return bl;
            }
            Iterator<String> iterator = pomEntries.iterator();
            while (iterator.hasNext()) {
                String path = iterator.next();
                LOGGER.debug("Reading pom entry: {}", (Object)path);
                try {
                    Properties pomProperties = this.retrievePomProperties(path, jar);
                    File pomFile = this.extractPom(path, jar);
                    Model pom = PomUtils.readPom(pomFile);
                    pom.processProperties(pomProperties);
                    String displayPath = String.format("%s%s%s", dependency.getFilePath(), File.separator, path);
                    String displayName = String.format("%s%s%s", dependency.getFileName(), File.separator, path);
                    Dependency newDependency = new Dependency();
                    newDependency.setActualFilePath(pomFile.getAbsolutePath());
                    newDependency.setFileName(displayName);
                    newDependency.setFilePath(displayPath);
                    JarAnalyzer.setPomEvidence(newDependency, pom, null);
                    engine.getDependencies().add(newDependency);
                }
                catch (AnalysisException ex) {
                    LOGGER.warn("An error occurred while analyzing '{}'.", (Object)dependency.getActualFilePath());
                    LOGGER.trace("", (Throwable)ex);
                }
            }
            return false;
        }
        catch (IOException ex) {
            LOGGER.warn("Unable to read JarFile '{}'.", (Object)dependency.getActualFilePath());
            LOGGER.trace("", (Throwable)ex);
        }
        return false;
    }

    private Properties retrievePomProperties(String path, JarFile jar) {
        Properties pomProperties = null;
        String propPath = path.substring(0, path.length() - 7) + "pom.properies";
        ZipEntry propEntry = jar.getEntry(propPath);
        if (propEntry != null) {
            try (InputStreamReader reader = new InputStreamReader(jar.getInputStream(propEntry), "UTF-8");){
                pomProperties = new Properties();
                pomProperties.load(reader);
                LOGGER.debug("Read pom.properties: {}", (Object)propPath);
            }
            catch (UnsupportedEncodingException ex) {
                LOGGER.trace("UTF-8 is not supported", (Throwable)ex);
            }
            catch (IOException ex) {
                LOGGER.trace("Unable to read the POM properties", (Throwable)ex);
            }
        }
        return pomProperties;
    }

    private List<String> retrievePomListing(JarFile jar) throws IOException {
        ArrayList<String> pomEntries = new ArrayList<String>();
        Enumeration<JarEntry> entries = jar.entries();
        while (entries.hasMoreElements()) {
            JarEntry entry = entries.nextElement();
            String entryName = new File(entry.getName()).getName().toLowerCase();
            if (entry.isDirectory() || !"pom.xml".equals(entryName)) continue;
            LOGGER.trace("POM Entry found: {}", (Object)entry.getName());
            pomEntries.add(entry.getName());
        }
        return pomEntries;
    }

    private File extractPom(String path, JarFile jar) throws AnalysisException {
        File tmpDir = this.getNextTempDirectory();
        File file = new File(tmpDir, "pom.xml");
        ZipEntry entry = jar.getEntry(path);
        if (entry == null) {
            throw new AnalysisException(String.format("Pom (%s) does not exist in %s", path, jar.getName()));
        }
        try (InputStream input = jar.getInputStream(entry);
             FileOutputStream fos = new FileOutputStream(file);){
            IOUtils.copy((InputStream)input, (OutputStream)fos);
        }
        catch (IOException ex) {
            LOGGER.warn("An error occurred reading '{}' from '{}'.", (Object)path, (Object)jar.getName());
            LOGGER.error("", (Throwable)ex);
        }
        return file;
    }

    public static boolean setPomEvidence(Dependency dependency, Model pom, List<ClassNameInformation> classes) {
        String projectURL;
        String description;
        String pomName;
        String orgUrl;
        String org;
        if (pom == null) {
            return false;
        }
        boolean foundSomething = false;
        boolean addAsIdentifier = true;
        String groupid = pom.getGroupId();
        String parentGroupId = pom.getParentGroupId();
        String artifactid = pom.getArtifactId();
        String parentArtifactId = pom.getParentArtifactId();
        String version = pom.getVersion();
        String parentVersion = pom.getParentVersion();
        if ("org.sonatype.oss".equals(parentGroupId) && "oss-parent".equals(parentArtifactId)) {
            parentGroupId = null;
            parentArtifactId = null;
            parentVersion = null;
        }
        if ((groupid == null || groupid.isEmpty()) && parentGroupId != null && !parentGroupId.isEmpty()) {
            groupid = parentGroupId;
        }
        String originalGroupID = groupid;
        if (groupid != null && (groupid.startsWith("org.") || groupid.startsWith("com."))) {
            groupid = groupid.substring(4);
        }
        if ((artifactid == null || artifactid.isEmpty()) && parentArtifactId != null && !parentArtifactId.isEmpty()) {
            artifactid = parentArtifactId;
        }
        String originalArtifactID = artifactid;
        if (artifactid != null && (artifactid.startsWith("org.") || artifactid.startsWith("com."))) {
            artifactid = artifactid.substring(4);
        }
        if ((version == null || version.isEmpty()) && parentVersion != null && !parentVersion.isEmpty()) {
            version = parentVersion;
        }
        if (groupid != null && !groupid.isEmpty()) {
            foundSomething = true;
            dependency.getVendorEvidence().addEvidence("pom", "groupid", groupid, Confidence.HIGHEST);
            dependency.getProductEvidence().addEvidence("pom", "groupid", groupid, Confidence.LOW);
            JarAnalyzer.addMatchingValues(classes, groupid, dependency.getVendorEvidence());
            JarAnalyzer.addMatchingValues(classes, groupid, dependency.getProductEvidence());
            if (parentGroupId != null && !parentGroupId.isEmpty() && !parentGroupId.equals(groupid)) {
                dependency.getVendorEvidence().addEvidence("pom", "parent-groupid", parentGroupId, Confidence.MEDIUM);
                dependency.getProductEvidence().addEvidence("pom", "parent-groupid", parentGroupId, Confidence.LOW);
                JarAnalyzer.addMatchingValues(classes, parentGroupId, dependency.getVendorEvidence());
                JarAnalyzer.addMatchingValues(classes, parentGroupId, dependency.getProductEvidence());
            }
        } else {
            addAsIdentifier = false;
        }
        if (artifactid != null && !artifactid.isEmpty()) {
            foundSomething = true;
            dependency.getProductEvidence().addEvidence("pom", "artifactid", artifactid, Confidence.HIGHEST);
            dependency.getVendorEvidence().addEvidence("pom", "artifactid", artifactid, Confidence.LOW);
            JarAnalyzer.addMatchingValues(classes, artifactid, dependency.getVendorEvidence());
            JarAnalyzer.addMatchingValues(classes, artifactid, dependency.getProductEvidence());
            if (parentArtifactId != null && !parentArtifactId.isEmpty() && !parentArtifactId.equals(artifactid)) {
                dependency.getProductEvidence().addEvidence("pom", "parent-artifactid", parentArtifactId, Confidence.MEDIUM);
                dependency.getVendorEvidence().addEvidence("pom", "parent-artifactid", parentArtifactId, Confidence.LOW);
                JarAnalyzer.addMatchingValues(classes, parentArtifactId, dependency.getVendorEvidence());
                JarAnalyzer.addMatchingValues(classes, parentArtifactId, dependency.getProductEvidence());
            }
        } else {
            addAsIdentifier = false;
        }
        if (version != null && !version.isEmpty()) {
            foundSomething = true;
            dependency.getVersionEvidence().addEvidence("pom", "version", version, Confidence.HIGHEST);
            if (parentVersion != null && !parentVersion.isEmpty() && !parentVersion.equals(version)) {
                dependency.getVersionEvidence().addEvidence("pom", "parent-version", version, Confidence.LOW);
            }
        } else {
            addAsIdentifier = false;
        }
        if (addAsIdentifier) {
            dependency.addIdentifier("maven", String.format("%s:%s:%s", originalGroupID, originalArtifactID, version), null, Confidence.HIGH);
        }
        if ((org = pom.getOrganization()) != null && !org.isEmpty()) {
            dependency.getVendorEvidence().addEvidence("pom", "organization name", org, Confidence.HIGH);
            dependency.getProductEvidence().addEvidence("pom", "organization name", org, Confidence.LOW);
            JarAnalyzer.addMatchingValues(classes, org, dependency.getVendorEvidence());
            JarAnalyzer.addMatchingValues(classes, org, dependency.getProductEvidence());
        }
        if ((orgUrl = pom.getOrganizationUrl()) != null && !orgUrl.isEmpty()) {
            dependency.getVendorEvidence().addEvidence("pom", "organization url", orgUrl, Confidence.MEDIUM);
            dependency.getProductEvidence().addEvidence("pom", "organization url", orgUrl, Confidence.LOW);
        }
        if ((pomName = pom.getName()) != null && !pomName.isEmpty()) {
            foundSomething = true;
            dependency.getProductEvidence().addEvidence("pom", "name", pomName, Confidence.HIGH);
            dependency.getVendorEvidence().addEvidence("pom", "name", pomName, Confidence.HIGH);
            JarAnalyzer.addMatchingValues(classes, pomName, dependency.getVendorEvidence());
            JarAnalyzer.addMatchingValues(classes, pomName, dependency.getProductEvidence());
        }
        if ((description = pom.getDescription()) != null && !description.isEmpty() && !description.startsWith("POM was created by")) {
            foundSomething = true;
            String trimmedDescription = JarAnalyzer.addDescription(dependency, description, "pom", "description");
            JarAnalyzer.addMatchingValues(classes, trimmedDescription, dependency.getVendorEvidence());
            JarAnalyzer.addMatchingValues(classes, trimmedDescription, dependency.getProductEvidence());
        }
        if ((projectURL = pom.getProjectURL()) != null && !projectURL.trim().isEmpty()) {
            dependency.getVendorEvidence().addEvidence("pom", "url", projectURL, Confidence.HIGHEST);
        }
        JarAnalyzer.extractLicense(pom, dependency);
        return foundSomething;
    }

    protected void analyzePackageNames(List<ClassNameInformation> classNames, Dependency dependency, boolean addPackagesAsEvidence) {
        float ratio;
        HashMap<String, Integer> vendorIdentifiers = new HashMap<String, Integer>();
        HashMap<String, Integer> productIdentifiers = new HashMap<String, Integer>();
        this.analyzeFullyQualifiedClassNames(classNames, vendorIdentifiers, productIdentifiers);
        int classCount = classNames.size();
        EvidenceCollection vendor = dependency.getVendorEvidence();
        EvidenceCollection product = dependency.getProductEvidence();
        for (Map.Entry entry : vendorIdentifiers.entrySet()) {
            ratio = (float)((Integer)entry.getValue()).intValue() / (float)classCount;
            if (!((double)ratio > 0.5)) continue;
            vendor.addWeighting((String)entry.getKey());
            if (!addPackagesAsEvidence || ((String)entry.getKey()).length() <= 1) continue;
            vendor.addEvidence("jar", "package name", (String)entry.getKey(), Confidence.LOW);
        }
        for (Map.Entry entry : productIdentifiers.entrySet()) {
            ratio = (float)((Integer)entry.getValue()).intValue() / (float)classCount;
            if (!((double)ratio > 0.5)) continue;
            product.addWeighting((String)entry.getKey());
            if (!addPackagesAsEvidence || ((String)entry.getKey()).length() <= 1) continue;
            product.addEvidence("jar", "package name", (String)entry.getKey(), Confidence.LOW);
        }
    }

    protected boolean parseManifest(Dependency dependency, List<ClassNameInformation> classInformation) throws IOException {
        boolean foundSomething = false;
        try (JarFile jar = new JarFile(dependency.getActualFilePath());){
            Manifest manifest = jar.getManifest();
            if (manifest == null) {
                if (!(dependency.getFileName().toLowerCase().endsWith("-sources.jar") || dependency.getFileName().toLowerCase().endsWith("-javadoc.jar") || dependency.getFileName().toLowerCase().endsWith("-src.jar") || dependency.getFileName().toLowerCase().endsWith("-doc.jar"))) {
                    LOGGER.debug("Jar file '{}' does not contain a manifest.", (Object)dependency.getFileName());
                }
                boolean bl = false;
                return bl;
            }
            EvidenceCollection vendorEvidence = dependency.getVendorEvidence();
            EvidenceCollection productEvidence = dependency.getProductEvidence();
            EvidenceCollection versionEvidence = dependency.getVersionEvidence();
            String source = "Manifest";
            String specificationVersion = null;
            boolean hasImplementationVersion = false;
            Attributes atts = manifest.getMainAttributes();
            for (Map.Entry<Object, Object> entry : atts.entrySet()) {
                String key = entry.getKey().toString();
                String value = atts.getValue(key);
                if (HTML_DETECTION_PATTERN.matcher(value).find()) {
                    value = Jsoup.parse((String)value).text();
                }
                if (IGNORE_VALUES.contains(value)) continue;
                if (key.equalsIgnoreCase(Attributes.Name.IMPLEMENTATION_TITLE.toString())) {
                    foundSomething = true;
                    productEvidence.addEvidence(source, key, value, Confidence.HIGH);
                    JarAnalyzer.addMatchingValues(classInformation, value, productEvidence);
                    continue;
                }
                if (key.equalsIgnoreCase(Attributes.Name.IMPLEMENTATION_VERSION.toString())) {
                    hasImplementationVersion = true;
                    foundSomething = true;
                    versionEvidence.addEvidence(source, key, value, Confidence.HIGH);
                    continue;
                }
                if ("specification-version".equalsIgnoreCase(key)) {
                    specificationVersion = value;
                    continue;
                }
                if (key.equalsIgnoreCase(Attributes.Name.IMPLEMENTATION_VENDOR.toString())) {
                    foundSomething = true;
                    vendorEvidence.addEvidence(source, key, value, Confidence.HIGH);
                    JarAnalyzer.addMatchingValues(classInformation, value, vendorEvidence);
                    continue;
                }
                if (key.equalsIgnoreCase(IMPLEMENTATION_VENDOR_ID)) {
                    foundSomething = true;
                    vendorEvidence.addEvidence(source, key, value, Confidence.MEDIUM);
                    JarAnalyzer.addMatchingValues(classInformation, value, vendorEvidence);
                    continue;
                }
                if (key.equalsIgnoreCase(BUNDLE_DESCRIPTION)) {
                    foundSomething = true;
                    JarAnalyzer.addDescription(dependency, value, "manifest", key);
                    JarAnalyzer.addMatchingValues(classInformation, value, productEvidence);
                    continue;
                }
                if (key.equalsIgnoreCase(BUNDLE_NAME)) {
                    foundSomething = true;
                    productEvidence.addEvidence(source, key, value, Confidence.MEDIUM);
                    JarAnalyzer.addMatchingValues(classInformation, value, productEvidence);
                    continue;
                }
                if (key.equalsIgnoreCase(BUNDLE_VERSION)) {
                    foundSomething = true;
                    versionEvidence.addEvidence(source, key, value, Confidence.HIGH);
                    continue;
                }
                if (key.equalsIgnoreCase(Attributes.Name.MAIN_CLASS.toString()) || IGNORE_KEYS.contains(key = key.toLowerCase()) || key.endsWith("jdk") || key.contains("lastmodified") || key.endsWith("package") || key.endsWith("classpath") || key.endsWith("class-path") || key.endsWith("-scm") || key.startsWith("scm-") || value.trim().startsWith("scm:") || this.isImportPackage(key, value) || this.isPackage(key, value)) continue;
                foundSomething = true;
                if (key.contains("version")) {
                    if (key.contains("specification")) continue;
                    versionEvidence.addEvidence(source, key, value, Confidence.MEDIUM);
                    continue;
                }
                if ("build-id".equals(key)) {
                    int pos = value.indexOf(40);
                    if (pos > 0) {
                        value = value.substring(0, pos - 1);
                    }
                    if ((pos = value.indexOf(91)) > 0) {
                        value = value.substring(0, pos - 1);
                    }
                    versionEvidence.addEvidence(source, key, value, Confidence.MEDIUM);
                    continue;
                }
                if (key.contains("title")) {
                    productEvidence.addEvidence(source, key, value, Confidence.MEDIUM);
                    JarAnalyzer.addMatchingValues(classInformation, value, productEvidence);
                    continue;
                }
                if (key.contains("vendor")) {
                    if (key.contains("specification")) {
                        vendorEvidence.addEvidence(source, key, value, Confidence.LOW);
                        continue;
                    }
                    vendorEvidence.addEvidence(source, key, value, Confidence.MEDIUM);
                    JarAnalyzer.addMatchingValues(classInformation, value, vendorEvidence);
                    continue;
                }
                if (key.contains("name")) {
                    productEvidence.addEvidence(source, key, value, Confidence.MEDIUM);
                    vendorEvidence.addEvidence(source, key, value, Confidence.MEDIUM);
                    JarAnalyzer.addMatchingValues(classInformation, value, vendorEvidence);
                    JarAnalyzer.addMatchingValues(classInformation, value, productEvidence);
                    continue;
                }
                if (key.contains("license")) {
                    this.addLicense(dependency, value);
                    continue;
                }
                if (key.contains("description")) {
                    JarAnalyzer.addDescription(dependency, value, "manifest", key);
                    continue;
                }
                productEvidence.addEvidence(source, key, value, Confidence.LOW);
                vendorEvidence.addEvidence(source, key, value, Confidence.LOW);
                JarAnalyzer.addMatchingValues(classInformation, value, vendorEvidence);
                JarAnalyzer.addMatchingValues(classInformation, value, productEvidence);
                if (!value.matches(".*\\d.*")) continue;
                StringTokenizer tokenizer = new StringTokenizer(value, " ");
                while (tokenizer.hasMoreElements()) {
                    String s = tokenizer.nextToken();
                    if (!s.matches("^[0-9.]+$")) continue;
                    versionEvidence.addEvidence(source, key, s, Confidence.LOW);
                }
            }
            for (Map.Entry<Object, Object> entry : manifest.getEntries().entrySet()) {
                String name = (String)entry.getKey();
                source = "manifest: " + name;
                atts = (Attributes)entry.getValue();
                for (Map.Entry<Object, Object> entry2 : atts.entrySet()) {
                    String key = entry2.getKey().toString();
                    String value = atts.getValue(key);
                    if (key.equalsIgnoreCase(Attributes.Name.IMPLEMENTATION_TITLE.toString())) {
                        foundSomething = true;
                        productEvidence.addEvidence(source, key, value, Confidence.MEDIUM);
                        JarAnalyzer.addMatchingValues(classInformation, value, productEvidence);
                        continue;
                    }
                    if (key.equalsIgnoreCase(Attributes.Name.IMPLEMENTATION_VERSION.toString())) {
                        foundSomething = true;
                        versionEvidence.addEvidence(source, key, value, Confidence.MEDIUM);
                        continue;
                    }
                    if (key.equalsIgnoreCase(Attributes.Name.IMPLEMENTATION_VENDOR.toString())) {
                        foundSomething = true;
                        vendorEvidence.addEvidence(source, key, value, Confidence.MEDIUM);
                        JarAnalyzer.addMatchingValues(classInformation, value, vendorEvidence);
                        continue;
                    }
                    if (!key.equalsIgnoreCase(Attributes.Name.SPECIFICATION_TITLE.toString())) continue;
                    foundSomething = true;
                    productEvidence.addEvidence(source, key, value, Confidence.MEDIUM);
                    JarAnalyzer.addMatchingValues(classInformation, value, productEvidence);
                }
            }
            if (specificationVersion != null && !hasImplementationVersion) {
                foundSomething = true;
                versionEvidence.addEvidence(source, "specification-version", specificationVersion, Confidence.HIGH);
            }
        }
        return foundSomething;
    }

    public static String addDescription(Dependency dependency, String description, String source, String key) {
        if (dependency.getDescription() == null) {
            dependency.setDescription(description);
        }
        String desc = HTML_DETECTION_PATTERN.matcher(description).find() ? Jsoup.parse((String)description).text() : description;
        dependency.setDescription(desc);
        if (desc.length() > 100) {
            desc = desc.replaceAll("\\s\\s+", " ");
            int posSuchAs = desc.toLowerCase().indexOf("such as ", 100);
            int posLike = desc.toLowerCase().indexOf("like ", 100);
            int posWillUse = desc.toLowerCase().indexOf("will use ", 100);
            int posUses = desc.toLowerCase().indexOf(" uses ", 100);
            int pos = -1;
            pos = (pos = Math.max(pos, posSuchAs)) >= 0 && posLike >= 0 ? Math.min(pos, posLike) : Math.max(pos, posLike);
            pos = pos >= 0 && posWillUse >= 0 ? Math.min(pos, posWillUse) : Math.max(pos, posWillUse);
            if ((pos = pos >= 0 && posUses >= 0 ? Math.min(pos, posUses) : Math.max(pos, posUses)) > 0) {
                desc = desc.substring(0, pos) + "...";
            }
            dependency.getProductEvidence().addEvidence(source, key, desc, Confidence.LOW);
            dependency.getVendorEvidence().addEvidence(source, key, desc, Confidence.LOW);
        } else {
            dependency.getProductEvidence().addEvidence(source, key, desc, Confidence.MEDIUM);
            dependency.getVendorEvidence().addEvidence(source, key, desc, Confidence.MEDIUM);
        }
        return desc;
    }

    private void addLicense(Dependency d, String license) {
        if (d.getLicense() == null) {
            d.setLicense(license);
        } else if (!d.getLicense().contains(license)) {
            d.setLicense(d.getLicense() + NEWLINE + license);
        }
    }

    @Override
    public void initializeFileTypeAnalyzer() throws InitializationException {
        try {
            File baseDir = Settings.getTempDirectory();
            this.tempFileLocation = File.createTempFile("check", "tmp", baseDir);
            if (!this.tempFileLocation.delete()) {
                String msg = String.format("Unable to delete temporary file '%s'.", this.tempFileLocation.getAbsolutePath());
                this.setEnabled(false);
                throw new InitializationException(msg);
            }
            if (!this.tempFileLocation.mkdirs()) {
                String msg = String.format("Unable to create directory '%s'.", this.tempFileLocation.getAbsolutePath());
                this.setEnabled(false);
                throw new InitializationException(msg);
            }
        }
        catch (IOException ex) {
            this.setEnabled(false);
            throw new InitializationException("Unable to create a temporary file", ex);
        }
    }

    @Override
    public void closeAnalyzer() {
        if (this.tempFileLocation != null && this.tempFileLocation.exists()) {
            String[] l;
            LOGGER.debug("Attempting to delete temporary files");
            boolean success = FileUtils.delete((File)this.tempFileLocation);
            if (!success && this.tempFileLocation.exists() && (l = this.tempFileLocation.list()) != null && l.length > 0) {
                LOGGER.warn("Failed to delete some temporary files, see the log for more details");
            }
        }
    }

    private boolean isImportPackage(String key, String value) {
        Pattern packageRx = Pattern.compile("^([a-zA-Z0-9_#\\$\\*\\.]+\\s*[,;]\\s*)+([a-zA-Z0-9_#\\$\\*\\.]+\\s*)?$");
        boolean matches = packageRx.matcher(value).matches();
        return matches && (key.contains("import") || key.contains("include") || value.length() > 10);
    }

    private List<ClassNameInformation> collectClassNames(Dependency dependency) {
        ArrayList<ClassNameInformation> classNames = new ArrayList<ClassNameInformation>();
        try (JarFile jar = new JarFile(dependency.getActualFilePath());){
            Enumeration<JarEntry> entries = jar.entries();
            while (entries.hasMoreElements()) {
                JarEntry entry = entries.nextElement();
                String name = entry.getName().toLowerCase();
                if (!name.endsWith(".class") || name.matches("^javax?\\..*$")) continue;
                ClassNameInformation className = new ClassNameInformation(name.substring(0, name.length() - 6));
                classNames.add(className);
            }
        }
        catch (IOException ex) {
            LOGGER.warn("Unable to open jar file '{}'.", (Object)dependency.getFileName());
            LOGGER.debug("", (Throwable)ex);
        }
        return classNames;
    }

    private void analyzeFullyQualifiedClassNames(List<ClassNameInformation> classNames, Map<String, Integer> vendor, Map<String, Integer> product) {
        for (ClassNameInformation entry : classNames) {
            ArrayList<String> list = entry.getPackageStructure();
            this.addEntry(vendor, (String)list.get(0));
            if (list.size() == 2) {
                this.addEntry(product, (String)list.get(1));
                continue;
            }
            if (list.size() == 3) {
                this.addEntry(vendor, (String)list.get(1));
                this.addEntry(product, (String)list.get(1));
                this.addEntry(product, (String)list.get(2));
                continue;
            }
            if (list.size() < 4) continue;
            this.addEntry(vendor, (String)list.get(1));
            this.addEntry(vendor, (String)list.get(2));
            this.addEntry(product, (String)list.get(1));
            this.addEntry(product, (String)list.get(2));
            this.addEntry(product, (String)list.get(3));
        }
    }

    private void addEntry(Map<String, Integer> collection, String key) {
        if (collection.containsKey(key)) {
            collection.put(key, collection.get(key) + 1);
        } else {
            collection.put(key, 1);
        }
    }

    private static void addMatchingValues(List<ClassNameInformation> classes, String value, EvidenceCollection evidence) {
        if (value == null || value.isEmpty() || classes == null || classes.isEmpty()) {
            return;
        }
        String text = value.toLowerCase();
        for (ClassNameInformation cni : classes) {
            for (String key : cni.getPackageStructure()) {
                Pattern p = Pattern.compile("\b" + key + "\b");
                if (!p.matcher(text).find()) continue;
                evidence.addEvidence("jar", "package name", key, Confidence.HIGHEST);
            }
        }
    }

    private boolean isPackage(String key, String value) {
        return !key.matches(".*(version|title|vendor|name|license|description).*") && value.matches("^([a-zA-Z_][a-zA-Z0-9_\\$]*(\\.[a-zA-Z_][a-zA-Z0-9_\\$]*)*)?$");
    }

    public static void extractLicense(Model pom, Dependency dependency) {
        if (pom.getLicenses() != null) {
            String license = null;
            for (License lic : pom.getLicenses()) {
                String tmp = null;
                if (lic.getName() != null) {
                    tmp = lic.getName();
                }
                if (lic.getUrl() != null) {
                    tmp = tmp == null ? lic.getUrl() : tmp + ": " + lic.getUrl();
                }
                if (tmp == null) continue;
                if (HTML_DETECTION_PATTERN.matcher(tmp).find()) {
                    tmp = Jsoup.parse((String)tmp).text();
                }
                if (license == null) {
                    license = tmp;
                    continue;
                }
                license = license + "\n" + tmp;
            }
            if (license != null) {
                dependency.setLicense(license);
            }
        }
    }

    private File getNextTempDirectory() throws AnalysisException {
        int dirCount = DIR_COUNT.incrementAndGet();
        File directory = new File(this.tempFileLocation, String.valueOf(dirCount));
        if (directory.exists()) {
            return this.getNextTempDirectory();
        }
        if (!directory.mkdirs()) {
            String msg = String.format("Unable to create temp directory '%s'.", directory.getAbsolutePath());
            throw new AnalysisException(msg);
        }
        return directory;
    }

    protected static class ClassNameInformation {
        private String name;
        private final ArrayList<String> packageStructure = new ArrayList();

        ClassNameInformation(String className) {
            this.name = className;
            if (this.name.contains("/")) {
                String[] tmp = StringUtils.split((String)className.toLowerCase(), (char)'/');
                int start = 0;
                int end = 3;
                if ("com".equals(tmp[0]) || "org".equals(tmp[0])) {
                    start = 1;
                    end = 4;
                }
                if (tmp.length <= end) {
                    end = tmp.length - 1;
                }
                this.packageStructure.addAll(Arrays.asList(tmp).subList(start, end + 1));
            } else {
                this.packageStructure.add(this.name);
            }
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public ArrayList<String> getPackageStructure() {
            return this.packageStructure;
        }
    }
}

