/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.owasp.dependencycheck.AnalysisTask;
import org.owasp.dependencycheck.analyzer.AnalysisPhase;
import org.owasp.dependencycheck.analyzer.Analyzer;
import org.owasp.dependencycheck.analyzer.AnalyzerService;
import org.owasp.dependencycheck.analyzer.FileTypeAnalyzer;
import org.owasp.dependencycheck.data.nvdcve.ConnectionFactory;
import org.owasp.dependencycheck.data.nvdcve.CveDB;
import org.owasp.dependencycheck.data.nvdcve.DatabaseException;
import org.owasp.dependencycheck.data.nvdcve.DatabaseProperties;
import org.owasp.dependencycheck.data.update.CachedWebDataSource;
import org.owasp.dependencycheck.data.update.UpdateService;
import org.owasp.dependencycheck.data.update.exception.UpdateException;
import org.owasp.dependencycheck.dependency.Dependency;
import org.owasp.dependencycheck.exception.ExceptionCollection;
import org.owasp.dependencycheck.exception.InitializationException;
import org.owasp.dependencycheck.exception.NoDataException;
import org.owasp.dependencycheck.exception.ReportException;
import org.owasp.dependencycheck.reporting.ReportGenerator;
import org.owasp.dependencycheck.utils.InvalidSettingException;
import org.owasp.dependencycheck.utils.Settings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Engine
implements FileFilter,
AutoCloseable {
    private final List<Dependency> dependencies = Collections.synchronizedList(new ArrayList());
    private final Map<AnalysisPhase, List<Analyzer>> analyzers = new EnumMap<AnalysisPhase, List<Analyzer>>(AnalysisPhase.class);
    private final Set<FileTypeAnalyzer> fileTypeAnalyzers = new HashSet<FileTypeAnalyzer>();
    private final Mode mode;
    private ClassLoader serviceClassLoader;
    private CveDB database = null;
    private static final Logger LOGGER = LoggerFactory.getLogger(Engine.class);

    public Engine() {
        this(Mode.STANDALONE);
    }

    public Engine(Mode mode) {
        this(Thread.currentThread().getContextClassLoader(), mode);
    }

    public Engine(ClassLoader serviceClassLoader) {
        this(serviceClassLoader, Mode.STANDALONE);
    }

    public Engine(ClassLoader serviceClassLoader, Mode mode) {
        this.serviceClassLoader = serviceClassLoader;
        this.mode = mode;
        this.initializeEngine();
    }

    protected final void initializeEngine() {
        if (this.mode.isDatabseRequired()) {
            ConnectionFactory.initialize();
        }
        this.loadAnalyzers();
    }

    public void cleanup() {
        if (this.mode.isDatabseRequired()) {
            if (this.database != null) {
                this.database.close();
                this.database = null;
            }
            ConnectionFactory.cleanup();
        }
    }

    @Override
    public void close() {
        this.cleanup();
    }

    private void loadAnalyzers() {
        if (!this.analyzers.isEmpty()) {
            return;
        }
        for (AnalysisPhase phase : this.mode.getPhases()) {
            this.analyzers.put(phase, new ArrayList());
        }
        AnalyzerService service = new AnalyzerService(this.serviceClassLoader);
        List<Analyzer> iterator = service.getAnalyzers(this.mode.getPhases());
        for (Analyzer a : iterator) {
            this.analyzers.get((Object)a.getAnalysisPhase()).add(a);
            if (!(a instanceof FileTypeAnalyzer)) continue;
            this.fileTypeAnalyzers.add((FileTypeAnalyzer)a);
        }
    }

    public List<Analyzer> getAnalyzers(AnalysisPhase phase) {
        return this.analyzers.get((Object)phase);
    }

    public synchronized List<Dependency> getDependencies() {
        return this.dependencies;
    }

    public synchronized void setDependencies(List<Dependency> dependencies) {
        this.dependencies.clear();
        this.dependencies.addAll(dependencies);
    }

    public List<Dependency> scan(String[] paths) {
        return this.scan(paths, null);
    }

    public List<Dependency> scan(String[] paths, String projectReference) {
        ArrayList<Dependency> deps = new ArrayList<Dependency>();
        for (String path : paths) {
            List<Dependency> d = this.scan(path, projectReference);
            if (d == null) continue;
            deps.addAll(d);
        }
        return deps;
    }

    public List<Dependency> scan(String path) {
        return this.scan(path, null);
    }

    public List<Dependency> scan(String path, String projectReference) {
        File file = new File(path);
        return this.scan(file, projectReference);
    }

    public List<Dependency> scan(File[] files) {
        return this.scan(files, null);
    }

    public List<Dependency> scan(File[] files, String projectReference) {
        ArrayList<Dependency> deps = new ArrayList<Dependency>();
        for (File file : files) {
            List<Dependency> d = this.scan(file, projectReference);
            if (d == null) continue;
            deps.addAll(d);
        }
        return deps;
    }

    public List<Dependency> scan(Collection<File> files) {
        return this.scan(files, null);
    }

    public List<Dependency> scan(Collection<File> files, String projectReference) {
        ArrayList<Dependency> deps = new ArrayList<Dependency>();
        for (File file : files) {
            List<Dependency> d = this.scan(file, projectReference);
            if (d == null) continue;
            deps.addAll(d);
        }
        return deps;
    }

    public List<Dependency> scan(File file) {
        return this.scan(file, null);
    }

    public List<Dependency> scan(File file, String projectReference) {
        if (file.exists()) {
            if (file.isDirectory()) {
                return this.scanDirectory(file, projectReference);
            }
            Dependency d = this.scanFile(file, projectReference);
            if (d != null) {
                ArrayList<Dependency> deps = new ArrayList<Dependency>();
                deps.add(d);
                return deps;
            }
        }
        return null;
    }

    protected List<Dependency> scanDirectory(File dir) {
        return this.scanDirectory(dir, null);
    }

    protected List<Dependency> scanDirectory(File dir, String projectReference) {
        File[] files = dir.listFiles();
        ArrayList<Dependency> deps = new ArrayList<Dependency>();
        if (files != null) {
            for (File f : files) {
                List<Dependency> d;
                if (f.isDirectory()) {
                    d = this.scanDirectory(f, projectReference);
                    if (d == null) continue;
                    deps.addAll((Collection<Dependency>)d);
                    continue;
                }
                d = this.scanFile(f, projectReference);
                deps.add((Dependency)((Object)d));
            }
        }
        return deps;
    }

    protected Dependency scanFile(File file) {
        return this.scanFile(file, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Dependency scanFile(File file, String projectReference) {
        Dependency dependency = null;
        if (file.isFile()) {
            if (this.accept(file)) {
                dependency = new Dependency(file);
                if (projectReference != null) {
                    dependency.addProjectReference(projectReference);
                }
                String sha1 = dependency.getSha1sum();
                boolean found = false;
                List<Dependency> list = this.dependencies;
                synchronized (list) {
                    if (sha1 != null) {
                        for (Dependency existing : this.dependencies) {
                            if (!sha1.equals(existing.getSha1sum())) continue;
                            found = true;
                            if (projectReference != null) {
                                existing.addProjectReference(projectReference);
                            }
                            if (existing.getActualFilePath() != null && dependency.getActualFilePath() != null && !existing.getActualFilePath().equals(dependency.getActualFilePath())) {
                                existing.addRelatedDependency(dependency);
                                break;
                            }
                            dependency = existing;
                            break;
                        }
                    }
                    if (!found) {
                        this.dependencies.add(dependency);
                    }
                }
            } else {
                LOGGER.debug("Path passed to scanFile(File) is not a file that can be scanned by dependency-check: {}. Skipping the file.", (Object)file);
            }
        }
        return dependency;
    }

    public void analyzeDependencies() throws ExceptionCollection {
        List<Analyzer> analyzerList;
        List<Throwable> exceptions = Collections.synchronizedList(new ArrayList());
        this.initializeAndUpdateDatabase(exceptions);
        try {
            this.ensureDataExists();
        }
        catch (NoDataException ex) {
            this.throwFatalExceptionCollection("Unable to continue dependency-check analysis.", ex, exceptions);
        }
        LOGGER.debug("\n----------------------------------------------------\nBEGIN ANALYSIS\n----------------------------------------------------");
        LOGGER.info("Analysis Started");
        long analysisStart = System.currentTimeMillis();
        for (AnalysisPhase phase : this.mode.getPhases()) {
            analyzerList = this.analyzers.get((Object)phase);
            for (Analyzer analyzer : analyzerList) {
                long analyzerStart = System.currentTimeMillis();
                try {
                    this.initializeAnalyzer(analyzer);
                }
                catch (InitializationException ex) {
                    exceptions.add(ex);
                    continue;
                }
                if (analyzer.isEnabled()) {
                    this.executeAnalysisTasks(analyzer, exceptions);
                    long analyzerDurationMillis = System.currentTimeMillis() - analyzerStart;
                    long analyzerDurationSeconds = TimeUnit.MILLISECONDS.toSeconds(analyzerDurationMillis);
                    LOGGER.info("Finished {} ({} seconds)", (Object)analyzer.getName(), (Object)analyzerDurationSeconds);
                    continue;
                }
                LOGGER.debug("Skipping {} (not enabled)", (Object)analyzer.getName());
            }
        }
        for (AnalysisPhase phase : this.mode.getPhases()) {
            analyzerList = this.analyzers.get((Object)phase);
            for (Analyzer a : analyzerList) {
                this.closeAnalyzer(a);
            }
        }
        LOGGER.debug("\n----------------------------------------------------\nEND ANALYSIS\n----------------------------------------------------");
        long analysisDurationSeconds = TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis() - analysisStart);
        LOGGER.info("Analysis Complete ({} seconds)", (Object)analysisDurationSeconds);
        if (exceptions.size() > 0) {
            throw new ExceptionCollection("One or more exceptions occurred during dependency-check analysis", exceptions);
        }
    }

    private void initializeAndUpdateDatabase(List<Throwable> exceptions) throws ExceptionCollection {
        if (!this.mode.isDatabseRequired()) {
            return;
        }
        boolean autoUpdate = true;
        try {
            autoUpdate = Settings.getBoolean((String)"autoupdate");
        }
        catch (InvalidSettingException ex) {
            LOGGER.debug("Invalid setting for auto-update; using true.");
            exceptions.add(ex);
        }
        if (autoUpdate) {
            try {
                this.database = CveDB.getInstance();
                this.doUpdates();
            }
            catch (UpdateException ex) {
                exceptions.add(ex);
                LOGGER.warn("Unable to update Cached Web DataSource, using local data instead. Results may not include recent vulnerabilities.");
                LOGGER.debug("Update Error", (Throwable)ex);
            }
            catch (DatabaseException ex) {
                throw new ExceptionCollection("Unable to connect to the database", ex);
            }
        } else {
            try {
                if (ConnectionFactory.isH2Connection() && !ConnectionFactory.h2DataFileExists()) {
                    throw new ExceptionCollection(new NoDataException("Autoupdate is disabled and the database does not exist"), true);
                }
                this.database = CveDB.getInstance();
            }
            catch (IOException ex) {
                throw new ExceptionCollection(new DatabaseException("Autoupdate is disabled and unable to connect to the database"), true);
            }
            catch (DatabaseException ex) {
                this.throwFatalExceptionCollection("Unable to connect to the dependency-check database.", ex, exceptions);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void executeAnalysisTasks(Analyzer analyzer, List<Throwable> exceptions) throws ExceptionCollection {
        LOGGER.debug("Starting {}", (Object)analyzer.getName());
        List<AnalysisTask> analysisTasks = this.getAnalysisTasks(analyzer, exceptions);
        ExecutorService executorService = this.getExecutorService(analyzer);
        try {
            List results = executorService.invokeAll(analysisTasks, 10L, TimeUnit.MINUTES);
            for (Future result : results) {
                try {
                    result.get();
                }
                catch (ExecutionException e) {
                    this.throwFatalExceptionCollection("Analysis task failed with a fatal exception.", e, exceptions);
                }
                catch (CancellationException e) {
                    this.throwFatalExceptionCollection("Analysis task timed out.", e, exceptions);
                }
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            this.throwFatalExceptionCollection("Analysis has been interrupted.", e, exceptions);
        }
        finally {
            executorService.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<AnalysisTask> getAnalysisTasks(Analyzer analyzer, List<Throwable> exceptions) {
        ArrayList<AnalysisTask> result = new ArrayList<AnalysisTask>();
        List<Dependency> list = this.dependencies;
        synchronized (list) {
            for (Dependency dependency : this.dependencies) {
                AnalysisTask task = new AnalysisTask(analyzer, dependency, this, exceptions, Settings.getInstance());
                result.add(task);
            }
        }
        return result;
    }

    protected ExecutorService getExecutorService(Analyzer analyzer) {
        if (analyzer.supportsParallelProcessing()) {
            int maximumNumberOfThreads = Runtime.getRuntime().availableProcessors();
            LOGGER.debug("Parallel processing with up to {} threads: {}.", (Object)maximumNumberOfThreads, (Object)analyzer.getName());
            return Executors.newFixedThreadPool(maximumNumberOfThreads);
        }
        LOGGER.debug("Parallel processing is not supported: {}.", (Object)analyzer.getName());
        return Executors.newSingleThreadExecutor();
    }

    protected void initializeAnalyzer(Analyzer analyzer) throws InitializationException {
        try {
            LOGGER.debug("Initializing {}", (Object)analyzer.getName());
            analyzer.initialize();
        }
        catch (InitializationException ex) {
            LOGGER.error("Exception occurred initializing {}.", (Object)analyzer.getName());
            LOGGER.debug("", (Throwable)ex);
            try {
                analyzer.close();
            }
            catch (Throwable ex1) {
                LOGGER.trace("", ex1);
            }
            throw ex;
        }
        catch (Throwable ex) {
            LOGGER.error("Unexpected exception occurred initializing {}.", (Object)analyzer.getName());
            LOGGER.debug("", ex);
            try {
                analyzer.close();
            }
            catch (Throwable ex1) {
                LOGGER.trace("", ex1);
            }
            throw new InitializationException("Unexpected Exception", ex);
        }
    }

    protected void closeAnalyzer(Analyzer analyzer) {
        LOGGER.debug("Closing Analyzer '{}'", (Object)analyzer.getName());
        try {
            analyzer.close();
        }
        catch (Throwable ex) {
            LOGGER.trace("", ex);
        }
    }

    public void doUpdates() throws UpdateException {
        if (this.mode.isDatabseRequired()) {
            LOGGER.info("Checking for updates");
            long updateStart = System.currentTimeMillis();
            UpdateService service = new UpdateService(this.serviceClassLoader);
            Iterator<CachedWebDataSource> iterator = service.getDataSources();
            while (iterator.hasNext()) {
                CachedWebDataSource source = iterator.next();
                source.update();
            }
            LOGGER.info("Check for updates complete ({} ms)", (Object)(System.currentTimeMillis() - updateStart));
        } else {
            LOGGER.info("Skipping update check in evidence collection mode.");
        }
    }

    public List<Analyzer> getAnalyzers() {
        ArrayList<Analyzer> ret = new ArrayList<Analyzer>();
        for (AnalysisPhase phase : this.mode.getPhases()) {
            List<Analyzer> analyzerList = this.analyzers.get((Object)phase);
            ret.addAll(analyzerList);
        }
        return ret;
    }

    @Override
    public boolean accept(File file) {
        if (file == null) {
            return false;
        }
        boolean scan = false;
        for (FileTypeAnalyzer a : this.fileTypeAnalyzers) {
            scan |= a.accept(file);
        }
        return scan;
    }

    public Set<FileTypeAnalyzer> getFileTypeAnalyzers() {
        return this.fileTypeAnalyzers;
    }

    protected void addFileTypeAnalyzer(FileTypeAnalyzer fta) {
        this.fileTypeAnalyzers.add(fta);
    }

    private void ensureDataExists() throws NoDataException {
        if (this.mode.isDatabseRequired() && (this.database == null || !this.database.dataExists())) {
            throw new NoDataException("No documents exist");
        }
    }

    private void throwFatalExceptionCollection(String message, Throwable throwable, List<Throwable> exceptions) throws ExceptionCollection {
        LOGGER.error("{}\n\n{}", (Object)throwable.getMessage(), (Object)message);
        LOGGER.debug("", throwable);
        exceptions.add(throwable);
        throw new ExceptionCollection(message, exceptions, true);
    }

    public synchronized void writeReports(String applicationName, String groupId, String artifactId, String version, File outputDir, String format) throws ReportException {
        if (this.mode == Mode.EVIDENCE_COLLECTION) {
            throw new UnsupportedOperationException("Cannot generate report in evidence collection mode.");
        }
        DatabaseProperties prop = this.database.getDatabaseProperties();
        ReportGenerator r = new ReportGenerator(applicationName, groupId, artifactId, version, this.dependencies, this.getAnalyzers(), prop);
        try {
            r.write(outputDir.getAbsolutePath(), format);
        }
        catch (ReportException ex) {
            String msg = String.format("Error generating the report for %s", applicationName);
            throw new ReportException(msg, ex);
        }
    }

    public void writeReports(String applicationName, File outputDir, String format) throws ReportException {
        this.writeReports(applicationName, null, null, null, outputDir, format);
    }

    public static enum Mode {
        EVIDENCE_COLLECTION(false, AnalysisPhase.INITIAL, AnalysisPhase.PRE_INFORMATION_COLLECTION, AnalysisPhase.INFORMATION_COLLECTION, AnalysisPhase.POST_INFORMATION_COLLECTION),
        EVIDENCE_PROCESSING(true, AnalysisPhase.PRE_IDENTIFIER_ANALYSIS, AnalysisPhase.IDENTIFIER_ANALYSIS, AnalysisPhase.POST_IDENTIFIER_ANALYSIS, AnalysisPhase.PRE_FINDING_ANALYSIS, AnalysisPhase.FINDING_ANALYSIS, AnalysisPhase.POST_FINDING_ANALYSIS, AnalysisPhase.FINAL),
        STANDALONE(true, AnalysisPhase.values());

        private final boolean databaseRequired;
        private final AnalysisPhase[] phases;

        public boolean isDatabseRequired() {
            return this.databaseRequired;
        }

        public AnalysisPhase[] getPhases() {
            return this.phases;
        }

        private Mode(boolean databaseRequired, AnalysisPhase ... phases) {
            this.databaseRequired = databaseRequired;
            this.phases = phases;
        }
    }
}

