/*
 * This file is part of dependency-check-core.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Copyright (c) 2017 Jeremy Long. All Rights Reserved.
 */
package org.owasp.dependencycheck.exception;

/**
 * An exception used when trying to obtain a lock on the H2 database.
 *
 * @author Jeremy Long
 */
public class H2DBLockException extends Exception {

    /**
     * The serial version uid.
     */
    private static final long serialVersionUID = 1L;

    /**
     * Creates a new H2DBLockException.
     */
    public H2DBLockException() {
        super();
    }

    /**
     * Creates a new H2DBLockException.
     *
     * @param msg a message for the exception.
     */
    public H2DBLockException(String msg) {
        super(msg);
    }

    /**
     * Creates a new H2DBLockException.
     *
     * @param ex the cause of the exception.
     */
    public H2DBLockException(Throwable ex) {
        super(ex);
    }

    /**
     * Creates a new H2DBLockException.
     *
     * @param msg a message for the exception.
     * @param ex the cause of the exception.
     */
    public H2DBLockException(String msg, Throwable ex) {
        super(msg, ex);
    }
}
