/*
 * This file is part of dependency-check-core.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Copyright (c) 2012 Jeremy Long. All Rights Reserved.
 */
package org.owasp.dependencycheck.dependency;

import java.io.Serializable;
import java.util.Comparator;

/**
 * Comparator for Vulnerability objects.
 *
 * @author Jeremy Long
 */
public class VulnerabilityComparator implements Comparator<Vulnerability>, Serializable {

    /**
     * The serial version UID.
     */
    private static final long serialVersionUID = 1L;

    /**
     * Implements the comparison of vulnerabilities.
     *
     * @param o1 a vulnerability
     * @param o2 a second vulnerability
     * @return the comparison
     */
    @Override
    public int compare(Vulnerability o1, Vulnerability o2) {
        return o2.getName().compareTo(o1.getName());
    }
}
