/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.reporting;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Set;
import org.apache.commons.lang3.StringEscapeUtils;
import org.owasp.dependencycheck.dependency.Identifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EscapeTool {
    private static final Logger LOGGER = LoggerFactory.getLogger(EscapeTool.class);

    public String url(String text) {
        if (text == null || text.isEmpty()) {
            return text;
        }
        try {
            return URLEncoder.encode(text, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            LOGGER.warn("UTF-8 is not supported?");
            LOGGER.info("", (Throwable)ex);
            return "";
        }
    }

    public String html(String text) {
        if (text == null || text.isEmpty()) {
            return text;
        }
        return StringEscapeUtils.escapeHtml4((String)text);
    }

    public String xml(String text) {
        if (text == null || text.isEmpty()) {
            return text;
        }
        return StringEscapeUtils.escapeXml11((String)text);
    }

    public String json(String text) {
        if (text == null || text.isEmpty()) {
            return text;
        }
        return StringEscapeUtils.escapeJson((String)text);
    }

    public String csv(String text) {
        if (text == null || text.isEmpty()) {
            return text;
        }
        return StringEscapeUtils.escapeCsv((String)text.trim().replace("\n", " "));
    }

    public String csvIdentifiers(Set<Identifier> ids) {
        if (ids == null || ids.isEmpty()) {
            return "";
        }
        boolean addComma = false;
        StringBuilder sb = new StringBuilder();
        for (Identifier id : ids) {
            if ("cpe".equals(id.getType())) continue;
            if (addComma) {
                sb.append(", ");
            } else {
                addComma = true;
            }
            sb.append(id.getValue());
        }
        return StringEscapeUtils.escapeCsv((String)sb.toString());
    }

    public String csvCpe(Set<Identifier> ids) {
        if (ids == null || ids.isEmpty()) {
            return "";
        }
        boolean addComma = false;
        StringBuilder sb = new StringBuilder();
        for (Identifier id : ids) {
            if (!"cpe".equals(id.getType())) continue;
            if (addComma) {
                sb.append(", ");
            } else {
                addComma = true;
            }
            sb.append(id.getValue());
        }
        return StringEscapeUtils.escapeCsv((String)sb.toString());
    }
}

