/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.data.nsp;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import javax.json.Json;
import javax.json.JsonObject;
import javax.net.ssl.SSLHandshakeException;
import org.owasp.dependencycheck.analyzer.exception.AnalysisException;
import org.owasp.dependencycheck.data.nsp.Advisory;
import org.owasp.dependencycheck.utils.Settings;
import org.owasp.dependencycheck.utils.URLConnectionFactory;
import org.owasp.dependencycheck.utils.URLConnectionFailureException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NspSearch {
    private final URL nspCheckUrl;
    private final boolean useProxy;
    private static final Logger LOGGER = LoggerFactory.getLogger(NspSearch.class);

    public NspSearch(URL nspCheckUrl) {
        this.nspCheckUrl = nspCheckUrl;
        if (null != Settings.getString((String)"proxy.server")) {
            this.useProxy = true;
            LOGGER.debug("Using proxy");
        } else {
            this.useProxy = false;
            LOGGER.debug("Not using proxy");
        }
    }

    /*
     * Unable to fully structure code
     */
    public List<Advisory> submitPackage(JsonObject packageJson) throws AnalysisException, IOException {
        try {
            result = new ArrayList<Advisory>();
            packageDatabytes = packageJson.toString().getBytes(StandardCharsets.UTF_8);
            conn = URLConnectionFactory.createHttpURLConnection((URL)this.nspCheckUrl, (boolean)this.useProxy);
            conn.setDoOutput(true);
            conn.setDoInput(true);
            conn.setRequestMethod("POST");
            conn.setRequestProperty("X-NSP-VERSION", "2.6.2");
            conn.setRequestProperty("Content-Type", "application/json");
            conn.setRequestProperty("Content-Length", Integer.toString(packageDatabytes.length));
            conn.connect();
            os = new BufferedOutputStream(conn.getOutputStream());
            var6_8 = null;
            try {
                os.write(packageDatabytes);
                os.flush();
            }
            catch (Throwable var7_10) {
                var6_8 = var7_10;
                throw var7_10;
            }
            finally {
                if (os != null) {
                    if (var6_8 != null) {
                        try {
                            os.close();
                        }
                        catch (Throwable var7_9) {
                            var6_8.addSuppressed(var7_9);
                        }
                    } else {
                        os.close();
                    }
                }
            }
            switch (conn.getResponseCode()) {
                case 200: {
                    in = new BufferedInputStream(conn.getInputStream());
                    var6_8 = null;
                    jsonReader = Json.createReader((InputStream)in);
                    var8_15 = null;
                    try {
                        array = jsonReader.readArray();
                        if (array != null) {
                            for (i = 0; i < array.size(); ++i) {
                                object = array.getJsonObject(i);
                                advisory = new Advisory();
                                advisory.setId(object.getInt("id"));
                                advisory.setUpdatedAt(object.getString("updated_at", null));
                                advisory.setCreatedAt(object.getString("created_at", null));
                                advisory.setPublishDate(object.getString("publish_date", null));
                                advisory.setOverview(object.getString("overview"));
                                advisory.setRecommendation(object.getString("recommendation", null));
                                advisory.setCvssVector(object.getString("cvss_vector", null));
                                advisory.setCvssScore(Float.parseFloat(object.getJsonNumber("cvss_score").toString()));
                                advisory.setModule(object.getString("module", null));
                                advisory.setVersion(object.getString("version", null));
                                advisory.setVulnerableVersions(object.getString("vulnerable_versions", null));
                                advisory.setPatchedVersions(object.getString("patched_versions", null));
                                advisory.setTitle(object.getString("title", null));
                                advisory.setAdvisory(object.getString("advisory", null));
                                jsonPath = object.getJsonArray("path");
                                stringPath = new ArrayList<String>();
                                for (j = 0; j < jsonPath.size(); ++j) {
                                    stringPath.add(jsonPath.getString(j));
                                }
                                advisory.setPath(stringPath.toArray(new String[stringPath.size()]));
                                result.add(advisory);
                            }
                        }
                    }
                    catch (Throwable var9_19) {
                        var8_15 = var9_19;
                        throw var9_19;
                    }
                    finally {
                        if (jsonReader != null) {
                            if (var8_15 != null) {
                                try {
                                    jsonReader.close();
                                }
                                catch (Throwable var9_18) {
                                    var8_15.addSuppressed(var9_18);
                                }
                            } else {
                                jsonReader.close();
                            }
                        }
                    }
                    if (in == null) break;
                    if (var6_8 == null) ** GOTO lbl93
                    try {
                        in.close();
                    }
                    catch (Throwable var7_12) {
                        var6_8.addSuppressed(var7_12);
                    }
                    break;
lbl93:
                    // 1 sources

                    in.close();
                    break;
                    catch (Throwable var7_13) {
                        try {
                            var6_8 = var7_13;
                            throw var7_13;
                        }
                        catch (Throwable var18_28) {
                            if (in != null) {
                                if (var6_8 != null) {
                                    try {
                                        in.close();
                                    }
                                    catch (Throwable var19_29) {
                                        var6_8.addSuppressed(var19_29);
                                    }
                                } else {
                                    in.close();
                                }
                            }
                            throw var18_28;
                        }
                    }
                }
                case 400: {
                    NspSearch.LOGGER.debug("Invalid payload submitted to Node Security Platform. Received response code: {} {}", (Object)conn.getResponseCode(), (Object)conn.getResponseMessage());
                    throw new AnalysisException("Could not perform NSP analysis. Invalid payload submitted to Node Security Platform.");
                }
                default: {
                    NspSearch.LOGGER.debug("Could not connect to Node Security Platform. Received response code: {} {}", (Object)conn.getResponseCode(), (Object)conn.getResponseMessage());
                    throw new IOException("Could not connect to Node Security Platform");
                }
            }
            return result;
        }
        catch (IOException ex) {
            if (ex instanceof SSLHandshakeException && ex.getMessage().contains("unable to find valid certification path to requested target")) {
                msg = String.format("Unable to connect to '%s' - the Java trust store does not contain a trusted root for the cert.  Please see https://github.com/jeremylong/InstallCert for one method of updating the trusted certificates.", new Object[]{this.nspCheckUrl});
                throw new URLConnectionFailureException(msg, (Throwable)ex);
            }
            throw ex;
        }
    }
}

