/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.analyzer;

import org.owasp.dependencycheck.Engine;
import org.owasp.dependencycheck.analyzer.Analyzer;
import org.owasp.dependencycheck.analyzer.exception.AnalysisException;
import org.owasp.dependencycheck.dependency.Dependency;
import org.owasp.dependencycheck.exception.InitializationException;
import org.owasp.dependencycheck.utils.InvalidSettingException;
import org.owasp.dependencycheck.utils.Settings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractAnalyzer
implements Analyzer {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractAnalyzer.class);
    private volatile boolean enabled = true;

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    protected abstract String getAnalyzerEnabledSettingKey();

    protected abstract void analyzeDependency(Dependency var1, Engine var2) throws AnalysisException;

    protected void initializeAnalyzer() throws InitializationException {
    }

    protected void closeAnalyzer() throws Exception {
    }

    @Override
    public final void analyze(Dependency dependency, Engine engine) throws AnalysisException {
        if (this.isEnabled()) {
            this.analyzeDependency(dependency, engine);
        }
    }

    @Override
    public final void initialize() throws InitializationException {
        String key = this.getAnalyzerEnabledSettingKey();
        try {
            this.setEnabled(Settings.getBoolean((String)key, (boolean)true));
        }
        catch (InvalidSettingException ex) {
            LOGGER.warn("Invalid setting for property '{}'", (Object)key);
            LOGGER.debug("", (Throwable)ex);
        }
        if (this.isEnabled()) {
            this.initializeAnalyzer();
        } else {
            LOGGER.debug("{} has been disabled", (Object)this.getName());
        }
    }

    @Override
    public final void close() throws Exception {
        if (this.isEnabled()) {
            this.closeAnalyzer();
        }
    }

    @Override
    public boolean supportsParallelProcessing() {
        return true;
    }
}

