/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.analyzer;

import java.io.InputStream;
import java.util.List;
import java.util.Set;
import org.owasp.dependencycheck.analyzer.AbstractAnalyzer;
import org.owasp.dependencycheck.exception.InitializationException;
import org.owasp.dependencycheck.utils.FileUtils;
import org.owasp.dependencycheck.utils.Settings;
import org.owasp.dependencycheck.xml.suppression.SuppressionParseException;
import org.owasp.dependencycheck.xml.suppression.SuppressionParser;
import org.owasp.dependencycheck.xml.suppression.SuppressionRule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public abstract class AbstractSuppressionAnalyzer
extends AbstractAnalyzer {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractSuppressionAnalyzer.class);
    private List<SuppressionRule> rules;

    public Set<String> getSupportedExtensions() {
        return null;
    }

    @Override
    public void initializeAnalyzer() throws InitializationException {
        try {
            this.loadSuppressionData();
        }
        catch (SuppressionParseException ex) {
            throw new InitializationException("Error initializing the suppression analyzer: " + ex.getLocalizedMessage(), ex);
        }
    }

    public List<SuppressionRule> getRules() {
        return this.rules;
    }

    public void setRules(List<SuppressionRule> rules) {
        this.rules = rules;
    }

    private void loadSuppressionData() throws SuppressionParseException {
        SuppressionParser parser = new SuppressionParser();
        try {
            InputStream in = FileUtils.getResourceAsStream((String)"dependencycheck-base-suppression.xml");
            this.rules = parser.parseSuppressionRules(in);
        }
        catch (SAXException ex) {
            throw new SuppressionParseException("Unable to parse the base suppression data file", ex);
        }
        String[] suppressionFilePaths = Settings.getArray((String)"suppression.file");
        if (suppressionFilePaths == null || suppressionFilePaths.length == 0) {
            return;
        }
        for (String suppressionFilePath : suppressionFilePaths) {
            this.loadSuppressionFile(parser, suppressionFilePath);
        }
        LOGGER.debug("{} suppression rules were loaded.", (Object)this.rules.size());
    }

    /*
     * Exception decompiling
     */
    private void loadSuppressionFile(SuppressionParser parser, String suppressionFilePath) throws SuppressionParseException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [20[CATCHBLOCK]], but top level block is 10[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void throwSuppressionParseException(String message, Exception exception) throws SuppressionParseException {
        LOGGER.warn(message);
        LOGGER.debug("", (Throwable)exception);
        throw new SuppressionParseException(message, exception);
    }
}

