/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.xml.hints;

import java.util.ArrayList;
import java.util.List;
import org.owasp.dependencycheck.dependency.Confidence;
import org.owasp.dependencycheck.xml.hints.HintRule;
import org.owasp.dependencycheck.xml.hints.VendorDuplicatingHintRule;
import org.owasp.dependencycheck.xml.suppression.PropertyType;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class HintHandler
extends DefaultHandler {
    private static final String HINT = "hint";
    private static final String GIVEN = "given";
    private static final String ADD = "add";
    private static final String REMOVE = "remove";
    private static final String EVIDENCE = "evidence";
    private static final String FILE_NAME = "fileName";
    private static final String VENDOR_DUPLICATING_RULE = "vendorDuplicatingHint";
    private static final String DUPLICATE = "duplicate";
    private static final String VENDOR = "vendor";
    private static final String PRODUCT = "product";
    private static final String VERSION = "version";
    private static final String CONFIDENCE = "confidence";
    private static final String VALUE = "value";
    private static final String NAME = "name";
    private static final String SOURCE = "source";
    private static final String TYPE = "type";
    private static final String CASE_SENSITIVE = "caseSensitive";
    private static final String REGEX = "regex";
    private static final String CONTAINS = "contains";
    private final List<HintRule> hintRules = new ArrayList<HintRule>();
    private final List<VendorDuplicatingHintRule> vendorDuplicatingHintRules = new ArrayList<VendorDuplicatingHintRule>();
    private HintRule rule;
    private ParentType nodeType = ParentType.GIVEN;

    public List<HintRule> getHintRules() {
        return this.hintRules;
    }

    public List<VendorDuplicatingHintRule> getVendorDuplicatingHintRules() {
        return this.vendorDuplicatingHintRules;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attr) throws SAXException {
        if (null != qName) {
            block9 : switch (qName) {
                case "hint": {
                    this.rule = new HintRule();
                    break;
                }
                case "add": {
                    this.nodeType = ParentType.ADD;
                    break;
                }
                case "given": {
                    this.nodeType = ParentType.GIVEN;
                    break;
                }
                case "remove": {
                    this.nodeType = ParentType.REMOVE;
                    break;
                }
                case "evidence": {
                    String hintType = attr.getValue(TYPE);
                    if (null == hintType || null == this.nodeType) break;
                    String source = attr.getValue(SOURCE);
                    String name = attr.getValue(NAME);
                    String value = attr.getValue(VALUE);
                    Confidence confidence = Confidence.valueOf(attr.getValue(CONFIDENCE));
                    switch (hintType) {
                        case "vendor": {
                            switch (this.nodeType) {
                                case ADD: {
                                    this.rule.addAddVendor(source, name, value, confidence);
                                    break block9;
                                }
                                case REMOVE: {
                                    this.rule.addRemoveVendor(source, name, value, confidence);
                                    break block9;
                                }
                                case GIVEN: {
                                    this.rule.addGivenVendor(source, name, value, confidence);
                                    break block9;
                                }
                            }
                            break block9;
                        }
                        case "product": {
                            switch (this.nodeType) {
                                case ADD: {
                                    this.rule.addAddProduct(source, name, value, confidence);
                                    break block9;
                                }
                                case REMOVE: {
                                    this.rule.addRemoveProduct(source, name, value, confidence);
                                    break block9;
                                }
                                case GIVEN: {
                                    this.rule.addGivenProduct(source, name, value, confidence);
                                    break block9;
                                }
                            }
                            break block9;
                        }
                        case "version": {
                            switch (this.nodeType) {
                                case ADD: {
                                    this.rule.addAddVersion(source, name, value, confidence);
                                    break block9;
                                }
                                case REMOVE: {
                                    this.rule.addRemoveVersion(source, name, value, confidence);
                                    break block9;
                                }
                                case GIVEN: {
                                    this.rule.addGivenVersion(source, name, value, confidence);
                                    break block9;
                                }
                            }
                            break block9;
                        }
                    }
                    break;
                }
                case "fileName": {
                    PropertyType pt = new PropertyType();
                    pt.setValue(attr.getValue(CONTAINS));
                    if (attr.getLength() > 0) {
                        String caseSensitive;
                        String regex = attr.getValue(REGEX);
                        if (regex != null) {
                            pt.setRegex(Boolean.parseBoolean(regex));
                        }
                        if ((caseSensitive = attr.getValue(CASE_SENSITIVE)) != null) {
                            pt.setCaseSensitive(Boolean.parseBoolean(caseSensitive));
                        }
                    }
                    this.rule.addFilename(pt);
                    break;
                }
                case "vendorDuplicatingHint": {
                    this.vendorDuplicatingHintRules.add(new VendorDuplicatingHintRule(attr.getValue(VALUE), attr.getValue(DUPLICATE)));
                    break;
                }
            }
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (HINT.equals(qName) && this.rule != null) {
            this.hintRules.add(this.rule);
            this.rule = null;
        }
    }

    static enum ParentType {
        ADD,
        GIVEN,
        REMOVE;

    }
}

