/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.xml.suppression;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.owasp.dependencycheck.dependency.Dependency;
import org.owasp.dependencycheck.dependency.Vulnerability;
import org.owasp.dependencycheck.dependency.naming.CpeIdentifier;
import org.owasp.dependencycheck.dependency.naming.Identifier;
import org.owasp.dependencycheck.dependency.naming.PurlIdentifier;
import org.owasp.dependencycheck.xml.suppression.PropertyType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import us.springett.parsers.cpe.Cpe;
import us.springett.parsers.cpe.exceptions.CpeEncodingException;

@NotThreadSafe
public class SuppressionRule {
    private static final Logger LOGGER = LoggerFactory.getLogger(SuppressionRule.class);
    private PropertyType filePath;
    private String sha1;
    private List<PropertyType> cpe = new ArrayList<PropertyType>();
    private List<Double> cvssBelow = new ArrayList<Double>();
    private List<Double> cvssV2Below = new ArrayList<Double>();
    private List<Double> cvssV3Below = new ArrayList<Double>();
    private List<Double> cvssV4Below = new ArrayList<Double>();
    private List<String> cwe = new ArrayList<String>();
    private List<String> cve = new ArrayList<String>();
    private final List<PropertyType> vulnerabilityNames = new ArrayList<PropertyType>();
    private PropertyType gav = null;
    private PropertyType packageUrl = null;
    private String notes;
    private boolean base;
    private Calendar until;
    private boolean matched = false;

    public boolean isMatched() {
        return this.matched;
    }

    public void setMatched(boolean matched) {
        this.matched = matched;
    }

    public Calendar getUntil() {
        return this.until;
    }

    public void setUntil(Calendar until) {
        this.until = until;
    }

    public PropertyType getFilePath() {
        return this.filePath;
    }

    public void setFilePath(PropertyType filePath) {
        this.filePath = filePath;
    }

    public String getSha1() {
        return this.sha1;
    }

    public void setSha1(String sha1) {
        this.sha1 = sha1;
    }

    public List<PropertyType> getCpe() {
        return this.cpe;
    }

    public void setCpe(List<PropertyType> cpe) {
        this.cpe = cpe;
    }

    public void addCpe(PropertyType cpe) {
        this.cpe.add(cpe);
    }

    public void addVulnerabilityName(PropertyType name) {
        this.vulnerabilityNames.add(name);
    }

    public boolean hasCpe() {
        return !this.cpe.isEmpty();
    }

    public List<Double> getCvssBelow() {
        return this.cvssBelow;
    }

    public void setCvssBelow(List<Double> cvssBelow) {
        this.cvssBelow = cvssBelow;
    }

    public void addCvssBelow(Double cvss) {
        this.cvssBelow.add(cvss);
    }

    public boolean hasCvssBelow() {
        return !this.cvssBelow.isEmpty();
    }

    public List<Double> getCvssV2Below() {
        return this.cvssV2Below;
    }

    public void setCvssV2Below(List<Double> cvssV2Below) {
        this.cvssV2Below = cvssV2Below;
    }

    public void addCvssV2Below(Double cvss) {
        this.cvssV2Below.add(cvss);
    }

    public boolean hasCvssV2Below() {
        return !this.cvssV2Below.isEmpty();
    }

    public List<Double> getCvssV3Below() {
        return this.cvssV3Below;
    }

    public void setCvssV3Below(List<Double> cvssV3Below) {
        this.cvssV3Below = cvssV3Below;
    }

    public void addCvssV3Below(Double cvss) {
        this.cvssV3Below.add(cvss);
    }

    public boolean hasCvssV3Below() {
        return !this.cvssV3Below.isEmpty();
    }

    public List<Double> getCvssV4Below() {
        return this.cvssV4Below;
    }

    public void setCvssV4Below(List<Double> cvssV4Below) {
        this.cvssV4Below = cvssV4Below;
    }

    public void addCvssV4Below(Double cvss) {
        this.cvssV4Below.add(cvss);
    }

    public boolean hasCvssV4Below() {
        return !this.cvssV4Below.isEmpty();
    }

    public String getNotes() {
        return this.notes;
    }

    public void setNotes(String notes) {
        this.notes = notes;
    }

    public boolean hasNotes() {
        return !this.notes.isEmpty();
    }

    public List<String> getCwe() {
        return this.cwe;
    }

    public void setCwe(List<String> cwe) {
        this.cwe = cwe;
    }

    public void addCwe(String cwe) {
        this.cwe.add(cwe);
    }

    public boolean hasCwe() {
        return !this.cwe.isEmpty();
    }

    public List<String> getCve() {
        return this.cve;
    }

    public void setCve(List<String> cve) {
        this.cve = cve;
    }

    public void addCve(String cve) {
        this.cve.add(cve);
    }

    public boolean hasCve() {
        return !this.cve.isEmpty();
    }

    public boolean hasVulnerabilityName() {
        return !this.vulnerabilityNames.isEmpty();
    }

    public PropertyType getGav() {
        return this.gav;
    }

    public void setGav(PropertyType gav) {
        this.gav = gav;
    }

    public boolean hasGav() {
        return this.gav != null;
    }

    public void setPackageUrl(PropertyType purl) {
        this.packageUrl = purl;
    }

    public boolean hasPackageUrl() {
        return this.packageUrl != null;
    }

    public boolean isBase() {
        return this.base;
    }

    public void setBase(boolean base) {
        this.base = base;
    }

    public void process(Dependency dependency) {
        boolean found;
        Iterator<Identifier> itr;
        if (this.filePath != null && !this.filePath.matches(dependency.getFilePath())) {
            return;
        }
        if (this.sha1 != null && !this.sha1.equalsIgnoreCase(dependency.getSha1sum())) {
            return;
        }
        if (this.hasGav()) {
            itr = dependency.getSoftwareIdentifiers().iterator();
            found = false;
            while (itr.hasNext()) {
                Identifier i2 = itr.next();
                if (!this.identifierMatches(this.gav, i2)) continue;
                found = true;
                break;
            }
            if (!found) {
                return;
            }
        }
        if (this.hasPackageUrl()) {
            itr = dependency.getSoftwareIdentifiers().iterator();
            found = false;
            while (itr.hasNext()) {
                Identifier i = itr.next();
                if (!this.purlMatches(this.packageUrl, i)) continue;
                found = true;
                break;
            }
            if (!found) {
                return;
            }
        }
        if (this.hasCpe()) {
            HashSet<Identifier> removalList = new HashSet<Identifier>();
            block2: for (Identifier i : dependency.getVulnerableSoftwareIdentifiers()) {
                for (PropertyType c : this.cpe) {
                    if (!this.identifierMatches(c, i)) continue;
                    if (!this.isBase()) {
                        this.matched = true;
                        if (this.notes != null) {
                            i.setNotes(this.notes);
                        }
                        dependency.addSuppressedIdentifier(i);
                    }
                    removalList.add(i);
                    continue block2;
                }
            }
            removalList.forEach(dependency::removeVulnerableSoftwareIdentifier);
        }
        if (this.hasCve() || this.hasVulnerabilityName() || this.hasCwe() || this.hasCvssBelow() || this.hasCvssV2Below() || this.hasCvssV3Below() || this.hasCvssV4Below()) {
            HashSet<Vulnerability> removeVulns = new HashSet<Vulnerability>();
            for (Vulnerability v : dependency.getVulnerabilities()) {
                boolean remove = false;
                for (String string : this.cve) {
                    if (!string.equalsIgnoreCase(v.getName())) continue;
                    removeVulns.add(v);
                    remove = true;
                    break;
                }
                if (!remove && this.cwe != null && !v.getCwes().isEmpty()) {
                    for (String string : this.cwe) {
                        String toMatch = String.format("CWE-%s", string);
                        if (!v.getCwes().stream().anyMatch(toTest -> toMatch.regionMatches(0, (String)toTest, 0, toMatch.length()))) continue;
                        remove = true;
                        removeVulns.add(v);
                        break;
                    }
                }
                if (!remove && v.getName() != null) {
                    for (PropertyType propertyType : this.vulnerabilityNames) {
                        if (!propertyType.matches(v.getName())) continue;
                        remove = true;
                        removeVulns.add(v);
                        break;
                    }
                }
                if (!remove && this.suppressedBasedOnScore(v)) {
                    remove = true;
                    removeVulns.add(v);
                }
                if (!remove || this.isBase()) continue;
                this.matched = true;
                if (this.notes != null) {
                    v.setNotes(this.notes);
                }
                dependency.addSuppressedVulnerability(v);
            }
            removeVulns.forEach(dependency::removeVulnerability);
        }
    }

    boolean suppressedBasedOnScore(Vulnerability v) {
        if (!this.cvssBelow.isEmpty()) {
            for (Double cvss : this.cvssBelow) {
                if (v.getCvssV2() != null && v.getCvssV2().getCvssData().getBaseScore().compareTo(cvss) < 0) {
                    return true;
                }
                if (v.getCvssV3() != null && v.getCvssV3().getCvssData().getBaseScore().compareTo(cvss) < 0) {
                    return true;
                }
                if (v.getCvssV4() == null || v.getCvssV4().getCvssData().getBaseScore().compareTo(cvss) >= 0) continue;
                return true;
            }
            return false;
        }
        if (this.hasCvssV2Below() || this.hasCvssV3Below() || this.hasCvssV4Below()) {
            Double v2SuppressionThreshold = this.cvssV2Below.stream().max(Double::compare).orElse(11.0);
            Double v3SuppressionThreshold = this.cvssV3Below.stream().max(Double::compare).orElse(11.0);
            Double v4SuppressionThreshold = this.cvssV4Below.stream().max(Double::compare).orElse(11.0);
            Double v2Score = v.getCvssV2() != null ? v.getCvssV2().getCvssData().getBaseScore() : null;
            Double v3Score = v.getCvssV3() != null ? v.getCvssV3().getCvssData().getBaseScore() : null;
            Double v4Score = v.getCvssV4() != null ? v.getCvssV4().getCvssData().getBaseScore() : null;
            boolean cvssV2CheckSuppressing = v2Score == null || v2Score < v2SuppressionThreshold;
            boolean cvssV3CheckSuppressing = v3Score == null || v3Score < v3SuppressionThreshold;
            boolean cvssV4CheckSuppressing = v4Score == null || v4Score < v4SuppressionThreshold;
            return cvssV2CheckSuppressing && cvssV3CheckSuppressing && cvssV4CheckSuppressing;
        }
        return false;
    }

    protected boolean cpeHasNoVersion(PropertyType c) {
        return !c.isRegex() && this.countCharacter(c.getValue(), ':') <= 3;
    }

    private int countCharacter(String str, char c) {
        int count = 0;
        int pos = str.indexOf(c) + 1;
        while (pos > 0) {
            ++count;
            pos = str.indexOf(c, pos) + 1;
        }
        return count;
    }

    protected boolean purlMatches(PropertyType suppressionEntry, Identifier identifier) {
        if (identifier instanceof PurlIdentifier) {
            PurlIdentifier purl = (PurlIdentifier)identifier;
            return suppressionEntry.matches(purl.toString());
        }
        return false;
    }

    protected boolean identifierMatches(PropertyType suppressionEntry, Identifier identifier) {
        block10: {
            if (identifier instanceof PurlIdentifier) {
                PurlIdentifier purl = (PurlIdentifier)identifier;
                return suppressionEntry.matches(purl.toGav());
            }
            if (identifier instanceof CpeIdentifier) {
                String id;
                Cpe cpeId = ((CpeIdentifier)identifier).getCpe();
                if (suppressionEntry.isRegex()) {
                    try {
                        return suppressionEntry.matches(cpeId.toCpe22Uri());
                    }
                    catch (CpeEncodingException ex) {
                        LOGGER.debug("Unable to convert CPE to 22 URI?" + String.valueOf(cpeId));
                        break block10;
                    }
                }
                if (suppressionEntry.isCaseSensitive()) {
                    try {
                        return cpeId.toCpe22Uri().startsWith(suppressionEntry.getValue());
                    }
                    catch (CpeEncodingException ex) {
                        LOGGER.debug("Unable to convert CPE to 22 URI?" + String.valueOf(cpeId));
                        break block10;
                    }
                }
                try {
                    id = cpeId.toCpe22Uri().toLowerCase();
                }
                catch (CpeEncodingException ex) {
                    LOGGER.debug("Unable to convert CPE to 22 URI?" + String.valueOf(cpeId));
                    return false;
                }
                String check = suppressionEntry.getValue().toLowerCase();
                return id.startsWith(check);
            }
        }
        return suppressionEntry.matches(identifier.getValue());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(64);
        sb.append("SuppressionRule{");
        if (this.until != null) {
            String dt = DateFormatUtils.ISO_8601_EXTENDED_DATETIME_TIME_ZONE_FORMAT.format(this.until);
            sb.append("until=").append(dt).append(',');
        }
        if (this.filePath != null) {
            sb.append("filePath=").append(this.filePath).append(',');
        }
        if (this.sha1 != null) {
            sb.append("sha1=").append(this.sha1).append(',');
        }
        if (this.packageUrl != null) {
            sb.append("packageUrl=").append(this.packageUrl).append(',');
        }
        if (this.gav != null) {
            sb.append("gav=").append(this.gav).append(',');
        }
        if (this.cpe != null && !this.cpe.isEmpty()) {
            sb.append("cpe={");
            this.cpe.forEach(pt -> sb.append(pt).append(','));
            sb.append('}');
        }
        if (this.cwe != null && !this.cwe.isEmpty()) {
            sb.append("cwe={");
            this.cwe.forEach(s -> sb.append((String)s).append(','));
            sb.append('}');
        }
        if (this.cve != null && !this.cve.isEmpty()) {
            sb.append("cve={");
            this.cve.forEach(s -> sb.append((String)s).append(','));
            sb.append('}');
        }
        if (this.vulnerabilityNames != null && !this.vulnerabilityNames.isEmpty()) {
            sb.append("vulnerabilityName={");
            this.vulnerabilityNames.forEach(pt -> sb.append(pt).append(','));
            sb.append('}');
        }
        if (this.cvssBelow != null && !this.cvssBelow.isEmpty()) {
            sb.append("cvssBelow={");
            this.cvssBelow.forEach(s -> sb.append(s).append(','));
            sb.append('}');
        }
        if (this.cvssV2Below != null && !this.cvssV2Below.isEmpty()) {
            sb.append("cvssV2Below={");
            this.cvssV2Below.forEach(s -> sb.append(s).append(','));
            sb.append('}');
        }
        if (this.cvssV3Below != null && !this.cvssV3Below.isEmpty()) {
            sb.append("cvssV3Below={");
            this.cvssV3Below.forEach(s -> sb.append(s).append(','));
            sb.append('}');
        }
        if (this.cvssV4Below != null && !this.cvssV4Below.isEmpty()) {
            sb.append("cvssV4Below={");
            this.cvssV4Below.forEach(s -> sb.append(s).append(','));
            sb.append('}');
        }
        sb.append('}');
        return sb.toString();
    }
}

