/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.data.update;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import io.github.jeremylong.openvulnerability.client.nvd.NvdApiException;
import io.github.jeremylong.openvulnerability.client.nvd.NvdCveClient;
import io.github.jeremylong.openvulnerability.client.nvd.NvdCveClientBuilder;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.time.Duration;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.function.Function;
import java.util.zip.GZIPOutputStream;
import org.jetbrains.annotations.NotNull;
import org.owasp.dependencycheck.Engine;
import org.owasp.dependencycheck.data.nvdcve.CveDB;
import org.owasp.dependencycheck.data.nvdcve.DatabaseException;
import org.owasp.dependencycheck.data.nvdcve.DatabaseProperties;
import org.owasp.dependencycheck.data.update.CachedWebDataSource;
import org.owasp.dependencycheck.data.update.exception.UpdateException;
import org.owasp.dependencycheck.data.update.nvd.api.DownloadTask;
import org.owasp.dependencycheck.data.update.nvd.api.NvdApiProcessor;
import org.owasp.dependencycheck.utils.DateUtil;
import org.owasp.dependencycheck.utils.DownloadFailedException;
import org.owasp.dependencycheck.utils.Downloader;
import org.owasp.dependencycheck.utils.InvalidSettingException;
import org.owasp.dependencycheck.utils.Pair;
import org.owasp.dependencycheck.utils.ResourceNotFoundException;
import org.owasp.dependencycheck.utils.Settings;
import org.owasp.dependencycheck.utils.TooManyRequestsException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NvdApiDataSource
implements CachedWebDataSource {
    private static final Logger LOGGER = LoggerFactory.getLogger(NvdApiDataSource.class);
    private static final int PROCESSING_THREAD_POOL_SIZE = Runtime.getRuntime().availableProcessors();
    private Settings settings;
    private CveDB cveDb = null;
    private DatabaseProperties dbProperties = null;
    private static final String NVD_API_CACHE_MODIFIED_DATE = "lastModifiedDate";
    private static final int RESULTS_PER_PAGE = 2000;

    @Override
    public boolean update(Engine engine) throws UpdateException {
        this.settings = engine.getSettings();
        this.cveDb = engine.getDatabase();
        if (this.isUpdateConfiguredFalse()) {
            return false;
        }
        this.dbProperties = this.cveDb.getDatabaseProperties();
        String nvdDataFeedUrl = this.settings.getString("nvd.api.datafeed.url");
        if (nvdDataFeedUrl != null) {
            return this.processDatafeed(nvdDataFeedUrl);
        }
        return this.processApi();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean processDatafeed(String nvdDataFeedUrl) throws UpdateException {
        boolean updatesMade;
        block14: {
            updatesMade = false;
            try {
                ZonedDateTime now;
                this.dbProperties = this.cveDb.getDatabaseProperties();
                if (!this.checkUpdate()) break block14;
                FeedUrl urlData = FeedUrl.extractFromUrlOptionalPattern(nvdDataFeedUrl);
                Properties cacheProperties = this.getRemoteDataFeedCacheProperties(urlData);
                Map<String, String> updateable = this.getUpdatesNeeded(urlData = urlData.withPattern(p -> (String)((Object)p.orElse(cacheProperties.getProperty("prefix", "nvdcve-") + "{0}.json.gz"))), cacheProperties, now = ZonedDateTime.now(ZoneOffset.UTC));
                if (!updateable.isEmpty()) {
                    int max = this.settings.getInt("max.download.threads", 1);
                    int downloadPoolSize = Math.min(Runtime.getRuntime().availableProcessors(), max);
                    int execPoolSize = Math.min(PROCESSING_THREAD_POOL_SIZE, 2);
                    ExecutorService processingExecutorService = null;
                    ExecutorService downloadExecutorService = null;
                    try {
                        downloadExecutorService = Executors.newFixedThreadPool(downloadPoolSize);
                        processingExecutorService = Executors.newFixedThreadPool(execPoolSize);
                        DownloadTask runLast = null;
                        HashSet<Future<Future<NvdApiProcessor>>> downloadFutures = new HashSet<Future<Future<NvdApiProcessor>>>(updateable.size());
                        runLast = this.startDownloads(updateable, processingExecutorService, runLast, downloadFutures, downloadExecutorService);
                        HashSet<Future<NvdApiProcessor>> processFutures = new HashSet<Future<NvdApiProcessor>>(updateable.size());
                        for (Future future : downloadFutures) {
                            this.processDownload(future, processFutures);
                        }
                        this.processFuture(processFutures);
                        processFutures.clear();
                        if (runLast != null) {
                            Future<Future<NvdApiProcessor>> modified = downloadExecutorService.submit(runLast);
                            this.processDownload(modified, processFutures);
                            this.processFuture(processFutures);
                        }
                    }
                    finally {
                        if (processingExecutorService != null) {
                            processingExecutorService.shutdownNow();
                        }
                        if (downloadExecutorService != null) {
                            downloadExecutorService.shutdownNow();
                        }
                    }
                    updatesMade = true;
                }
                this.storeLastModifiedDates(now, cacheProperties, updateable);
                if (updatesMade) {
                    this.cveDb.persistEcosystemCache();
                }
                int updateCount = this.cveDb.updateEcosystemCache();
                LOGGER.debug("Corrected the ecosystem for {} ecoSystemCache entries", (Object)updateCount);
                if (updatesMade || updateCount > 0) {
                    this.cveDb.cleanupDatabase();
                }
            }
            catch (UpdateException ex) {
                String jre;
                if (ex.getCause() != null && ex.getCause() instanceof DownloadFailedException && ((jre = System.getProperty("java.version")) == null || jre.startsWith("1.4") || jre.startsWith("1.5") || jre.startsWith("1.6") || jre.startsWith("1.7"))) {
                    LOGGER.error("An old JRE is being used ({} {}), and likely does not have the correct root certificates or algorithms to connect to the NVD - consider upgrading your JRE.", (Object)System.getProperty("java.vendor"), (Object)jre);
                }
                throw ex;
            }
            catch (DatabaseException ex) {
                throw new UpdateException("Database Exception, unable to update the data to use the most current data.", ex);
            }
        }
        return updatesMade;
    }

    private void storeLastModifiedDates(ZonedDateTime now, Properties cacheProperties, Map<String, String> updateable) throws UpdateException {
        ZonedDateTime lastModifiedRequest = DatabaseProperties.getTimestamp(cacheProperties, "lastModifiedDate.modified");
        this.dbProperties.save("nvd.cache.last.checked", now);
        this.dbProperties.save("nvd.cache.last.modified", lastModifiedRequest);
        this.dbProperties.save("nvd.api.last.checked", now);
        this.dbProperties.save("nvd.api.last.modified", lastModifiedRequest);
        for (String entry : updateable.keySet()) {
            ZonedDateTime date = DatabaseProperties.getTimestamp(cacheProperties, "lastModifiedDate." + entry);
            this.dbProperties.save("nvd.cache.last.modified." + entry, date);
        }
    }

    private DownloadTask startDownloads(Map<String, String> updateable, ExecutorService processingExecutorService, DownloadTask runLast, Set<Future<Future<NvdApiProcessor>>> downloadFutures, ExecutorService downloadExecutorService) throws UpdateException {
        DownloadTask lastCall = runLast;
        for (Map.Entry<String, String> cve : updateable.entrySet()) {
            DownloadTask call = new DownloadTask(cve.getValue(), processingExecutorService, this.cveDb, this.settings);
            if (call.isModified()) {
                lastCall = call;
                continue;
            }
            boolean added = downloadFutures.add(downloadExecutorService.submit(call));
            if (added) continue;
            throw new UpdateException("Unable to add the download task for " + String.valueOf(cve));
        }
        return lastCall;
    }

    private void processFuture(Set<Future<NvdApiProcessor>> processFutures) throws UpdateException {
        for (Future<NvdApiProcessor> future : processFutures) {
            try {
                NvdApiProcessor nvdApiProcessor = future.get();
            }
            catch (InterruptedException ex) {
                LOGGER.debug("Thread was interrupted during processing", (Throwable)ex);
                Thread.currentThread().interrupt();
                throw new UpdateException(ex);
            }
            catch (ExecutionException ex) {
                LOGGER.debug("Execution Exception during process", (Throwable)ex);
                throw new UpdateException(ex);
            }
        }
    }

    private void processDownload(Future<Future<NvdApiProcessor>> future, Set<Future<NvdApiProcessor>> processFutures) throws UpdateException {
        try {
            Future<NvdApiProcessor> task = future.get();
            if (task != null) {
                processFutures.add(task);
            }
        }
        catch (InterruptedException ex) {
            LOGGER.debug("Thread was interrupted during download", (Throwable)ex);
            Thread.currentThread().interrupt();
            throw new UpdateException("The download was interrupted", ex);
        }
        catch (ExecutionException ex) {
            LOGGER.debug("Thread was interrupted during download execution", (Throwable)ex);
            throw new UpdateException("The execution of the download was interrupted", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean processApi() throws UpdateException {
        String key;
        ZonedDateTime lastChecked = this.dbProperties.getTimestamp("nvd.api.last.checked");
        int validForHours = this.settings.getInt("nvd.api.check.validforhours", 0);
        if (this.cveDb.dataExists() && lastChecked != null && validForHours > 0) {
            long validForSeconds = (long)validForHours * 60L * 60L;
            ZonedDateTime now = ZonedDateTime.now(ZoneId.of("UTC"));
            Duration duration = Duration.between(lastChecked, now);
            long difference = duration.getSeconds();
            if (difference < validForSeconds) {
                LOGGER.info("Skipping the NVD API Update as it was completed within the last {} minutes", (Object)(validForSeconds / 60L));
                return false;
            }
        }
        ZonedDateTime lastModifiedRequest = this.dbProperties.getTimestamp("nvd.api.last.modified");
        NvdCveClientBuilder builder = NvdCveClientBuilder.aNvdCveApi();
        String endpoint = this.settings.getString("nvd.api.endpoint");
        if (endpoint != null) {
            builder.withEndpoint(endpoint);
        }
        if (lastModifiedRequest != null) {
            lastModifiedRequest = lastModifiedRequest.withZoneSameInstant(ZoneId.of("UTC"));
            ZonedDateTime end = lastModifiedRequest.plusDays(120L);
            builder.withLastModifiedFilter(lastModifiedRequest, end);
        }
        if ((key = this.settings.getString("nvd.api.key")) != null) {
            builder.withApiKey(key).withrequestsPerThirtySeconds(this.settings.getInt("nvd.api.requestsperthirtysecondswithapikey", 50));
        } else {
            LOGGER.warn("An NVD API Key was not provided - it is highly recommended to use an NVD API key as the update can take a VERY long time without an API Key");
            builder.withrequestsPerThirtySeconds(this.settings.getInt("nvd.api.requestsperthirtysecondswithoutapikey", 5));
        }
        int resultsPerPage = Math.min(this.settings.getInt("nvd.api.results.per.page", 2000), 2000);
        builder.withResultsPerPage(resultsPerPage);
        int retryCount = this.settings.getInt("nvd.api.max.retry.count", 10);
        builder.withMaxRetryCount(retryCount);
        long delay = 0L;
        try {
            delay = this.settings.getLong("nvd.api.delay");
        }
        catch (InvalidSettingException ex) {
            LOGGER.warn("Invalid setting `NVD_API_DELAY`? ({}), using default delay", (Object)this.settings.getString("nvd.api.delay"));
        }
        if (delay > 0L) {
            builder.withDelay(delay);
        }
        ExecutorService processingExecutorService = null;
        try {
            processingExecutorService = Executors.newFixedThreadPool(PROCESSING_THREAD_POOL_SIZE);
            ArrayList<Future<NvdApiProcessor>> submitted = new ArrayList<Future<NvdApiProcessor>>();
            int max = -1;
            int ctr = 0;
            try (NvdCveClient api = builder.build();){
                while (api.hasNext()) {
                    ZonedDateTime zonedDateTime;
                    Collection items = api.next();
                    max = api.getTotalAvailable();
                    if (ctr == 0) {
                        LOGGER.info(String.format("NVD API has %,d records in this update", max));
                    }
                    if (items != null && !items.isEmpty()) {
                        double percent;
                        ObjectMapper objectMapper = new ObjectMapper();
                        objectMapper.registerModule((Module)new JavaTimeModule());
                        File outputFile = this.settings.getTempFile("nvd-data-", ".jsonarray.gz");
                        try (FileOutputStream fos = new FileOutputStream(outputFile);
                             GZIPOutputStream out = new GZIPOutputStream(fos);){
                            objectMapper.writeValue((OutputStream)out, (Object)items);
                            Future<NvdApiProcessor> f = processingExecutorService.submit(new NvdApiProcessor(this.cveDb, outputFile));
                            submitted.add(f);
                        }
                        if (++ctr % 5 == 0 && (percent = (double)(ctr * resultsPerPage) / (double)max * 100.0) < 100.0) {
                            LOGGER.info(String.format("Downloaded %,d/%,d (%.0f%%)", ctr * resultsPerPage, max, percent));
                        }
                    }
                    if ((zonedDateTime = api.getLastUpdated()) == null || lastModifiedRequest != null && lastModifiedRequest.compareTo(zonedDateTime) >= 0) continue;
                    lastModifiedRequest = zonedDateTime;
                }
            }
            catch (Exception e) {
                if (e instanceof NvdApiException && (e.getMessage().equals("NVD Returned Status Code: 404") || e.getMessage().equals("NVD Returned Status Code: 403"))) {
                    String msg = key != null ? "Error updating the NVD Data; the NVD returned a 403 or 404 error\n\nPlease ensure your API Key is valid; see https://github.com/jeremylong/open-vulnerability-cli/blob/main/README.md#api-key-is-used-and-a-403-or-404-error-occurs\n\nIf your NVD API Key is valid try increasing the NVD API Delay.\n\nIf this is occurring in a CI environment" : "Error updating the NVD Data; the NVD returned a 403 or 404 error\n\nConsider using an NVD API Key; see https://github.com/dependency-check/DependencyCheck?tab=readme-ov-file#nvd-api-key-highly-recommended";
                    throw new UpdateException(msg);
                }
                throw new UpdateException("Error updating the NVD Data", e);
            }
            LOGGER.info(String.format("Downloaded %,d/%,d (%.0f%%)", max, max, Float.valueOf(100.0f)));
            max = submitted.size();
            boolean updated = max > 0;
            ctr = 0;
            for (Future future : submitted) {
                try {
                    NvdApiProcessor proc = (NvdApiProcessor)future.get();
                    double percent = (double)(++ctr) / (double)max * 100.0;
                    LOGGER.info(String.format("Completed processing batch %d/%d (%.0f%%) in %,dms", ctr, max, percent, proc.getDurationMillis()));
                }
                catch (InterruptedException ex) {
                    Thread.currentThread().interrupt();
                    throw new RuntimeException(ex);
                }
                catch (ExecutionException ex) {
                    LOGGER.error("Exception processing NVD API Results", (Throwable)ex);
                    throw new RuntimeException(ex);
                }
            }
            if (lastModifiedRequest != null) {
                this.dbProperties.save("nvd.api.last.checked", ZonedDateTime.now());
                this.dbProperties.save("nvd.api.last.modified", lastModifiedRequest);
            }
            boolean bl = updated;
            return bl;
        }
        finally {
            if (processingExecutorService != null) {
                processingExecutorService.shutdownNow();
            }
        }
    }

    private boolean isUpdateConfiguredFalse() {
        if (!this.settings.getBoolean("updater.nvdcve.enabled", true)) {
            return true;
        }
        boolean autoUpdate = true;
        try {
            autoUpdate = this.settings.getBoolean("odc.autoupdate");
        }
        catch (InvalidSettingException ex) {
            LOGGER.debug("Invalid setting for auto-update; using true.");
        }
        return !autoUpdate;
    }

    @Override
    public boolean purge(Engine engine) {
        boolean result = true;
        try {
            File lockFile;
            File dataDir = engine.getSettings().getDataDirectory();
            File db = new File(dataDir, engine.getSettings().getString("data.file_name", "odc.mv.db"));
            if (db.exists()) {
                if (db.delete()) {
                    LOGGER.info("Database file purged; local copy of the NVD has been removed");
                } else {
                    LOGGER.error("Unable to delete '{}'; please delete the file manually", (Object)db.getAbsolutePath());
                    result = false;
                }
            } else {
                LOGGER.info("Unable to purge database; the database file does not exist: {}", (Object)db.getAbsolutePath());
                result = false;
            }
            File traceFile = new File(dataDir, "odc.trace.db");
            if (traceFile.exists() && !traceFile.delete()) {
                LOGGER.error("Unable to delete '{}'; please delete the file manually", (Object)traceFile.getAbsolutePath());
                result = false;
            }
            if ((lockFile = new File(dataDir, "odc.update.lock")).exists() && !lockFile.delete()) {
                LOGGER.error("Unable to delete '{}'; please delete the file manually", (Object)lockFile.getAbsolutePath());
                result = false;
            }
        }
        catch (IOException ex) {
            String msg = "Unable to delete the database";
            LOGGER.error("Unable to delete the database", (Throwable)ex);
            result = false;
        }
        return result;
    }

    private boolean checkUpdate() throws UpdateException {
        boolean proceed = true;
        int validForHours = this.settings.getInt("nvd.api.check.validforhours", 0);
        if (this.dataExists() && 0 < validForHours) {
            long validForSeconds = (long)validForHours * 60L * 60L;
            ZonedDateTime lastChecked = this.dbProperties.getTimestamp("nvd.cache.last.checked");
            if (lastChecked != null) {
                ZonedDateTime now = ZonedDateTime.now(ZoneId.of("UTC"));
                Duration duration = Duration.between(lastChecked, now);
                long difference = duration.getSeconds();
                boolean bl = proceed = difference > validForSeconds;
                if (!proceed) {
                    LOGGER.info("Skipping NVD API Cache check since last check was within {} hours.", (Object)validForHours);
                    LOGGER.debug("Last NVD API was at {}, and now {} is within {} s.", new Object[]{lastChecked, now, validForSeconds});
                }
            } else {
                LOGGER.warn("NVD cache last checked not present; updating the entire database. This could occur if you are switching back and forth from using the API vs a datafeed or if you are using a database created prior to ODC 9.x");
            }
        }
        return proceed;
    }

    private boolean dataExists() {
        return this.cveDb.dataExists();
    }

    protected final Map<String, String> getUpdatesNeeded(FeedUrl feedUrl, Properties cacheProperties, ZonedDateTime now) throws UpdateException {
        LOGGER.debug("starting getUpdatesNeeded() ...");
        HashMap<String, String> updates = new HashMap<String, String>();
        if (this.dbProperties != null && !this.dbProperties.isEmpty()) {
            Pair<Integer, Integer> yearRange = FeedUrl.toYearRange(this.settings, now);
            int startYear = yearRange.getLeft();
            int endYear = yearRange.getRight();
            boolean needsFullUpdate = false;
            for (int y = startYear; y <= endYear; ++y) {
                ZonedDateTime val = this.dbProperties.getTimestamp("nvd.cache.last.modified." + y);
                if (val != null || !FeedUrl.isMandatoryFeedYear(now, y)) continue;
                needsFullUpdate = true;
                break;
            }
            ZonedDateTime lastUpdated = this.dbProperties.getTimestamp("nvd.cache.last.modified");
            int days = this.settings.getInt("nvd.api.datafeed.validfordays", 7);
            if (!needsFullUpdate && lastUpdated.equals(DatabaseProperties.getTimestamp(cacheProperties, NVD_API_CACHE_MODIFIED_DATE))) {
                return updates;
            }
            updates.put("modified", feedUrl.toFormattedUrlString("modified"));
            if (needsFullUpdate) {
                for (int i = startYear; i <= endYear; ++i) {
                    if (!cacheProperties.containsKey("lastModifiedDate." + i)) continue;
                    updates.put(String.valueOf(i), feedUrl.toFormattedUrlString(i));
                }
            } else if (!DateUtil.withinDateRange(lastUpdated, now, days)) {
                for (int i = startYear; i <= endYear; ++i) {
                    if (!cacheProperties.containsKey("lastModifiedDate." + i)) continue;
                    ZonedDateTime lastModifiedCache = DatabaseProperties.getTimestamp(cacheProperties, "lastModifiedDate." + i);
                    ZonedDateTime lastModifiedDB = this.dbProperties.getTimestamp("nvd.cache.last.modified." + i);
                    if (lastModifiedDB != null && (lastModifiedCache == null || lastModifiedCache.compareTo(lastModifiedDB) <= 0)) continue;
                    updates.put(String.valueOf(i), feedUrl.toFormattedUrlString(i));
                }
            }
        }
        if (updates.size() > 3) {
            LOGGER.info("NVD API Cache / Data Feed requires several updates; this could take a couple of minutes.");
        }
        return updates;
    }

    protected final Properties getRemoteDataFeedCacheProperties(FeedUrl dataFeedUrl) throws UpdateException {
        try {
            Properties properties = new Properties();
            String content = Downloader.getInstance().fetchContent(dataFeedUrl.toSuffixedUrl("cache.properties"), StandardCharsets.UTF_8);
            properties.load(new StringReader(content));
            return properties;
        }
        catch (DownloadFailedException | ResourceNotFoundException ex) {
            LOGGER.debug("Unable to download the NVD API cache.properties due to [{}]; attempting to build from data feed metadata files instead...", (Object)ex.toString());
            return this.generateRemoteDataFeedCachePropertiesFromMetadata(dataFeedUrl);
        }
        catch (MalformedURLException | URISyntaxException ex) {
            throw new UpdateException("Invalid NVD Cache / Data Feed URL", ex);
        }
        catch (TooManyRequestsException ex) {
            throw new UpdateException("Unable to download the NVD API cache.properties", ex);
        }
        catch (IOException ex) {
            throw new UpdateException("Invalid NVD Cache properties file contents", ex);
        }
    }

    private Properties generateRemoteDataFeedCachePropertiesFromMetadata(FeedUrl dataFeedUrl) throws UpdateException {
        FeedUrl metaFeedUrl = dataFeedUrl.withPattern(p -> p.orElse("nvdcve-{0}.json.gz").replace(".json.gz", ".meta"));
        Properties properties = new Properties();
        ZonedDateTime lmd = metaFeedUrl.getLastModifiedFor("modified");
        DatabaseProperties.setTimestamp(properties, "lastModifiedDate.modified", lmd);
        DatabaseProperties.setTimestamp(properties, NVD_API_CACHE_MODIFIED_DATE, lmd);
        metaFeedUrl.getLastModifiedDatePropertiesByYear(this.settings, ZonedDateTime.now(ZoneOffset.UTC)).forEach((k, v) -> DatabaseProperties.setTimestamp(properties, k, v));
        return properties;
    }

    protected static class FeedUrl {
        static final String DEFAULT_FILE_PATTERN_PREFIX = "nvdcve-";
        static final String DEFAULT_FILE_PATTERN_SUFFIX = "{0}.json.gz";
        static final String DEFAULT_FILE_PATTERN = "nvdcve-{0}.json.gz";
        static final ZoneId ZONE_GLOBAL_EARLIEST = ZoneId.of("UTC+14:00");
        static final ZoneId ZONE_GLOBAL_LATEST = ZoneId.of("UTC-12:00");
        private final String url;
        private final String pattern;

        public FeedUrl(String url, String pattern) {
            this.url = url;
            this.pattern = pattern;
        }

        public FeedUrl withPattern(Function<Optional<String>, String> patternTransformer) {
            return new FeedUrl(this.url, patternTransformer.apply(Optional.ofNullable(this.pattern)));
        }

        @NotNull
        String toFormattedUrlString(String formatArg) {
            return this.url + MessageFormat.format(Optional.ofNullable(this.pattern).orElseThrow(), formatArg);
        }

        @NotNull
        String toFormattedUrlString(int formatArg) {
            return this.toFormattedUrlString(String.valueOf(formatArg));
        }

        @NotNull
        URL toFormattedUrl(@NotNull String formatArg) throws MalformedURLException, URISyntaxException {
            return new URI(this.toFormattedUrlString(formatArg)).toURL();
        }

        @NotNull
        URL toSuffixedUrl(String suffix) throws MalformedURLException, URISyntaxException {
            return new URI(this.url + suffix).toURL();
        }

        protected static FeedUrl extractFromUrlOptionalPattern(String url) {
            Object baseUrl;
            String pattern = null;
            if (url.endsWith(".json.gz")) {
                int lio = url.lastIndexOf("/");
                pattern = url.substring(lio + 1);
                baseUrl = url.substring(0, lio);
            } else {
                baseUrl = url;
            }
            if (!((String)baseUrl).endsWith("/")) {
                baseUrl = (String)baseUrl + "/";
            }
            return new FeedUrl((String)baseUrl, pattern);
        }

        @NotNull
        private static Pair<Integer, Integer> toYearRange(Settings settings, ZonedDateTime now) {
            int startYear = settings.getInt("nvd.api.datafeed.startyear", 2002);
            int endYear = now.withZoneSameInstant(ZONE_GLOBAL_EARLIEST).getYear();
            return new Pair<Integer, Integer>(startYear, endYear);
        }

        @NotNull
        private ZonedDateTime getLastModifiedFor(int year) throws UpdateException {
            return this.getLastModifiedFor(String.valueOf(year));
        }

        @NotNull
        private ZonedDateTime getLastModifiedFor(String fileVersion) throws UpdateException {
            try {
                String content = Downloader.getInstance().fetchContent(this.toFormattedUrl(fileVersion), StandardCharsets.UTF_8);
                Properties props = new Properties();
                props.load(new StringReader(content));
                return Objects.requireNonNull(DatabaseProperties.getIsoTimestamp(props, NvdApiDataSource.NVD_API_CACHE_MODIFIED_DATE));
            }
            catch (Exception ex) {
                throw new UpdateException("Unable to download & parse the data feed .meta file for " + fileVersion, ex);
            }
        }

        Map<String, ZonedDateTime> getLastModifiedDatePropertiesByYear(Settings settings, ZonedDateTime now) throws UpdateException {
            Pair<Integer, Integer> yearRange = FeedUrl.toYearRange(settings, now);
            LinkedHashMap<String, ZonedDateTime> lastModifiedDateProperties = new LinkedHashMap<String, ZonedDateTime>();
            for (int y = yearRange.getLeft().intValue(); y <= yearRange.getRight(); ++y) {
                try {
                    lastModifiedDateProperties.put("lastModifiedDate." + y, this.getLastModifiedFor(y));
                    continue;
                }
                catch (UpdateException e) {
                    if (FeedUrl.isMandatoryFeedYear(now, y)) {
                        throw e;
                    }
                    LOGGER.debug("Ignoring data feed metadata retrieval failure for {}, it is still January 1st in some TZ; so feed files may not yet be generated. Error was {}", (Object)y, (Object)e.toString());
                }
            }
            return lastModifiedDateProperties;
        }

        static boolean isMandatoryFeedYear(ZonedDateTime now, int targetYear) {
            return FeedUrl.isNotTargetYearInAnyTZ(now, targetYear) || FeedUrl.isAfterJanuary1InEveryTZ(now, targetYear);
        }

        private static boolean isNotTargetYearInAnyTZ(ZonedDateTime now, int targetYear) {
            return targetYear != now.withZoneSameInstant(ZONE_GLOBAL_EARLIEST).getYear();
        }

        private static boolean isAfterJanuary1InEveryTZ(ZonedDateTime now, int targetYear) {
            return now.isAfter(LocalDate.of(targetYear, 1, 2).atStartOfDay().atZone(ZONE_GLOBAL_LATEST));
        }
    }
}

