/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.utils;

import io.github.jeremylong.openvulnerability.client.nvd.CvssV2;
import io.github.jeremylong.openvulnerability.client.nvd.CvssV2Data;
import io.github.jeremylong.openvulnerability.client.nvd.CvssV3;
import io.github.jeremylong.openvulnerability.client.nvd.CvssV3Data;
import io.github.jeremylong.openvulnerability.client.nvd.CvssV4;
import io.github.jeremylong.openvulnerability.client.nvd.CvssV4Data;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.sonatype.ossindex.service.api.cvss.Cvss3Severity;

public final class CvssUtil {
    private static final List<String> BASE_METRICS_V3 = Arrays.asList("AV", "AC", "PR", "UI", "S", "C", "I", "A");
    private static final List<String> BASE_METRICS_V2 = Arrays.asList("AV", "AC", "Au", "C", "I", "A");
    private static final Double ZERO = 0.0;
    private static final Double ONE = 1.0;
    private static final Double FOUR = 4.0;
    private static final Double SEVEN = 7.0;
    private static final Double NINE = 9.0;
    private static final Double TEN = 10.0;
    private static final String UNKNOWN = "UNKNOWN";
    private static final String HIGH = "HIGH";
    private static final String MEDIUM = "MEDIUM";
    private static final String LOW = "LOW";

    private CvssUtil() {
    }

    public static CvssV2 vectorToCvssV2(String vectorString, Double baseScore) {
        if (vectorString.startsWith("CVSS:")) {
            throw new IllegalArgumentException("Not a valid CVSSv2 vector string: " + vectorString);
        }
        String[] metricStrings = vectorString.substring(vectorString.indexOf(47) + 1).split("/");
        HashMap<String, String> metrics = new HashMap<String, String>();
        for (int i = 0; i < metricStrings.length; ++i) {
            String[] metricKeyVal = metricStrings[i].split(":");
            if (metricKeyVal.length != 2) {
                throw new IllegalArgumentException(String.format("Not a valid CVSSv2 vector string '%s', invalid metric component '%s'", vectorString, metricStrings[i]));
            }
            metrics.put(metricKeyVal[0], metricKeyVal[1]);
        }
        if (!metrics.keySet().containsAll(BASE_METRICS_V2)) {
            throw new IllegalArgumentException(String.format("Not a valid CVSSv2 vector string '%s'; missing one or more required Metrics;", vectorString));
        }
        CvssV2Data.AccessVectorType accessVector = CvssV2Data.AccessVectorType.fromValue((String)((String)metrics.get("AV")));
        CvssV2Data.AccessComplexityType attackComplexity = CvssV2Data.AccessComplexityType.fromValue((String)((String)metrics.get("AC")));
        CvssV2Data.AuthenticationType authentication = CvssV2Data.AuthenticationType.fromValue((String)((String)metrics.get("Au")));
        CvssV2Data.CiaType confidentialityImpact = CvssV2Data.CiaType.fromValue((String)((String)metrics.get("C")));
        CvssV2Data.CiaType integrityImpact = CvssV2Data.CiaType.fromValue((String)((String)metrics.get("I")));
        CvssV2Data.CiaType availabilityImpact = CvssV2Data.CiaType.fromValue((String)((String)metrics.get("A")));
        String baseSeverity = CvssUtil.cvssV2ScoreToSeverity(baseScore);
        CvssV2Data data = new CvssV2Data(CvssV2Data.Version._2_0, vectorString, accessVector, attackComplexity, authentication, confidentialityImpact, integrityImpact, availabilityImpact, baseScore, baseSeverity, null, null, null, null, null, null, null, null, null, null);
        CvssV2 cvss = new CvssV2(null, null, data, baseSeverity, null, null, null, null, null, null, null);
        return cvss;
    }

    public static String cvssV2ScoreToSeverity(Double score) {
        if (score != null) {
            if (ZERO.compareTo(score) <= 0 && FOUR.compareTo(score) > 0) {
                return LOW;
            }
            if (FOUR.compareTo(score) <= 0 && SEVEN.compareTo(score) > 0) {
                return MEDIUM;
            }
            if (SEVEN.compareTo(score) <= 0 && TEN.compareTo(score) >= 0) {
                return HIGH;
            }
        }
        return UNKNOWN;
    }

    public static CvssV3Data.SeverityType cvssV3ScoreToSeverity(Double score) {
        if (score != null) {
            if (ZERO.compareTo(score) == 0) {
                return CvssV3Data.SeverityType.NONE;
            }
            if (ZERO.compareTo(score) <= 0 && FOUR.compareTo(score) > 0) {
                return CvssV3Data.SeverityType.LOW;
            }
            if (FOUR.compareTo(score) <= 0 && SEVEN.compareTo(score) > 0) {
                return CvssV3Data.SeverityType.MEDIUM;
            }
            if (SEVEN.compareTo(score) <= 0 && NINE.compareTo(score) > 0) {
                return CvssV3Data.SeverityType.HIGH;
            }
            if (NINE.compareTo(score) <= 0 && TEN.compareTo(score) >= 0) {
                return CvssV3Data.SeverityType.CRITICAL;
            }
        }
        return null;
    }

    public static CvssV3 vectorToCvssV3(String vectorString, Double baseScore) {
        if (!vectorString.startsWith("CVSS:3")) {
            throw new IllegalArgumentException("Not a valid CVSSv3 vector string: " + vectorString);
        }
        String versionString = vectorString.substring(5, vectorString.indexOf(47));
        String[] metricStrings = vectorString.substring(vectorString.indexOf(47) + 1).split("/");
        HashMap<String, String> metrics = new HashMap<String, String>();
        for (int i = 0; i < metricStrings.length; ++i) {
            String[] metricKeyVal = metricStrings[i].split(":");
            if (metricKeyVal.length != 2) {
                throw new IllegalArgumentException(String.format("Not a valid CVSSv3 vector string '%s', invalid metric component '%s'", vectorString, metricStrings[i]));
            }
            metrics.put(metricKeyVal[0], metricKeyVal[1]);
        }
        if (!metrics.keySet().containsAll(BASE_METRICS_V3)) {
            throw new IllegalArgumentException(String.format("Not a valid CVSSv3 vector string '%s'; missing one or more required Base Metrics;", vectorString));
        }
        CvssV3Data.Version version = CvssV3Data.Version.fromValue((String)versionString);
        CvssV3Data.AttackVectorType attackVector = CvssV3Data.AttackVectorType.fromValue((String)((String)metrics.get("AV")));
        CvssV3Data.AttackComplexityType attackComplexity = CvssV3Data.AttackComplexityType.fromValue((String)((String)metrics.get("AC")));
        CvssV3Data.PrivilegesRequiredType privilegesRequired = CvssV3Data.PrivilegesRequiredType.fromValue((String)((String)metrics.get("PR")));
        CvssV3Data.UserInteractionType userInteraction = CvssV3Data.UserInteractionType.fromValue((String)((String)metrics.get("UI")));
        CvssV3Data.ScopeType scope = CvssV3Data.ScopeType.fromValue((String)((String)metrics.get("S")));
        CvssV3Data.CiaType confidentialityImpact = CvssV3Data.CiaType.fromValue((String)((String)metrics.get("C")));
        CvssV3Data.CiaType integrityImpact = CvssV3Data.CiaType.fromValue((String)((String)metrics.get("I")));
        CvssV3Data.CiaType availabilityImpact = CvssV3Data.CiaType.fromValue((String)((String)metrics.get("A")));
        String baseSeverityString = Cvss3Severity.of((Float)Float.valueOf(baseScore.floatValue())).name();
        CvssV3Data.SeverityType baseSeverity = CvssV3Data.SeverityType.fromValue((String)baseSeverityString);
        CvssV3Data data = new CvssV3Data(version, vectorString, attackVector, attackComplexity, privilegesRequired, userInteraction, scope, confidentialityImpact, integrityImpact, availabilityImpact, baseScore, baseSeverity, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null);
        CvssV3 cvss = new CvssV3(null, null, data, null, null);
        return cvss;
    }

    private static CvssV4Data.SeverityType toSeverityType(double baseScore) {
        if (baseScore == 0.0) {
            return CvssV4Data.SeverityType.NONE;
        }
        if (baseScore >= 0.1 && baseScore <= 3.9) {
            return CvssV4Data.SeverityType.LOW;
        }
        if (baseScore >= 4.0 && baseScore <= 6.9) {
            return CvssV4Data.SeverityType.MEDIUM;
        }
        if (baseScore >= 7.0 && baseScore <= 8.9) {
            return CvssV4Data.SeverityType.HIGH;
        }
        if (baseScore >= 9.0 && baseScore <= 10.0) {
            return CvssV4Data.SeverityType.CRITICAL;
        }
        throw new IllegalArgumentException("Invalid CVSS base score: " + baseScore);
    }

    public static CvssV4 vectorToCvssV4(String source, CvssV4.Type type, Double baseScore, String vectorString) {
        String[] parts = vectorString.replaceFirst("^CVSS:", "").split("/");
        HashMap<String, String> values = new HashMap<String, String>();
        for (String part : parts) {
            String[] kv = part.split(":");
            if (kv.length != 2) continue;
            values.put(kv[0], kv[1]);
        }
        CvssV4Data.Version version = CvssV4Data.Version.fromValue((String)values.getOrDefault("4.0", "4.0"));
        CvssV4Data.AttackVectorType attackVector = values.containsKey("AV") ? CvssV4Data.AttackVectorType.fromValue((String)((String)values.get("AV"))) : null;
        CvssV4Data.AttackComplexityType attackComplexity = values.containsKey("AC") ? CvssV4Data.AttackComplexityType.fromValue((String)((String)values.get("AC"))) : null;
        CvssV4Data.AttackRequirementsType attackRequirements = values.containsKey("AT") ? CvssV4Data.AttackRequirementsType.fromValue((String)((String)values.get("AT"))) : null;
        CvssV4Data.PrivilegesRequiredType privilegesRequired = values.containsKey("PR") ? CvssV4Data.PrivilegesRequiredType.fromValue((String)((String)values.get("PR"))) : null;
        CvssV4Data.UserInteractionType userInteraction = values.containsKey("UI") ? CvssV4Data.UserInteractionType.fromValue((String)((String)values.get("UI"))) : null;
        CvssV4Data.CiaType vulnConfidentialityImpact = values.containsKey("VC") ? CvssV4Data.CiaType.fromValue((String)((String)values.get("VC"))) : null;
        CvssV4Data.CiaType vulnIntegrityImpact = values.containsKey("VI") ? CvssV4Data.CiaType.fromValue((String)((String)values.get("VI"))) : null;
        CvssV4Data.CiaType vulnAvailabilityImpact = values.containsKey("VA") ? CvssV4Data.CiaType.fromValue((String)((String)values.get("VA"))) : null;
        CvssV4Data.CiaType subConfidentialityImpact = values.containsKey("SC") ? CvssV4Data.CiaType.fromValue((String)((String)values.get("SC"))) : null;
        CvssV4Data.CiaType subIntegrityImpact = values.containsKey("SI") ? CvssV4Data.CiaType.fromValue((String)((String)values.get("SI"))) : null;
        CvssV4Data.CiaType subAvailabilityImpact = values.containsKey("SA") ? CvssV4Data.CiaType.fromValue((String)((String)values.get("SA"))) : null;
        CvssV4Data.ExploitMaturityType exploitMaturity = values.containsKey("E") ? CvssV4Data.ExploitMaturityType.fromValue((String)((String)values.get("E"))) : CvssV4Data.ExploitMaturityType.NOT_DEFINED;
        CvssV4Data.CiaRequirementType confidentialityRequirement = values.containsKey("CR") ? CvssV4Data.CiaRequirementType.fromValue((String)((String)values.get("CR"))) : CvssV4Data.CiaRequirementType.NOT_DEFINED;
        CvssV4Data.CiaRequirementType integrityRequirement = values.containsKey("IR") ? CvssV4Data.CiaRequirementType.fromValue((String)((String)values.get("IR"))) : CvssV4Data.CiaRequirementType.NOT_DEFINED;
        CvssV4Data.CiaRequirementType availabilityRequirement = values.containsKey("AR") ? CvssV4Data.CiaRequirementType.fromValue((String)((String)values.get("AR"))) : CvssV4Data.CiaRequirementType.NOT_DEFINED;
        CvssV4Data.ModifiedAttackVectorType modifiedAttackVector = values.containsKey("MAV") ? CvssV4Data.ModifiedAttackVectorType.fromValue((String)((String)values.get("MAV"))) : CvssV4Data.ModifiedAttackVectorType.NOT_DEFINED;
        CvssV4Data.ModifiedAttackComplexityType modifiedAttackComplexity = values.containsKey("MAC") ? CvssV4Data.ModifiedAttackComplexityType.fromValue((String)((String)values.get("MAC"))) : CvssV4Data.ModifiedAttackComplexityType.NOT_DEFINED;
        CvssV4Data.ModifiedAttackRequirementsType modifiedAttackRequirements = values.containsKey("MAT") ? CvssV4Data.ModifiedAttackRequirementsType.fromValue((String)((String)values.get("MAT"))) : CvssV4Data.ModifiedAttackRequirementsType.NOT_DEFINED;
        CvssV4Data.ModifiedPrivilegesRequiredType modifiedPrivilegesRequired = values.containsKey("MPR") ? CvssV4Data.ModifiedPrivilegesRequiredType.fromValue((String)((String)values.get("MPR"))) : CvssV4Data.ModifiedPrivilegesRequiredType.NOT_DEFINED;
        CvssV4Data.ModifiedUserInteractionType modifiedUserInteraction = values.containsKey("MUI") ? CvssV4Data.ModifiedUserInteractionType.fromValue((String)((String)values.get("MUI"))) : CvssV4Data.ModifiedUserInteractionType.NOT_DEFINED;
        CvssV4Data.ModifiedCiaType modifiedVulnConfidentialityImpact = values.containsKey("MVC") ? CvssV4Data.ModifiedCiaType.fromValue((String)((String)values.get("MVC"))) : CvssV4Data.ModifiedCiaType.NOT_DEFINED;
        CvssV4Data.ModifiedCiaType modifiedVulnIntegrityImpact = values.containsKey("MVI") ? CvssV4Data.ModifiedCiaType.fromValue((String)((String)values.get("MVI"))) : CvssV4Data.ModifiedCiaType.NOT_DEFINED;
        CvssV4Data.ModifiedCiaType modifiedVulnAvailabilityImpact = values.containsKey("MVA") ? CvssV4Data.ModifiedCiaType.fromValue((String)((String)values.get("MVA"))) : CvssV4Data.ModifiedCiaType.NOT_DEFINED;
        CvssV4Data.ModifiedSubCType modifiedSubConfidentialityImpact = values.containsKey("MSC") ? CvssV4Data.ModifiedSubCType.fromValue((String)((String)values.get("MSC"))) : CvssV4Data.ModifiedSubCType.NOT_DEFINED;
        CvssV4Data.ModifiedSubIaType modifiedSubIntegrityImpact = values.containsKey("MSI") ? CvssV4Data.ModifiedSubIaType.fromValue((String)((String)values.get("MSI"))) : CvssV4Data.ModifiedSubIaType.NOT_DEFINED;
        CvssV4Data.ModifiedSubIaType modifiedSubAvailabilityImpact = values.containsKey("MSA") ? CvssV4Data.ModifiedSubIaType.fromValue((String)((String)values.get("MSA"))) : CvssV4Data.ModifiedSubIaType.NOT_DEFINED;
        CvssV4Data.SafetyType safety = values.containsKey("S") ? CvssV4Data.SafetyType.fromValue((String)((String)values.get("S"))) : CvssV4Data.SafetyType.NOT_DEFINED;
        CvssV4Data.AutomatableType automatable = values.containsKey("AU") ? CvssV4Data.AutomatableType.fromValue((String)((String)values.get("AU"))) : CvssV4Data.AutomatableType.NOT_DEFINED;
        CvssV4Data.RecoveryType recovery = values.containsKey("R") ? CvssV4Data.RecoveryType.fromValue((String)((String)values.get("R"))) : CvssV4Data.RecoveryType.NOT_DEFINED;
        CvssV4Data.ValueDensityType valueDensity = values.containsKey("V") ? CvssV4Data.ValueDensityType.fromValue((String)((String)values.get("V"))) : CvssV4Data.ValueDensityType.NOT_DEFINED;
        CvssV4Data.VulnerabilityResponseEffortType vulnerabilityResponseEffort = values.containsKey("RE") ? CvssV4Data.VulnerabilityResponseEffortType.fromValue((String)((String)values.get("RE"))) : CvssV4Data.VulnerabilityResponseEffortType.NOT_DEFINED;
        CvssV4Data.ProviderUrgencyType providerUrgency = values.containsKey("U") ? CvssV4Data.ProviderUrgencyType.fromValue((String)((String)values.get("U"))) : CvssV4Data.ProviderUrgencyType.NOT_DEFINED;
        CvssV4Data.SeverityType baseSeverity = CvssUtil.toSeverityType(baseScore);
        Double threatScore = null;
        CvssV4Data.SeverityType threatSeverity = null;
        Double environmentalScore = null;
        CvssV4Data.SeverityType environmentalSeverity = null;
        CvssV4Data cvssData = new CvssV4Data(version, vectorString, attackVector, attackComplexity, attackRequirements, privilegesRequired, userInteraction, vulnConfidentialityImpact, vulnIntegrityImpact, vulnAvailabilityImpact, subConfidentialityImpact, subIntegrityImpact, subAvailabilityImpact, exploitMaturity, confidentialityRequirement, integrityRequirement, availabilityRequirement, modifiedAttackVector, modifiedAttackComplexity, modifiedAttackRequirements, modifiedPrivilegesRequired, modifiedUserInteraction, modifiedVulnConfidentialityImpact, modifiedVulnIntegrityImpact, modifiedVulnAvailabilityImpact, modifiedSubConfidentialityImpact, modifiedSubIntegrityImpact, modifiedSubAvailabilityImpact, safety, automatable, recovery, valueDensity, vulnerabilityResponseEffort, providerUrgency, baseScore, baseSeverity, threatScore, threatSeverity, environmentalScore, environmentalSeverity);
        return new CvssV4(source, type, cvssData);
    }
}

