/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.data.nuget;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.owasp.dependencycheck.data.nuget.MSBuildProjectParseException;
import org.owasp.dependencycheck.utils.XmlUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class DirectoryBuildPropsParser {
    private Set<String> imports = new HashSet<String>();

    public Set<String> getImports() {
        return this.imports;
    }

    public Map<String, String> parse(InputStream stream) throws MSBuildProjectParseException {
        try {
            NodeList propertyGroups;
            HashMap<String, String> props = new HashMap<String, String>();
            DocumentBuilder db = XmlUtils.buildSecureDocumentBuilder();
            Document d = db.parse(stream);
            XPath xpath = XPathFactory.newInstance().newXPath();
            NodeList importList = (NodeList)xpath.evaluate("//Import", d, XPathConstants.NODESET);
            if (importList != null) {
                for (int i = 0; i < importList.getLength(); ++i) {
                    Node importNode = importList.item(i);
                    Node project = importNode.getAttributes().getNamedItem("Project");
                    this.imports.add(project.getNodeValue());
                }
            }
            if ((propertyGroups = (NodeList)xpath.evaluate("//PropertyGroup", d, XPathConstants.NODESET)) != null) {
                for (int i = 0; i < propertyGroups.getLength(); ++i) {
                    Node group = propertyGroups.item(i);
                    NodeList propertyNodes = group.getChildNodes();
                    for (int x = 0; x < propertyNodes.getLength(); ++x) {
                        Node node = propertyNodes.item(x);
                        if (!(node instanceof Element)) continue;
                        Element property = (Element)node;
                        String name = property.getNodeName();
                        Node value = property.getChildNodes().item(0);
                        if (value == null) continue;
                        props.put(name, value.getNodeValue().trim());
                    }
                }
            }
            return props;
        }
        catch (IOException | ParserConfigurationException | XPathExpressionException | SAXException ex) {
            throw new MSBuildProjectParseException("Error parsing Directory.Build.props", ex);
        }
    }
}

