/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.data.cwe;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.concurrent.ThreadSafe;
import org.owasp.dependencycheck.utils.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class CweDB {
    private static final Logger LOGGER = LoggerFactory.getLogger(CweDB.class);
    private static final Map<String, String> CWE = CweDB.loadData();

    private CweDB() {
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private static Map<String, String> loadData() {
        String filePath = "data/cwe.hashmap.serialized";
        try (InputStream input = FileUtils.getResourceAsStream((String)"data/cwe.hashmap.serialized");){
            HashMap hashMap;
            try (ObjectInputStream oin = new ObjectInputStream(input);){
                hashMap = (HashMap)oin.readObject();
            }
            return hashMap;
        }
        catch (ClassNotFoundException ex) {
            LOGGER.warn("Unable to load CWE data. This should not be an issue.");
            LOGGER.debug("", (Throwable)ex);
        }
        catch (IOException ex) {
            LOGGER.warn("Unable to load CWE data due to an IO Error. This should not be an issue.");
            LOGGER.debug("", (Throwable)ex);
        }
        return null;
    }

    public static synchronized String getName(String cweId) {
        if (cweId != null) {
            return CWE.get(cweId);
        }
        return null;
    }

    public static synchronized String getFullName(String cweId) {
        String name = CweDB.getName(cweId);
        if (name != null) {
            return cweId + " " + name;
        }
        return cweId;
    }
}

