/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.analyzer;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.github.packageurl.MalformedPackageURLException;
import com.github.packageurl.PackageURLBuilder;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.concurrent.ThreadSafe;
import org.owasp.dependencycheck.Engine;
import org.owasp.dependencycheck.analyzer.AbstractFileTypeAnalyzer;
import org.owasp.dependencycheck.analyzer.AnalysisPhase;
import org.owasp.dependencycheck.analyzer.Experimental;
import org.owasp.dependencycheck.analyzer.exception.AnalysisException;
import org.owasp.dependencycheck.dependency.Confidence;
import org.owasp.dependencycheck.dependency.Dependency;
import org.owasp.dependencycheck.dependency.EvidenceType;
import org.owasp.dependencycheck.dependency.naming.GenericIdentifier;
import org.owasp.dependencycheck.dependency.naming.PurlIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Experimental
@ThreadSafe
public class PinnedMavenInstallAnalyzer
extends AbstractFileTypeAnalyzer {
    private static final Logger LOGGER = LoggerFactory.getLogger(PinnedMavenInstallAnalyzer.class);
    private static final String ANALYZER_NAME = "Pinned Maven install Analyzer";
    private static final AnalysisPhase ANALYSIS_PHASE = AnalysisPhase.INFORMATION_COLLECTION;
    private static final Pattern MAVEN_INSTALL_JSON_PATTERN = Pattern.compile("(.+install.*|.*install.+)\\.json");
    private static final FileFilter FILTER = file -> MAVEN_INSTALL_JSON_PATTERN.matcher(file.getName()).matches();
    private static final ObjectReader INSTALL_FILE_READER;
    private static final ObjectReader INSTALL_FILE_V2_READER;
    private static final ObjectMapper MAPPER;

    @Override
    protected FileFilter getFileFilter() {
        return FILTER;
    }

    @Override
    public String getName() {
        return ANALYZER_NAME;
    }

    @Override
    public AnalysisPhase getAnalysisPhase() {
        return ANALYSIS_PHASE;
    }

    @Override
    protected String getAnalyzerEnabledSettingKey() {
        return "analyzer.maveninstall.enabled";
    }

    @Override
    protected void analyzeDependency(Dependency dependency, Engine engine) throws AnalysisException {
        List<Object> deps;
        block22: {
            LOGGER.debug("Checking file {}", (Object)dependency.getActualFilePath());
            File dependencyFile = dependency.getActualFile();
            if (!dependencyFile.isFile() || dependencyFile.length() == 0L) {
                return;
            }
            try {
                Object installFile;
                JsonNode jsonNode = MAPPER.readTree(dependencyFile);
                JsonNode jsonNode2 = jsonNode.path("version");
                JsonNode v010Version = jsonNode.path("dependency_tree").path("version");
                if (jsonNode2.isTextual()) {
                    installFile = (InstallFileV2)INSTALL_FILE_V2_READER.readValue(dependencyFile);
                    if (!Objects.equals(((InstallFileV2)installFile).getAutogeneratedSentinel(), "THERE_IS_NO_DATA_ONLY_ZUUL")) {
                        return;
                    }
                    if (!Objects.equals(((InstallFileV2)installFile).getVersion(), "2")) {
                        LOGGER.warn("Unsupported pinned maven_install.json version {}. Continuing optimistically.", (Object)((InstallFileV2)installFile).getVersion());
                    }
                    deps = ((InstallFileV2)installFile).getArtifacts().entrySet().stream().map(entry -> new MavenDependency((String)entry.getKey() + ":" + ((Artifactv2)entry.getValue()).getVersion())).collect(Collectors.toList());
                    break block22;
                }
                if (v010Version.isTextual()) {
                    installFile = (InstallFile)INSTALL_FILE_READER.readValue(dependencyFile);
                    DependencyTree tree = ((InstallFile)installFile).getDependencyTree();
                    if (tree == null) {
                        return;
                    }
                    if (!Objects.equals(tree.getAutogeneratedSentinel(), "THERE_IS_NO_DATA_ONLY_ZUUL")) {
                        return;
                    }
                    if (!Objects.equals(tree.getVersion(), "0.1.0")) {
                        LOGGER.warn("Unsupported pinned maven_install.json version {}. Continuing optimistically.", (Object)tree.getVersion());
                    }
                    deps = tree.getDependencies();
                    break block22;
                }
                LOGGER.warn("No pinned maven_install.json version found. Cannot Parse");
                return;
            }
            catch (IOException e) {
                System.out.println("e");
                return;
            }
        }
        engine.removeDependency(dependency);
        if (deps == null) {
            deps = Collections.emptyList();
        }
        for (MavenDependency mavenDependency : deps) {
            String version;
            if (mavenDependency.getCoord() == null) {
                LOGGER.warn("Unexpected null coordinate in {}", (Object)dependency.getActualFilePath());
                continue;
            }
            LOGGER.debug("Analyzing {}", (Object)mavenDependency.getCoord());
            String[] pieces = mavenDependency.getCoord().split(":");
            if (pieces.length < 3 || pieces.length > 5) {
                LOGGER.warn("Invalid maven coordinate {}", (Object)mavenDependency.getCoord());
                continue;
            }
            String group = pieces[0];
            String artifact = pieces[1];
            String classifier = null;
            switch (pieces.length) {
                case 3: {
                    version = pieces[2];
                    break;
                }
                case 4: {
                    classifier = pieces[2];
                    version = pieces[3];
                    break;
                }
                default: {
                    classifier = pieces[3];
                    version = pieces[4];
                }
            }
            if ("sources".equals(classifier) || "javadoc".equals(classifier)) {
                LOGGER.debug("Skipping sources jar {}", (Object)mavenDependency.getCoord());
                continue;
            }
            Dependency d = new Dependency(dependency.getActualFile(), true);
            d.setEcosystem("java");
            d.addEvidence(EvidenceType.VENDOR, "project", "groupid", group, Confidence.HIGHEST);
            d.addEvidence(EvidenceType.PRODUCT, "project", "artifactid", artifact, Confidence.HIGHEST);
            d.addEvidence(EvidenceType.VENDOR, "project", "artifactid", artifact, Confidence.HIGH);
            d.addEvidence(EvidenceType.VERSION, "project", "version", version, Confidence.HIGHEST);
            d.setName(String.format("%s:%s", group, artifact));
            d.setFilePath(String.format("%s>>%s", dependency.getActualFile(), mavenDependency.getCoord()));
            d.setFileName(mavenDependency.getCoord());
            try {
                PackageURLBuilder purl = PackageURLBuilder.aPackageURL().withType("maven").withNamespace(group).withName(artifact).withVersion(version);
                if (classifier != null) {
                    purl.withQualifier("classifier", classifier);
                }
                d.addSoftwareIdentifier(new PurlIdentifier(purl.build(), Confidence.HIGHEST));
            }
            catch (MalformedPackageURLException e) {
                d.addSoftwareIdentifier(new GenericIdentifier("maven_install JSON coord " + mavenDependency.getCoord(), Confidence.HIGH));
            }
            d.setVersion(version);
            engine.addDependency(d);
        }
    }

    @Override
    protected void prepareFileTypeAnalyzer(Engine engine) {
    }

    static {
        MAPPER = new ObjectMapper();
        MAPPER.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        INSTALL_FILE_READER = MAPPER.readerFor(InstallFile.class);
        INSTALL_FILE_V2_READER = MAPPER.readerFor(InstallFileV2.class);
    }

    private static class Artifactv2 {
        @JsonProperty(value="version")
        private String version;

        private Artifactv2() {
        }

        public String getVersion() {
            return this.version;
        }
    }

    private static class InstallFileV2 {
        @JsonProperty(value="version")
        private String version;
        @JsonProperty(value="artifacts")
        private Map<String, Artifactv2> artifacts;
        @JsonProperty(value="__AUTOGENERATED_FILE_DO_NOT_MODIFY_THIS_FILE_MANUALLY")
        private String autogeneratedSentinel;

        private InstallFileV2() {
        }

        public Map<String, Artifactv2> getArtifacts() {
            return this.artifacts;
        }

        public String getVersion() {
            return this.version;
        }

        public String getAutogeneratedSentinel() {
            return this.autogeneratedSentinel;
        }
    }

    private static class MavenDependency {
        @JsonProperty(value="coord")
        private String coord;

        MavenDependency(String coord) {
            this.coord = coord;
        }

        MavenDependency() {
        }

        public String getCoord() {
            return this.coord;
        }
    }

    private static class DependencyTree {
        @JsonProperty(value="__AUTOGENERATED_FILE_DO_NOT_MODIFY_THIS_FILE_MANUALLY")
        private String autogeneratedSentinel;
        @JsonProperty(value="dependencies")
        private List<MavenDependency> dependencies;
        @JsonProperty(value="version")
        private String version;

        private DependencyTree() {
        }

        public String getAutogeneratedSentinel() {
            return this.autogeneratedSentinel;
        }

        public List<MavenDependency> getDependencies() {
            return this.dependencies;
        }

        public String getVersion() {
            return this.version;
        }
    }

    private static class InstallFile {
        @JsonProperty(value="dependency_tree")
        private DependencyTree dependencyTree;

        private InstallFile() {
        }

        public DependencyTree getDependencyTree() {
            return this.dependencyTree;
        }
    }
}

