/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.analyzer;

import io.github.jeremylong.openvulnerability.client.nvd.CvssV2;
import io.github.jeremylong.openvulnerability.client.nvd.CvssV2Data;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.owasp.dependencycheck.Engine;
import org.owasp.dependencycheck.analyzer.AbstractAnalyzer;
import org.owasp.dependencycheck.analyzer.AnalysisPhase;
import org.owasp.dependencycheck.analyzer.exception.AnalysisException;
import org.owasp.dependencycheck.data.ossindex.OssindexClientFactory;
import org.owasp.dependencycheck.dependency.Dependency;
import org.owasp.dependencycheck.dependency.Vulnerability;
import org.owasp.dependencycheck.dependency.VulnerableSoftware;
import org.owasp.dependencycheck.dependency.VulnerableSoftwareBuilder;
import org.owasp.dependencycheck.dependency.naming.Identifier;
import org.owasp.dependencycheck.dependency.naming.PurlIdentifier;
import org.owasp.dependencycheck.utils.CvssUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.goodies.packageurl.InvalidException;
import org.sonatype.goodies.packageurl.PackageUrl;
import org.sonatype.ossindex.service.api.componentreport.ComponentReport;
import org.sonatype.ossindex.service.api.componentreport.ComponentReportVulnerability;
import org.sonatype.ossindex.service.api.cvss.Cvss2Severity;
import org.sonatype.ossindex.service.api.cvss.Cvss2Vector;
import org.sonatype.ossindex.service.api.cvss.CvssVector;
import org.sonatype.ossindex.service.api.cvss.CvssVectorFactory;
import org.sonatype.ossindex.service.client.OssindexClient;
import org.sonatype.ossindex.service.client.transport.Transport;
import us.springett.parsers.cpe.exceptions.CpeValidationException;
import us.springett.parsers.cpe.values.Part;

public class OssIndexAnalyzer
extends AbstractAnalyzer {
    private static final Logger LOG = LoggerFactory.getLogger(OssIndexAnalyzer.class);
    private static final Pattern CVE_PATTERN = Pattern.compile("\\bCVE-\\d{4}-\\d{4,10}\\b");
    public static final String REFERENCE_TYPE = "OSSINDEX";
    private static Map<PackageUrl, ComponentReport> reports;
    private static final Object FETCH_MUTIX;

    @Override
    public String getName() {
        return "Sonatype OSS Index Analyzer";
    }

    @Override
    public AnalysisPhase getAnalysisPhase() {
        return AnalysisPhase.FINDING_ANALYSIS_PHASE2;
    }

    @Override
    protected String getAnalyzerEnabledSettingKey() {
        return "analyzer.ossindex.enabled";
    }

    @Override
    public boolean supportsParallelProcessing() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void closeAnalyzer() throws Exception {
        Object object = FETCH_MUTIX;
        synchronized (object) {
            reports = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void analyzeDependency(Dependency dependency, Engine engine) throws AnalysisException {
        Object object = FETCH_MUTIX;
        synchronized (object) {
            if (reports == null) {
                try {
                    this.requestDelay();
                    reports = this.requestReports(engine.getDependencies());
                }
                catch (Transport.TransportException ex) {
                    String message = ex.getMessage();
                    boolean warnOnly = this.getSettings().getBoolean("analyzer.ossindex.remote-error.warn-only", false);
                    this.setEnabled(false);
                    if (StringUtils.endsWith((CharSequence)message, (CharSequence)"401")) {
                        LOG.error("Invalid credentials for the OSS Index, disabling the analyzer");
                        throw new AnalysisException("Invalid credentials provided for OSS Index", ex);
                    }
                    if (StringUtils.endsWith((CharSequence)message, (CharSequence)"403")) {
                        LOG.error("OSS Index access forbidden, disabling the analyzer");
                        throw new AnalysisException("OSS Index access forbidden", ex);
                    }
                    if (StringUtils.endsWith((CharSequence)message, (CharSequence)"429")) {
                        if (warnOnly) {
                            LOG.warn("OSS Index rate limit exceeded, disabling the analyzer", (Throwable)ex);
                        }
                        throw new AnalysisException("OSS Index rate limit exceeded, disabling the analyzer", ex);
                    }
                    if (warnOnly) {
                        LOG.warn("Error requesting component reports, disabling the analyzer", (Throwable)ex);
                    }
                    LOG.debug("Error requesting component reports, disabling the analyzer", (Throwable)ex);
                    throw new AnalysisException("Failed to request component-reports", ex);
                }
                catch (SocketTimeoutException e) {
                    boolean warnOnly = this.getSettings().getBoolean("analyzer.ossindex.remote-error.warn-only", false);
                    this.setEnabled(false);
                    if (warnOnly) {
                        LOG.warn("OSS Index socket timeout, disabling the analyzer", (Throwable)e);
                    }
                    LOG.debug("OSS Index socket timeout", (Throwable)e);
                    throw new AnalysisException("Failed to establish socket to OSS Index", e);
                }
                catch (Exception e) {
                    LOG.debug("Error requesting component reports", (Throwable)e);
                    throw new AnalysisException("Failed to request component-reports", e);
                }
            }
            if (reports != null) {
                this.enrich(dependency);
            }
        }
    }

    private void requestDelay() throws InterruptedException {
        int delay = this.getSettings().getInt("analyzer.ossindex.request.delay", 0);
        if (delay > 0) {
            LOG.debug("Request delay: " + delay);
            TimeUnit.SECONDS.sleep(delay);
        }
    }

    @Nullable
    private PackageUrl parsePackageUrl(String value) {
        try {
            return PackageUrl.parse((String)value);
        }
        catch (InvalidException e) {
            LOG.debug("Invalid Package-URL: {}", (Object)value, (Object)e);
            return null;
        }
    }

    private Map<PackageUrl, ComponentReport> requestReports(Dependency[] dependencies) throws Exception {
        LOG.debug("Requesting component-reports for {} dependencies", (Object)dependencies.length);
        ArrayList packages = new ArrayList();
        Arrays.stream(dependencies).forEach(dependency -> dependency.getSoftwareIdentifiers().stream().filter(id -> id instanceof PurlIdentifier).map(id -> this.parsePackageUrl(id.getValue())).filter(id -> id != null && StringUtils.isNotBlank((CharSequence)id.getVersion())).forEach(packages::add));
        if (!packages.isEmpty()) {
            try (OssindexClient client = this.newOssIndexClient();){
                LOG.debug("OSS Index Analyzer submitting: " + packages);
                Map map = client.requestComponentReports(packages);
                return map;
            }
        }
        LOG.warn("Unable to determine Package-URL identifiers for {} dependencies", (Object)dependencies.length);
        return Collections.emptyMap();
    }

    OssindexClient newOssIndexClient() {
        return OssindexClientFactory.create(this.getSettings());
    }

    void enrich(Dependency dependency) {
        LOG.debug("Enrich dependency: {}", (Object)dependency);
        for (Identifier id : dependency.getSoftwareIdentifiers()) {
            if (!(id instanceof PurlIdentifier)) continue;
            LOG.debug("  Package: {} -> {}", (Object)id, (Object)id.getConfidence());
            PackageUrl purl = this.parsePackageUrl(id.getValue());
            if (purl == null || !StringUtils.isNotBlank((CharSequence)purl.getVersion())) continue;
            try {
                ComponentReport report = reports.get(purl);
                if (report == null) {
                    LOG.debug("Missing component-report for: " + purl);
                    continue;
                }
                id.setUrl(report.getReference().toString());
                report.getVulnerabilities().stream().map(vuln -> this.transform(report, (ComponentReportVulnerability)vuln)).forEachOrdered(v -> {
                    Vulnerability existing = dependency.getVulnerabilities().stream().filter(e -> e.getName().equals(v.getName())).findFirst().orElse(null);
                    if (existing != null) {
                        existing.addReferences(v.getReferences());
                    } else {
                        dependency.addVulnerability((Vulnerability)v);
                    }
                });
            }
            catch (Exception e) {
                LOG.warn("Failed to fetch component-report for: {}", (Object)purl, (Object)e);
            }
        }
    }

    private Vulnerability transform(ComponentReport report, ComponentReportVulnerability source) {
        double cvssScore;
        Vulnerability result = new Vulnerability();
        result.setSource(Vulnerability.Source.OSSINDEX);
        if (source.getCve() != null) {
            result.setName(source.getCve());
        } else {
            Matcher matcher;
            String cve = null;
            if (source.getTitle() != null) {
                matcher = CVE_PATTERN.matcher(source.getTitle());
                cve = matcher.find() ? matcher.group() : source.getTitle();
            }
            if (cve == null && source.getReference() != null && (matcher = CVE_PATTERN.matcher(source.getReference().toString())).find()) {
                cve = matcher.group();
            }
            result.setName(cve != null ? cve : source.getId());
        }
        result.setDescription(source.getDescription());
        result.addCwe(source.getCwe());
        double d = cvssScore = source.getCvssScore() != null ? source.getCvssScore().doubleValue() : -1.0;
        if (source.getCvssVector() != null) {
            if (source.getCvssVector().startsWith("CVSS:3")) {
                result.setCvssV3(CvssUtil.vectorToCvssV3(source.getCvssVector(), cvssScore));
            } else {
                CvssVector cvssVector = CvssVectorFactory.create((String)source.getCvssVector());
                Map metrics = cvssVector.getMetrics();
                if (cvssVector instanceof Cvss2Vector) {
                    String tmp = (String)metrics.get("AV");
                    CvssV2Data.AccessVectorType accessVector = null;
                    if (tmp != null) {
                        accessVector = CvssV2Data.AccessVectorType.fromValue((String)tmp);
                    }
                    tmp = (String)metrics.get("AC");
                    CvssV2Data.AccessComplexityType accessComplexity = null;
                    if (tmp != null) {
                        accessComplexity = CvssV2Data.AccessComplexityType.fromValue((String)tmp);
                    }
                    tmp = (String)metrics.get("Au");
                    CvssV2Data.AuthenticationType authentication = null;
                    if (tmp != null) {
                        authentication = CvssV2Data.AuthenticationType.fromValue((String)tmp);
                    }
                    tmp = (String)metrics.get("C");
                    CvssV2Data.CiaType confidentialityImpact = null;
                    if (tmp != null) {
                        confidentialityImpact = CvssV2Data.CiaType.fromValue((String)tmp);
                    }
                    tmp = (String)metrics.get("I");
                    CvssV2Data.CiaType integrityImpact = null;
                    if (tmp != null) {
                        integrityImpact = CvssV2Data.CiaType.fromValue((String)tmp);
                    }
                    tmp = (String)metrics.get("A");
                    CvssV2Data.CiaType availabilityImpact = null;
                    if (tmp != null) {
                        availabilityImpact = CvssV2Data.CiaType.fromValue((String)tmp);
                    }
                    String severity = Cvss2Severity.of((Float)Float.valueOf((float)cvssScore)).name().toUpperCase();
                    CvssV2Data cvssData = new CvssV2Data(CvssV2Data.Version._2_0, source.getCvssVector(), accessVector, accessComplexity, authentication, confidentialityImpact, integrityImpact, availabilityImpact, Double.valueOf(cvssScore), severity, null, null, null, null, null, null, null, null, null, null);
                    CvssV2 cvssV2 = new CvssV2(null, null, cvssData, severity, null, null, null, null, null, null, null);
                    result.setCvssV2(cvssV2);
                } else {
                    LOG.warn("Unsupported CVSS vector: {}", (Object)cvssVector);
                    result.setUnscoredSeverity(Double.toString(cvssScore));
                }
            }
        } else {
            LOG.debug("OSS has no vector for {}", (Object)result.getName());
            result.setUnscoredSeverity(Double.toString(cvssScore));
        }
        result.addReference(REFERENCE_TYPE, source.getTitle(), source.getReference().toString());
        source.getExternalReferences().forEach(externalReference -> result.addReference("OSSIndex", externalReference.toString(), externalReference.toString()));
        PackageUrl purl = report.getCoordinates();
        try {
            VulnerableSoftwareBuilder builder = new VulnerableSoftwareBuilder().part(Part.APPLICATION).vendor(purl.getNamespaceAsString()).product(purl.getName()).version(purl.getVersion());
            VulnerableSoftware software = builder.build();
            result.addVulnerableSoftware(software);
            result.setMatchedVulnerableSoftware(software);
        }
        catch (CpeValidationException e) {
            LOG.warn("Unable to construct vulnerable-software for: {}", (Object)purl, (Object)e);
        }
        return result;
    }

    static {
        FETCH_MUTIX = new Object();
    }
}

