/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.analyzer;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.annotation.concurrent.ThreadSafe;
import org.owasp.dependencycheck.Engine;
import org.owasp.dependencycheck.analyzer.AbstractAnalyzer;
import org.owasp.dependencycheck.analyzer.exception.AnalysisException;
import org.owasp.dependencycheck.data.update.HostedSuppressionsDataSource;
import org.owasp.dependencycheck.data.update.exception.UpdateException;
import org.owasp.dependencycheck.dependency.Dependency;
import org.owasp.dependencycheck.exception.InitializationException;
import org.owasp.dependencycheck.exception.WriteLockException;
import org.owasp.dependencycheck.utils.FileUtils;
import org.owasp.dependencycheck.utils.WriteLock;
import org.owasp.dependencycheck.xml.suppression.SuppressionParseException;
import org.owasp.dependencycheck.xml.suppression.SuppressionParser;
import org.owasp.dependencycheck.xml.suppression.SuppressionRule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

@ThreadSafe
public abstract class AbstractSuppressionAnalyzer
extends AbstractAnalyzer {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractSuppressionAnalyzer.class);
    private static final String BASE_SUPPRESSION_FILE = "dependencycheck-base-suppression.xml";
    public static final String SUPPRESSION_OBJECT_KEY = "suppression.rules";

    public Set<String> getSupportedExtensions() {
        return null;
    }

    @Override
    public synchronized void prepareAnalyzer(Engine engine) throws InitializationException {
        if (engine.hasObject(SUPPRESSION_OBJECT_KEY)) {
            return;
        }
        try {
            this.loadSuppressionBaseData(engine);
        }
        catch (SuppressionParseException ex) {
            throw new InitializationException("Error initializing the suppression analyzer: " + ex.getLocalizedMessage(), ex, true);
        }
        try {
            this.loadSuppressionData(engine);
        }
        catch (SuppressionParseException ex) {
            throw new InitializationException("Warn initializing the suppression analyzer: " + ex.getLocalizedMessage(), ex, false);
        }
    }

    @Override
    protected void analyzeDependency(Dependency dependency, Engine engine) throws AnalysisException {
        if (engine == null) {
            return;
        }
        List rules = (List)engine.getObject(SUPPRESSION_OBJECT_KEY);
        if (rules.isEmpty()) {
            return;
        }
        for (SuppressionRule rule : rules) {
            if (!this.filter(rule)) continue;
            rule.process(dependency);
        }
    }

    abstract boolean filter(SuppressionRule var1);

    private void loadSuppressionData(Engine engine) throws SuppressionParseException {
        ArrayList<SuppressionRule> ruleList = new ArrayList<SuppressionRule>();
        SuppressionParser parser = new SuppressionParser();
        String[] suppressionFilePaths = this.getSettings().getArray("suppression.file");
        ArrayList<String> failedLoadingFiles = new ArrayList<String>();
        if (suppressionFilePaths != null && suppressionFilePaths.length > 0) {
            for (String suppressionFilePath : suppressionFilePaths) {
                try {
                    ruleList.addAll(this.loadSuppressionFile(parser, suppressionFilePath));
                }
                catch (SuppressionParseException ex) {
                    String msg = String.format("Failed to load %s, caused by %s. ", suppressionFilePath, ex.getMessage());
                    failedLoadingFiles.add(msg);
                }
            }
        }
        LOGGER.debug("{} suppression rules were loaded.", (Object)ruleList.size());
        if (!ruleList.isEmpty()) {
            if (engine.hasObject(SUPPRESSION_OBJECT_KEY)) {
                List rules = (List)engine.getObject(SUPPRESSION_OBJECT_KEY);
                rules.addAll(ruleList);
            } else {
                engine.putObject(SUPPRESSION_OBJECT_KEY, ruleList);
            }
        }
        if (!failedLoadingFiles.isEmpty()) {
            LOGGER.debug("{} suppression files failed to load.", (Object)failedLoadingFiles.size());
            StringBuilder sb = new StringBuilder();
            failedLoadingFiles.forEach(sb::append);
            throw new SuppressionParseException(sb.toString());
        }
    }

    private void loadSuppressionBaseData(Engine engine) throws SuppressionParseException {
        SuppressionParser parser = new SuppressionParser();
        this.loadPackagedSuppressionBaseData(parser, engine);
        this.loadHostedSuppressionBaseData(parser, engine);
    }

    private void loadPackagedSuppressionBaseData(SuppressionParser parser, Engine engine) throws SuppressionParseException {
        List<SuppressionRule> ruleList;
        try (InputStream in = FileUtils.getResourceAsStream((String)BASE_SUPPRESSION_FILE);){
            if (in == null) {
                throw new SuppressionParseException("Suppression rules `dependencycheck-base-suppression.xml` could not be found");
            }
            ruleList = parser.parseSuppressionRules(in);
        }
        catch (IOException | SAXException ex) {
            throw new SuppressionParseException("Unable to parse the base suppression data file", ex);
        }
        if (!ruleList.isEmpty()) {
            if (engine.hasObject(SUPPRESSION_OBJECT_KEY)) {
                List rules = (List)engine.getObject(SUPPRESSION_OBJECT_KEY);
                rules.addAll(ruleList);
            } else {
                engine.putObject(SUPPRESSION_OBJECT_KEY, ruleList);
            }
        }
    }

    private void loadHostedSuppressionBaseData(SuppressionParser parser, Engine engine) {
        boolean repoEmpty = false;
        boolean enabled = this.getSettings().getBoolean("hosted.suppressions.enabled", true);
        if (!enabled) {
            return;
        }
        boolean autoupdate = this.getSettings().getBoolean("odc.autoupdate", true);
        boolean forceupdate = this.getSettings().getBoolean("hosted.suppressions.forceupdate", false);
        try {
            String configuredUrl = this.getSettings().getString("hosted.suppressions.url", "https://jeremylong.github.io/DependencyCheck/suppressions/publishedSuppressions.xml");
            URL url = new URL(configuredUrl);
            String fileName = new File(url.getPath()).getName();
            File repoFile = new File(this.getSettings().getDataDirectory(), fileName);
            if (!repoFile.isFile() || repoFile.length() <= 1L) {
                repoEmpty = true;
                LOGGER.warn("Hosted Suppressions file is empty or missing - attempting to force the update");
                this.getSettings().setBoolean("hosted.suppressions.forceupdate", true);
            }
            if (!autoupdate && forceupdate || autoupdate && repoEmpty) {
                if (engine == null) {
                    LOGGER.warn("Engine was null, this should only happen in tests - skipping forced update");
                } else {
                    repoEmpty = AbstractSuppressionAnalyzer.forceUpdateHostedSuppressions(engine, repoFile);
                }
            }
            if (!repoEmpty) {
                this.loadCachedHostedSuppressionsRules(parser, repoFile, engine);
            } else {
                LOGGER.warn("Empty Hosted Suppression file after update, results may contain false positives already resolved by the DependencyCheck project due to failed download of the hosted suppression file");
            }
        }
        catch (IOException | InitializationException ex) {
            LOGGER.warn("Unable to load hosted suppressions", (Throwable)ex);
        }
    }

    private void loadCachedHostedSuppressionsRules(SuppressionParser parser, File repoFile, Engine engine) throws InitializationException {
        Path defensiveCopy;
        try (WriteLock lock = new WriteLock(this.getSettings(), true, repoFile.getName() + ".lock");){
            defensiveCopy = Files.createTempFile("dc-basesuppressions", ".xml", new FileAttribute[0]);
            LOGGER.debug("copying hosted suppressions file {} to {}", (Object)repoFile.toPath(), (Object)defensiveCopy);
            Files.copy(repoFile.toPath(), defensiveCopy, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException | WriteLockException ex) {
            throw new InitializationException("Failed to copy the hosted suppressions file", ex);
        }
        try (InputStream in = Files.newInputStream(defensiveCopy, new OpenOption[0]);){
            List<SuppressionRule> ruleList = parser.parseSuppressionRules(in);
            if (!ruleList.isEmpty()) {
                if (engine.hasObject(SUPPRESSION_OBJECT_KEY)) {
                    List rules = (List)engine.getObject(SUPPRESSION_OBJECT_KEY);
                    rules.addAll(ruleList);
                } else {
                    engine.putObject(SUPPRESSION_OBJECT_KEY, ruleList);
                }
            }
        }
        catch (IOException | SAXException ex) {
            LOGGER.warn("Unable to parse the hosted suppressions data file, results may contain false positives already resolved by the DependencyCheck project", (Throwable)ex);
        }
        try {
            Files.delete(defensiveCopy);
        }
        catch (IOException ex) {
            LOGGER.warn("Could not delete defensive copy of hosted suppressions file {}", (Object)defensiveCopy, (Object)ex);
        }
    }

    private static boolean forceUpdateHostedSuppressions(Engine engine, File repoFile) {
        HostedSuppressionsDataSource ds = new HostedSuppressionsDataSource();
        boolean repoEmpty = true;
        try {
            ds.update(engine);
            repoEmpty = !repoFile.isFile() || repoFile.length() <= 1L;
        }
        catch (UpdateException ex) {
            LOGGER.warn("Failed to update the Hosted Suppression file", (Throwable)ex);
        }
        return repoEmpty;
    }

    /*
     * Exception decompiling
     */
    private List<SuppressionRule> loadSuppressionFile(SuppressionParser parser, String suppressionFilePath) throws SuppressionParseException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [22[CATCHBLOCK]], but top level block is 9[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void throwSuppressionParseException(String message, Exception exception, String suppressionFilePath) throws SuppressionParseException {
        LOGGER.warn(String.format(message + " '%s'", suppressionFilePath));
        LOGGER.debug("", (Throwable)exception);
        throw new SuppressionParseException(message, exception);
    }

    public static int getRuleCount(Engine engine) {
        if (engine.hasObject(SUPPRESSION_OBJECT_KEY)) {
            List rules = (List)engine.getObject(SUPPRESSION_OBJECT_KEY);
            return rules.size();
        }
        return 0;
    }
}

