/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.analyzer;

import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Files;
import java.util.List;
import javax.annotation.concurrent.ThreadSafe;
import org.owasp.dependencycheck.Engine;
import org.owasp.dependencycheck.analyzer.AbstractFileTypeAnalyzer;
import org.owasp.dependencycheck.analyzer.AnalysisPhase;
import org.owasp.dependencycheck.analyzer.exception.AnalysisException;
import org.owasp.dependencycheck.data.artifactory.ArtifactorySearch;
import org.owasp.dependencycheck.data.nexus.MavenArtifact;
import org.owasp.dependencycheck.dependency.Confidence;
import org.owasp.dependencycheck.dependency.Dependency;
import org.owasp.dependencycheck.dependency.Evidence;
import org.owasp.dependencycheck.dependency.EvidenceType;
import org.owasp.dependencycheck.exception.InitializationException;
import org.owasp.dependencycheck.utils.DownloadFailedException;
import org.owasp.dependencycheck.utils.Downloader;
import org.owasp.dependencycheck.utils.FileFilterBuilder;
import org.owasp.dependencycheck.utils.FileUtils;
import org.owasp.dependencycheck.utils.InvalidSettingException;
import org.owasp.dependencycheck.utils.ResourceNotFoundException;
import org.owasp.dependencycheck.utils.Settings;
import org.owasp.dependencycheck.utils.TooManyRequestsException;
import org.owasp.dependencycheck.xml.pom.PomUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class ArtifactoryAnalyzer
extends AbstractFileTypeAnalyzer {
    private static final Logger LOGGER = LoggerFactory.getLogger(ArtifactoryAnalyzer.class);
    private static final String ANALYZER_NAME = "Artifactory Analyzer";
    private static final AnalysisPhase ANALYSIS_PHASE = AnalysisPhase.INFORMATION_COLLECTION;
    private static final String SUPPORTED_EXTENSIONS = "jar";
    private static final FileFilter FILTER = FileFilterBuilder.newInstance().addExtensions("jar").build();
    private ArtifactorySearch searcher;

    @Override
    public synchronized void initialize(Settings settings) {
        super.initialize(settings);
        this.setEnabled(this.checkEnabled());
    }

    @Override
    public boolean supportsParallelProcessing() {
        return this.getSettings().getBoolean("analyzer.artifactory.parallel.analysis", true);
    }

    private boolean checkEnabled() {
        try {
            return this.getSettings().getBoolean("analyzer.artifactory.enabled");
        }
        catch (InvalidSettingException ise) {
            LOGGER.warn("Invalid setting. Disabling the Artifactory analyzer");
            return false;
        }
    }

    @Override
    public void prepareFileTypeAnalyzer(Engine engine) throws InitializationException {
        LOGGER.debug("Initializing Artifactory analyzer");
        boolean enabled = this.isEnabled();
        LOGGER.debug("Artifactory analyzer enabled: {}", (Object)enabled);
        if (enabled) {
            this.searcher = new ArtifactorySearch(this.getSettings());
            boolean preflightRequest = this.searcher.preflightRequest();
            if (!preflightRequest) {
                this.setEnabled(false);
                throw new InitializationException("There was an issue connecting to Artifactory . Disabling analyzer.");
            }
        }
    }

    @Override
    public String getName() {
        return ANALYZER_NAME;
    }

    @Override
    protected String getAnalyzerEnabledSettingKey() {
        return "analyzer.artifactory.enabled";
    }

    @Override
    public AnalysisPhase getAnalysisPhase() {
        return ANALYSIS_PHASE;
    }

    @Override
    protected FileFilter getFileFilter() {
        return FILTER;
    }

    @Override
    public void analyzeDependency(Dependency dependency, Engine engine) throws AnalysisException {
        for (Evidence e : dependency.getEvidence(EvidenceType.VENDOR)) {
            if (!"pom".equals(e.getSource())) continue;
            return;
        }
        try {
            List<MavenArtifact> mas = this.searcher.search(dependency);
            Confidence confidence = mas.size() > 1 ? Confidence.HIGH : Confidence.HIGHEST;
            for (MavenArtifact ma : mas) {
                LOGGER.debug("Artifactory analyzer found artifact ({}) for dependency ({})", (Object)ma, (Object)dependency.getFileName());
                dependency.addAsEvidence("artifactory", ma, confidence);
                if (ma.getPomUrl() == null) continue;
                this.processPom(dependency, ma);
            }
        }
        catch (IllegalArgumentException iae) {
            LOGGER.info("invalid sha1-hash on {}", (Object)dependency.getFileName());
        }
        catch (FileNotFoundException fnfe) {
            LOGGER.debug("Artifact not found in repository: '{}", (Object)dependency.getFileName());
        }
        catch (IOException ioe) {
            String message = "Could not connect to Artifactory search. Analysis failed.";
            LOGGER.error("Could not connect to Artifactory search. Analysis failed.", (Throwable)ioe);
            throw new AnalysisException("Could not connect to Artifactory search. Analysis failed.", ioe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processPom(Dependency dependency, MavenArtifact ma) throws IOException, AnalysisException {
        File pomFile = null;
        try {
            File baseDir = this.getSettings().getTempDirectory();
            pomFile = File.createTempFile("pom", ".xml", baseDir);
            Files.delete(pomFile.toPath());
            LOGGER.debug("Downloading {}", (Object)ma.getPomUrl());
            Downloader downloader = new Downloader(this.getSettings());
            downloader.fetchFile(new URL(ma.getPomUrl()), pomFile, "analyzer.artifactory.api.username", "analyzer.artifactory.api.token");
            PomUtils.analyzePOM(dependency, pomFile);
        }
        catch (DownloadFailedException ex) {
            LOGGER.warn("Unable to download pom.xml for {} from Artifactory; this could result in undetected CPE/CVEs.", (Object)dependency.getFileName());
        }
        catch (TooManyRequestsException ex) {
            this.setEnabled(false);
            throw new AnalysisException("Received a 429 - too many requests from Artifactory; the artifactory analyzer is being disabled.", ex);
        }
        catch (ResourceNotFoundException ex) {
            LOGGER.warn("pom.xml not found for {} from Artifactory; this could result in undetected CPE/CVEs.", (Object)dependency.getFileName());
        }
        finally {
            if (pomFile != null && pomFile.exists() && !FileUtils.delete((File)pomFile)) {
                LOGGER.debug("Failed to delete temporary pom file {}", (Object)pomFile);
                pomFile.deleteOnExit();
            }
        }
    }
}

