/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.data.update.nvd.api;

import java.io.File;
import java.net.URL;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.commons.lang3.StringUtils;
import org.owasp.dependencycheck.data.nvdcve.CveDB;
import org.owasp.dependencycheck.data.update.nvd.api.NvdApiProcessor;
import org.owasp.dependencycheck.utils.Downloader;
import org.owasp.dependencycheck.utils.Settings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class DownloadTask
implements Callable<Future<NvdApiProcessor>> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DownloadTask.class);
    private final CveDB cveDB;
    private final ExecutorService processorService;
    private final String url;
    private final Settings settings;

    public DownloadTask(String url, ExecutorService processor, CveDB cveDB, Settings settings) {
        this.url = url;
        this.processorService = processor;
        this.cveDB = cveDB;
        this.settings = settings;
    }

    @Override
    public Future<NvdApiProcessor> call() throws Exception {
        try {
            Future<NvdApiProcessor> val;
            URL u = new URL(this.url);
            LOGGER.info("Download Started for NVD Cache - {}", (Object)this.url);
            long startDownload = System.currentTimeMillis();
            Downloader d = new Downloader(this.settings);
            File outputFile = this.settings.getTempFile("nvd-datafeed-", "json.gz");
            d.fetchFile(u, outputFile, true, "nvd.api.datafeed.user", "nvd.api.datafeed.password");
            if (this.processorService == null) {
                Future<NvdApiProcessor> future = null;
                return future;
            }
            NvdApiProcessor task = new NvdApiProcessor(this.cveDB, outputFile, startDownload);
            Future<NvdApiProcessor> future = val = this.processorService.submit(task);
            return future;
        }
        catch (Throwable ex) {
            LOGGER.error("Error downloading NVD CVE - {} Reason: {}", (Object)this.url, (Object)ex.getMessage());
            throw ex;
        }
        finally {
            this.settings.cleanup(false);
        }
    }

    public boolean isModified() {
        return StringUtils.containsIgnoreCase((CharSequence)this.url, (CharSequence)"modified");
    }
}

