/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.analyzer;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ServiceLoader;
import org.owasp.dependencycheck.analyzer.Analyzer;
import org.owasp.dependencycheck.analyzer.Experimental;
import org.owasp.dependencycheck.utils.InvalidSettingException;
import org.owasp.dependencycheck.utils.Settings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnalyzerService {
    private static final Logger LOGGER = LoggerFactory.getLogger(AnalyzerService.class);
    private final ServiceLoader<Analyzer> service;

    public AnalyzerService(ClassLoader classLoader) {
        this.service = ServiceLoader.load(Analyzer.class, classLoader);
    }

    public List<Analyzer> getAnalyzers() {
        ArrayList<Analyzer> analyzers = new ArrayList<Analyzer>();
        Iterator<Analyzer> iterator = this.service.iterator();
        boolean experimentalEnabled = false;
        try {
            experimentalEnabled = Settings.getBoolean((String)"analyzer.experimental.enabled", (boolean)false);
        }
        catch (InvalidSettingException ex) {
            LOGGER.error("invalide experimental setting", (Throwable)ex);
        }
        while (iterator.hasNext()) {
            Analyzer a = iterator.next();
            if (!experimentalEnabled && a.getClass().isAnnotationPresent(Experimental.class)) continue;
            LOGGER.debug("Loaded Analyzer {}", (Object)a.getName());
            analyzers.add(a);
        }
        return analyzers;
    }
}

