/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.data.nuget;

import java.io.InputStream;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.owasp.dependencycheck.data.nuget.NugetPackage;
import org.owasp.dependencycheck.data.nuget.NuspecParseException;
import org.owasp.dependencycheck.data.nuget.NuspecParser;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class XPathNuspecParser
implements NuspecParser {
    private String getOrNull(Node n) {
        if (n != null) {
            return n.getTextContent();
        }
        return null;
    }

    @Override
    public NugetPackage parse(InputStream stream) throws NuspecParseException {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            Document d = factory.newDocumentBuilder().parse(stream);
            XPath xpath = XPathFactory.newInstance().newXPath();
            NugetPackage nuspec = new NugetPackage();
            if (xpath.evaluate("/package/metadata/id", d, XPathConstants.NODE) == null || xpath.evaluate("/package/metadata/version", d, XPathConstants.NODE) == null || xpath.evaluate("/package/metadata/authors", d, XPathConstants.NODE) == null || xpath.evaluate("/package/metadata/description", d, XPathConstants.NODE) == null) {
                throw new NuspecParseException("Invalid Nuspec format");
            }
            nuspec.setId(xpath.evaluate("/package/metadata/id", d));
            nuspec.setVersion(xpath.evaluate("/package/metadata/version", d));
            nuspec.setAuthors(xpath.evaluate("/package/metadata/authors", d));
            nuspec.setOwners(this.getOrNull((Node)xpath.evaluate("/package/metadata/owners", d, XPathConstants.NODE)));
            nuspec.setLicenseUrl(this.getOrNull((Node)xpath.evaluate("/package/metadata/licenseUrl", d, XPathConstants.NODE)));
            nuspec.setTitle(this.getOrNull((Node)xpath.evaluate("/package/metadata/title", d, XPathConstants.NODE)));
            return nuspec;
        }
        catch (Throwable e) {
            throw new NuspecParseException("Unable to parse nuspec", e);
        }
    }
}

