/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.analyzer;

import java.io.File;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.filefilter.NameFileFilter;
import org.owasp.dependencycheck.Engine;
import org.owasp.dependencycheck.analyzer.AbstractAnalyzer;
import org.owasp.dependencycheck.analyzer.AnalysisPhase;
import org.owasp.dependencycheck.analyzer.exception.AnalysisException;
import org.owasp.dependencycheck.dependency.Confidence;
import org.owasp.dependencycheck.dependency.Dependency;
import org.owasp.dependencycheck.utils.DependencyVersion;
import org.owasp.dependencycheck.utils.DependencyVersionUtil;

public class FileNameAnalyzer
extends AbstractAnalyzer {
    private static final String ANALYZER_NAME = "File Name Analyzer";
    private static final AnalysisPhase ANALYSIS_PHASE = AnalysisPhase.INFORMATION_COLLECTION;
    private static final NameFileFilter IGNORED_FILES = new NameFileFilter(new String[]{"__init__.py", "__init__.pyc", "__init__.pyo"});

    @Override
    public String getName() {
        return ANALYZER_NAME;
    }

    @Override
    public AnalysisPhase getAnalysisPhase() {
        return ANALYSIS_PHASE;
    }

    @Override
    public void analyze(Dependency dependency, Engine engine) throws AnalysisException {
        File f = dependency.getActualFile();
        String fileName = FilenameUtils.removeExtension((String)f.getName());
        DependencyVersion version = DependencyVersionUtil.parseVersion(fileName);
        String packageName = DependencyVersionUtil.parsePreVersion(fileName);
        if (version != null) {
            if (version.getVersionParts() == null || version.getVersionParts().size() < 2) {
                dependency.getVersionEvidence().addEvidence("file", "version", version.toString(), Confidence.MEDIUM);
            } else {
                dependency.getVersionEvidence().addEvidence("file", "version", version.toString(), Confidence.HIGHEST);
            }
            dependency.getVersionEvidence().addEvidence("file", "name", packageName, Confidence.MEDIUM);
        }
        if (!IGNORED_FILES.accept(f)) {
            dependency.getProductEvidence().addEvidence("file", "name", packageName, Confidence.HIGH);
            dependency.getVendorEvidence().addEvidence("file", "name", packageName, Confidence.HIGH);
        }
    }
}

