/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.exception;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;

public class ExceptionCollection
extends Exception {
    private static final long serialVersionUID = 1L;
    private List<Throwable> exceptions;
    private boolean fatal = false;

    public ExceptionCollection(List<Throwable> exceptions) {
        this.exceptions = exceptions;
    }

    public ExceptionCollection(String msg, List<Throwable> exceptions) {
        super(msg);
        this.exceptions = exceptions;
    }

    public ExceptionCollection(List<Throwable> exceptions, boolean fatal) {
        this.exceptions = exceptions;
        this.fatal = fatal;
    }

    public ExceptionCollection(String msg, List<Throwable> exceptions, boolean fatal) {
        super(msg);
        this.exceptions = exceptions;
        this.fatal = fatal;
    }

    public ExceptionCollection(Throwable exceptions, boolean fatal) {
        this.exceptions = new ArrayList<Throwable>();
        this.exceptions.add(exceptions);
        this.fatal = fatal;
    }

    public ExceptionCollection(String msg, Throwable exception) {
        super(msg);
        this.exceptions = new ArrayList<Throwable>();
        this.exceptions.add(exception);
        this.fatal = false;
    }

    public ExceptionCollection() {
        this.exceptions = new ArrayList<Throwable>();
    }

    public List<Throwable> getExceptions() {
        return this.exceptions;
    }

    public void addException(Throwable ex) {
        this.exceptions.add(ex);
    }

    public void addException(Throwable ex, boolean fatal) {
        this.addException(ex);
        this.fatal = fatal;
    }

    public boolean isFatal() {
        return this.fatal;
    }

    public void setFatal(boolean fatal) {
        this.fatal = fatal;
    }

    @Override
    public void printStackTrace(PrintWriter s) {
        s.println("Multiple Exceptions Occured");
        super.printStackTrace(s);
        for (Throwable t : this.exceptions) {
            s.println("Next Exception:");
            t.printStackTrace(s);
        }
    }

    @Override
    public void printStackTrace(PrintStream s) {
        s.println("Multiple Exceptions Occurred");
        super.printStackTrace(s);
        for (Throwable t : this.exceptions) {
            s.println("Next Exception:");
            t.printStackTrace(s);
        }
    }

    @Override
    public String getMessage() {
        StringBuilder sb = new StringBuilder();
        String msg = super.getMessage();
        if (msg == null || msg.isEmpty()) {
            sb.append("One or more exceptions occured during analysis:");
        } else {
            sb.append(msg);
        }
        for (Throwable t : this.exceptions) {
            sb.append("\n\t").append(t.getMessage());
        }
        return sb.toString();
    }
}

