/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.dependency;

import java.io.Serializable;
import java.util.Iterator;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.owasp.dependencycheck.dependency.Reference;
import org.owasp.dependencycheck.dependency.VulnerableSoftware;

public class Vulnerability
implements Serializable,
Comparable<Vulnerability> {
    private static final long serialVersionUID = 307319490326651052L;
    private String name;
    private String description;
    private SortedSet<Reference> references = new TreeSet<Reference>();
    private SortedSet<VulnerableSoftware> vulnerableSoftware = new TreeSet<VulnerableSoftware>();
    private String cwe;
    private float cvssScore;
    private String cvssAccessVector;
    private String cvssAccessComplexity;
    private String cvssAuthentication;
    private String cvssConfidentialityImpact;
    private String cvssIntegrityImpact;
    private String cvssAvailabilityImpact;
    private String matchedCPE;
    private String matchedAllPreviousCPE;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Set<Reference> getReferences() {
        return this.references;
    }

    public void setReferences(SortedSet<Reference> references) {
        this.references = references;
    }

    public void addReference(Reference ref) {
        this.references.add(ref);
    }

    public void addReference(String referenceSource, String referenceName, String referenceUrl) {
        Reference ref = new Reference();
        ref.setSource(referenceSource);
        ref.setName(referenceName);
        ref.setUrl(referenceUrl);
        this.references.add(ref);
    }

    public Set<VulnerableSoftware> getVulnerableSoftware() {
        return this.vulnerableSoftware;
    }

    public void setVulnerableSoftware(SortedSet<VulnerableSoftware> vulnerableSoftware) {
        this.vulnerableSoftware = vulnerableSoftware;
    }

    public boolean addVulnerableSoftware(String cpe) {
        return this.addVulnerableSoftware(cpe, null);
    }

    public boolean addVulnerableSoftware(String cpe, String previousVersion) {
        VulnerableSoftware vs = new VulnerableSoftware();
        vs.setCpe(cpe);
        if (previousVersion != null) {
            vs.setPreviousVersion(previousVersion);
        }
        return this.updateVulnerableSoftware(vs);
    }

    public boolean updateVulnerableSoftware(VulnerableSoftware vulnSoftware) {
        if (this.vulnerableSoftware.contains(vulnSoftware)) {
            this.vulnerableSoftware.remove(vulnSoftware);
        }
        return this.vulnerableSoftware.add(vulnSoftware);
    }

    public String getCwe() {
        return this.cwe;
    }

    public void setCwe(String cwe) {
        this.cwe = cwe;
    }

    public float getCvssScore() {
        return this.cvssScore;
    }

    public void setCvssScore(float cvssScore) {
        this.cvssScore = cvssScore;
    }

    public String getCvssAccessVector() {
        return this.cvssAccessVector;
    }

    public void setCvssAccessVector(String cvssAccessVector) {
        this.cvssAccessVector = cvssAccessVector;
    }

    public String getCvssAccessComplexity() {
        return this.cvssAccessComplexity;
    }

    public void setCvssAccessComplexity(String cvssAccessComplexity) {
        this.cvssAccessComplexity = cvssAccessComplexity;
    }

    public String getCvssAuthentication() {
        return this.cvssAuthentication;
    }

    public void setCvssAuthentication(String cvssAuthentication) {
        this.cvssAuthentication = cvssAuthentication;
    }

    public String getCvssConfidentialityImpact() {
        return this.cvssConfidentialityImpact;
    }

    public void setCvssConfidentialityImpact(String cvssConfidentialityImpact) {
        this.cvssConfidentialityImpact = cvssConfidentialityImpact;
    }

    public String getCvssIntegrityImpact() {
        return this.cvssIntegrityImpact;
    }

    public void setCvssIntegrityImpact(String cvssIntegrityImpact) {
        this.cvssIntegrityImpact = cvssIntegrityImpact;
    }

    public String getCvssAvailabilityImpact() {
        return this.cvssAvailabilityImpact;
    }

    public void setCvssAvailabilityImpact(String cvssAvailabilityImpact) {
        this.cvssAvailabilityImpact = cvssAvailabilityImpact;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Vulnerability other = (Vulnerability)obj;
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    public int hashCode() {
        int hash = 5;
        hash = 41 * hash + (this.name != null ? this.name.hashCode() : 0);
        return hash;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Vulnerability ");
        sb.append(this.name);
        sb.append("\nReferences:\n");
        Iterator i = this.references.iterator();
        while (i.hasNext()) {
            sb.append("=> ");
            sb.append(i.next());
            sb.append("\n");
        }
        sb.append("\nSoftware:\n");
        i = this.vulnerableSoftware.iterator();
        while (i.hasNext()) {
            sb.append("=> ");
            sb.append(i.next());
            sb.append("\n");
        }
        return sb.toString();
    }

    @Override
    public int compareTo(Vulnerability v) {
        return v.getName().compareTo(this.getName());
    }

    public void setMatchedCPE(String cpeId, String previous) {
        this.matchedCPE = cpeId;
        this.matchedAllPreviousCPE = previous;
    }

    public String getMatchedCPE() {
        return this.matchedCPE;
    }

    public String getMatchedAllPreviousCPE() {
        return this.matchedAllPreviousCPE;
    }

    public boolean hasMatchedAllPreviousCPE() {
        return this.matchedAllPreviousCPE != null;
    }
}

