/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.analyzer;

import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.owasp.dependencycheck.Engine;
import org.owasp.dependencycheck.analyzer.AbstractFileTypeAnalyzer;
import org.owasp.dependencycheck.analyzer.AnalysisPhase;
import org.owasp.dependencycheck.analyzer.Experimental;
import org.owasp.dependencycheck.analyzer.exception.AnalysisException;
import org.owasp.dependencycheck.dependency.Confidence;
import org.owasp.dependencycheck.dependency.Dependency;
import org.owasp.dependencycheck.dependency.EvidenceCollection;
import org.owasp.dependencycheck.utils.FileFilterBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Experimental
public class RubyGemspecAnalyzer
extends AbstractFileTypeAnalyzer {
    private static final Logger LOGGER = LoggerFactory.getLogger(RubyGemspecAnalyzer.class);
    private static final String ANALYZER_NAME = "Ruby Gemspec Analyzer";
    private static final AnalysisPhase ANALYSIS_PHASE = AnalysisPhase.INFORMATION_COLLECTION;
    private static final String GEMSPEC = "gemspec";
    private static final FileFilter FILTER = FileFilterBuilder.newInstance().addExtensions("gemspec").build();
    private static final String VERSION_FILE_NAME = "VERSION";
    private static final Pattern GEMSPEC_BLOCK_INIT = Pattern.compile("Gem::Specification\\.new\\s+?do\\s+?\\|(.+?)\\|");

    @Override
    protected FileFilter getFileFilter() {
        return FILTER;
    }

    @Override
    protected void initializeFileTypeAnalyzer() throws Exception {
    }

    @Override
    public String getName() {
        return ANALYZER_NAME;
    }

    @Override
    public AnalysisPhase getAnalysisPhase() {
        return ANALYSIS_PHASE;
    }

    @Override
    protected String getAnalyzerEnabledSettingKey() {
        return "analyzer.ruby.gemspec.enabled";
    }

    @Override
    protected void analyzeFileType(Dependency dependency, Engine engine) throws AnalysisException {
        String contents;
        try {
            contents = FileUtils.readFileToString((File)dependency.getActualFile(), (Charset)Charset.defaultCharset());
        }
        catch (IOException e) {
            throw new AnalysisException("Problem occurred while reading dependency file.", e);
        }
        Matcher matcher = GEMSPEC_BLOCK_INIT.matcher(contents);
        if (matcher.find()) {
            contents = contents.substring(matcher.end());
            String blockVariable = matcher.group(1);
            EvidenceCollection vendor = dependency.getVendorEvidence();
            EvidenceCollection product = dependency.getProductEvidence();
            String name = this.addStringEvidence(product, contents, blockVariable, "name", "name", Confidence.HIGHEST);
            if (!name.isEmpty()) {
                vendor.addEvidence(GEMSPEC, "name_project", name + "_project", Confidence.LOW);
            }
            this.addStringEvidence(product, contents, blockVariable, "summary", "summary", Confidence.LOW);
            this.addStringEvidence(vendor, contents, blockVariable, "author", "authors?", Confidence.HIGHEST);
            this.addStringEvidence(vendor, contents, blockVariable, "email", "emails?", Confidence.MEDIUM);
            this.addStringEvidence(vendor, contents, blockVariable, "homepage", "homepage", Confidence.HIGHEST);
            this.addStringEvidence(vendor, contents, blockVariable, "license", "licen[cs]es?", Confidence.HIGHEST);
            String value = this.addStringEvidence(dependency.getVersionEvidence(), contents, blockVariable, "version", "version", Confidence.HIGHEST);
            if (value.length() < 1) {
                this.addEvidenceFromVersionFile(dependency.getActualFile(), dependency.getVersionEvidence());
            }
        }
        this.setPackagePath(dependency);
    }

    private String addStringEvidence(EvidenceCollection evidences, String contents, String blockVariable, String field, String fieldPattern, Confidence confidence) {
        String value = "";
        Matcher arrayMatcher = Pattern.compile(String.format("\\s*?%s\\.%s\\s*?=\\s*?\\[(.*?)\\]", blockVariable, fieldPattern), 2).matcher(contents);
        if (arrayMatcher.find()) {
            String arrayValue = arrayMatcher.group(1);
            value = arrayValue.replaceAll("['\"]", "").trim();
        } else {
            Matcher matcher = Pattern.compile(String.format("\\s*?%s\\.%s\\s*?=\\s*?(['\"])(.*?)\\1", blockVariable, fieldPattern), 2).matcher(contents);
            if (matcher.find()) {
                value = matcher.group(2);
            }
        }
        if (value.length() > 0) {
            evidences.addEvidence(GEMSPEC, field, value, confidence);
        }
        return value;
    }

    private void addEvidenceFromVersionFile(File dependencyFile, EvidenceCollection versionEvidences) {
        File parentDir = dependencyFile.getParentFile();
        if (parentDir != null) {
            File[] matchingFiles;
            for (File f : matchingFiles = parentDir.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.contains(RubyGemspecAnalyzer.VERSION_FILE_NAME);
                }
            })) {
                try {
                    List lines = FileUtils.readLines((File)f, (Charset)Charset.defaultCharset());
                    if (lines.size() != 1) continue;
                    String value = ((String)lines.get(0)).trim();
                    versionEvidences.addEvidence(GEMSPEC, "version", value, Confidence.HIGH);
                }
                catch (IOException e) {
                    LOGGER.debug("Error reading gemspec", (Throwable)e);
                }
            }
        }
    }

    private void setPackagePath(Dependency dep) {
        File file = new File(dep.getFilePath());
        String parent = file.getParent();
        if (parent != null) {
            dep.setPackagePath(parent);
        }
    }
}

