/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.suppression;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.owasp.dependencycheck.suppression.SuppressionErrorHandler;
import org.owasp.dependencycheck.suppression.SuppressionHandler;
import org.owasp.dependencycheck.suppression.SuppressionParseException;
import org.owasp.dependencycheck.suppression.SuppressionRule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class SuppressionParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(SuppressionParser.class);
    public static final String JAXP_SCHEMA_LANGUAGE = "http://java.sun.com/xml/jaxp/properties/schemaLanguage";
    public static final String W3C_XML_SCHEMA = "http://www.w3.org/2001/XMLSchema";
    public static final String JAXP_SCHEMA_SOURCE = "http://java.sun.com/xml/jaxp/properties/schemaSource";

    public List<SuppressionRule> parseSuppressionRules(File file) throws SuppressionParseException {
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(file);
            List<SuppressionRule> list = this.parseSuppressionRules(fis);
            return list;
        }
        catch (IOException ex) {
            LOGGER.debug("", (Throwable)ex);
            throw new SuppressionParseException(ex);
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException ex) {
                    LOGGER.debug("Unable to close stream", (Throwable)ex);
                }
            }
        }
    }

    public List<SuppressionRule> parseSuppressionRules(InputStream inputStream) throws SuppressionParseException {
        try {
            InputStream schemaStream = this.getClass().getClassLoader().getResourceAsStream("schema/suppression.xsd");
            SuppressionHandler handler = new SuppressionHandler();
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setNamespaceAware(true);
            factory.setValidating(true);
            SAXParser saxParser = factory.newSAXParser();
            saxParser.setProperty(JAXP_SCHEMA_LANGUAGE, W3C_XML_SCHEMA);
            saxParser.setProperty(JAXP_SCHEMA_SOURCE, new InputSource(schemaStream));
            XMLReader xmlReader = saxParser.getXMLReader();
            xmlReader.setErrorHandler(new SuppressionErrorHandler());
            xmlReader.setContentHandler(handler);
            InputStreamReader reader = new InputStreamReader(inputStream, "UTF-8");
            InputSource in = new InputSource(reader);
            xmlReader.parse(in);
            return handler.getSuppressionRules();
        }
        catch (ParserConfigurationException ex) {
            LOGGER.debug("", (Throwable)ex);
            throw new SuppressionParseException(ex);
        }
        catch (SAXException ex) {
            LOGGER.debug("", (Throwable)ex);
            throw new SuppressionParseException(ex);
        }
        catch (FileNotFoundException ex) {
            LOGGER.debug("", (Throwable)ex);
            throw new SuppressionParseException(ex);
        }
        catch (IOException ex) {
            LOGGER.debug("", (Throwable)ex);
            throw new SuppressionParseException(ex);
        }
    }
}

