/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.data.nvdcve;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.commons.io.IOUtils;
import org.owasp.dependencycheck.data.nvdcve.DatabaseException;
import org.owasp.dependencycheck.data.nvdcve.DriverLoadException;
import org.owasp.dependencycheck.data.nvdcve.DriverLoader;
import org.owasp.dependencycheck.utils.DBUtils;
import org.owasp.dependencycheck.utils.DependencyVersion;
import org.owasp.dependencycheck.utils.DependencyVersionUtil;
import org.owasp.dependencycheck.utils.Settings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ConnectionFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConnectionFactory.class);
    public static final String DB_SCHEMA_VERSION = Settings.getString((String)"data.version");
    public static final String DB_STRUCTURE_RESOURCE = "data/initialize.sql";
    public static final String DB_STRUCTURE_UPDATE_RESOURCE = "data/upgrade_%s.sql";
    public static final String UPGRADE_HELP_URL = "http://jeremylong.github.io/DependencyCheck/data/upgrade.html";
    private static Driver driver = null;
    private static String connectionString = null;
    private static String userName = null;
    private static String password = null;
    private static int callDepth = 0;

    private ConnectionFactory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void initialize() throws DatabaseException {
        if (connectionString != null) {
            return;
        }
        Connection conn = null;
        try {
            String driverName = Settings.getString((String)"data.driver_name", (String)"");
            if (!driverName.isEmpty()) {
                LOGGER.debug("Loading driver: {}", (Object)driverName);
                String driverPath = Settings.getString((String)"data.driver_path", (String)"");
                try {
                    if (!driverPath.isEmpty()) {
                        LOGGER.debug("Loading driver from: {}", (Object)driverPath);
                        driver = DriverLoader.load(driverName, driverPath);
                    } else {
                        driver = DriverLoader.load(driverName);
                    }
                }
                catch (DriverLoadException ex) {
                    LOGGER.debug("Unable to load database driver", (Throwable)ex);
                    throw new DatabaseException("Unable to load database driver");
                }
            }
            userName = Settings.getString((String)"data.user", (String)"dcuser");
            password = Settings.getString((String)"data.password", (String)"DC-Pass1337!");
            try {
                connectionString = Settings.getConnectionString((String)"data.connection_string", (String)"data.file_name");
            }
            catch (IOException ex) {
                LOGGER.debug("Unable to retrieve the database connection string", (Throwable)ex);
                throw new DatabaseException("Unable to retrieve the database connection string");
            }
            boolean shouldCreateSchema = false;
            try {
                if (connectionString.startsWith("jdbc:h2:file:")) {
                    shouldCreateSchema = !ConnectionFactory.h2DataFileExists();
                    LOGGER.debug("Need to create DB Structure: {}", (Object)shouldCreateSchema);
                }
            }
            catch (IOException ioex) {
                LOGGER.debug("Unable to verify database exists", (Throwable)ioex);
                throw new DatabaseException("Unable to verify database exists");
            }
            LOGGER.debug("Loading database connection");
            LOGGER.debug("Connection String: {}", (Object)connectionString);
            LOGGER.debug("Database User: {}", (Object)userName);
            try {
                conn = DriverManager.getConnection(connectionString, userName, password);
            }
            catch (SQLException ex) {
                if (ex.getMessage().contains("java.net.UnknownHostException") && connectionString.contains("AUTO_SERVER=TRUE;")) {
                    connectionString = connectionString.replace("AUTO_SERVER=TRUE;", "");
                    try {
                        conn = DriverManager.getConnection(connectionString, userName, password);
                        Settings.setString((String)"data.connection_string", (String)connectionString);
                        LOGGER.debug("Unable to start the database in server mode; reverting to single user mode");
                    }
                    catch (SQLException sqlex) {
                        LOGGER.debug("Unable to connect to the database", (Throwable)ex);
                        throw new DatabaseException("Unable to connect to the database");
                    }
                }
                LOGGER.debug("Unable to connect to the database", (Throwable)ex);
                throw new DatabaseException("Unable to connect to the database");
            }
            if (shouldCreateSchema) {
                try {
                    ConnectionFactory.createTables(conn);
                }
                catch (DatabaseException dex) {
                    LOGGER.debug("", (Throwable)dex);
                    throw new DatabaseException("Unable to create the database structure");
                }
            }
            try {
                ConnectionFactory.ensureSchemaVersion(conn);
            }
            catch (DatabaseException dex) {
                LOGGER.debug("", (Throwable)dex);
                throw new DatabaseException("Database schema does not match this version of dependency-check", dex);
            }
        }
        finally {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException ex) {
                    LOGGER.debug("An error occurred closing the connection", (Throwable)ex);
                }
            }
        }
    }

    public static synchronized void cleanup() {
        if (driver != null) {
            try {
                DriverManager.deregisterDriver(driver);
            }
            catch (SQLException ex) {
                LOGGER.debug("An error occurred unloading the database driver", (Throwable)ex);
            }
            catch (Throwable unexpected) {
                LOGGER.debug("An unexpected throwable occurred unloading the database driver", unexpected);
            }
            driver = null;
        }
        connectionString = null;
        userName = null;
        password = null;
    }

    public static Connection getConnection() throws DatabaseException {
        ConnectionFactory.initialize();
        Connection conn = null;
        try {
            conn = DriverManager.getConnection(connectionString, userName, password);
        }
        catch (SQLException ex) {
            LOGGER.debug("", (Throwable)ex);
            throw new DatabaseException("Unable to connect to the database");
        }
        return conn;
    }

    private static boolean h2DataFileExists() throws IOException {
        File dir = Settings.getDataDirectory();
        String fileName = Settings.getString((String)"data.file_name");
        File file = new File(dir, fileName);
        return file.exists();
    }

    private static void createTables(Connection conn) throws DatabaseException {
        LOGGER.debug("Creating database structure");
        InputStream is = null;
        try {
            is = ConnectionFactory.class.getClassLoader().getResourceAsStream(DB_STRUCTURE_RESOURCE);
            String dbStructure = IOUtils.toString((InputStream)is, (String)"UTF-8");
            Statement statement = null;
            try {
                statement = conn.createStatement();
                statement.execute(dbStructure);
            }
            catch (SQLException ex) {
                LOGGER.debug("", (Throwable)ex);
                throw new DatabaseException("Unable to create database statement", ex);
            }
            finally {
                DBUtils.closeStatement(statement);
            }
        }
        catch (IOException ex) {
            try {
                throw new DatabaseException("Unable to create database schema", ex);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(is);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)is);
    }

    private static void updateSchema(Connection conn, String schema) throws DatabaseException {
        InputStream is;
        block14: {
            String databaseProductName;
            try {
                databaseProductName = conn.getMetaData().getDatabaseProductName();
            }
            catch (SQLException ex) {
                throw new DatabaseException("Unable to get the database product name");
            }
            if ("h2".equalsIgnoreCase(databaseProductName)) {
                LOGGER.debug("Updating database structure");
                is = null;
                String updateFile = null;
                try {
                    updateFile = String.format(DB_STRUCTURE_UPDATE_RESOURCE, schema);
                    is = ConnectionFactory.class.getClassLoader().getResourceAsStream(updateFile);
                    if (is == null) {
                        throw new DatabaseException(String.format("Unable to load update file '%s'", updateFile));
                    }
                    String dbStructureUpdate = IOUtils.toString((InputStream)is, (String)"UTF-8");
                    Statement statement = null;
                    try {
                        statement = conn.createStatement();
                        boolean success = statement.execute(dbStructureUpdate);
                        if (!success && statement.getUpdateCount() <= 0) {
                            throw new DatabaseException(String.format("Unable to upgrade the database schema to %s", schema));
                        }
                        break block14;
                    }
                    catch (SQLException ex) {
                        LOGGER.debug("", (Throwable)ex);
                        throw new DatabaseException("Unable to update database schema", ex);
                    }
                    finally {
                        DBUtils.closeStatement(statement);
                    }
                }
                catch (IOException ex) {
                    try {
                        String msg = String.format("Upgrade SQL file does not exist: %s", updateFile);
                        throw new DatabaseException(msg, ex);
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(is);
                        throw throwable;
                    }
                }
            }
            LOGGER.error("The database schema must be upgraded to use this version of dependency-check. Please see {} for more information.", (Object)UPGRADE_HELP_URL);
            throw new DatabaseException("Database schema is out of date");
        }
        IOUtils.closeQuietly((InputStream)is);
    }

    private static void ensureSchemaVersion(Connection conn) throws DatabaseException {
        CallableStatement cs;
        ResultSet rs;
        block7: {
            rs = null;
            cs = null;
            try {
                cs = conn.prepareCall("SELECT value FROM properties WHERE id = 'version'");
                rs = cs.executeQuery();
                if (rs.next()) {
                    DependencyVersion db;
                    DependencyVersion current = DependencyVersionUtil.parseVersion(DB_SCHEMA_VERSION);
                    if (current.compareTo(db = DependencyVersionUtil.parseVersion(rs.getString(1))) > 0) {
                        LOGGER.debug("Current Schema: {}", (Object)DB_SCHEMA_VERSION);
                        LOGGER.debug("DB Schema: {}", (Object)rs.getString(1));
                        ConnectionFactory.updateSchema(conn, rs.getString(1));
                        if (++callDepth < 10) {
                            ConnectionFactory.ensureSchemaVersion(conn);
                        }
                    }
                    break block7;
                }
                throw new DatabaseException("Database schema is missing");
            }
            catch (SQLException ex) {
                try {
                    LOGGER.debug("", (Throwable)ex);
                    throw new DatabaseException("Unable to check the database schema version");
                }
                catch (Throwable throwable) {
                    DBUtils.closeResultSet(rs);
                    DBUtils.closeStatement(cs);
                    throw throwable;
                }
            }
        }
        DBUtils.closeResultSet(rs);
        DBUtils.closeStatement(cs);
    }
}

