/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.suppression;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class SuppressionErrorHandler
implements ErrorHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(SuppressionErrorHandler.class);

    private String getPrettyParseExceptionInfo(SAXParseException ex) {
        StringBuilder sb = new StringBuilder();
        if (ex.getSystemId() != null) {
            sb.append("systemId=").append(ex.getSystemId()).append(", ");
        }
        if (ex.getPublicId() != null) {
            sb.append("publicId=").append(ex.getPublicId()).append(", ");
        }
        if (ex.getLineNumber() > 0) {
            sb.append("Line=").append(ex.getLineNumber());
        }
        if (ex.getColumnNumber() > 0) {
            sb.append(", Column=").append(ex.getColumnNumber());
        }
        sb.append(": ").append(ex.getMessage());
        return sb.toString();
    }

    @Override
    public void warning(SAXParseException ex) throws SAXException {
        LOGGER.debug("", (Throwable)ex);
    }

    @Override
    public void error(SAXParseException ex) throws SAXException {
        throw new SAXException(this.getPrettyParseExceptionInfo(ex));
    }

    @Override
    public void fatalError(SAXParseException ex) throws SAXException {
        throw new SAXException(this.getPrettyParseExceptionInfo(ex));
    }
}

