/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.data.update;

import org.owasp.dependencycheck.data.nvdcve.CveDB;
import org.owasp.dependencycheck.data.nvdcve.DatabaseException;
import org.owasp.dependencycheck.data.nvdcve.DatabaseProperties;
import org.owasp.dependencycheck.data.update.exception.UpdateException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseUpdater {
    private static final Logger LOGGER = LoggerFactory.getLogger(BaseUpdater.class);
    private DatabaseProperties properties;
    private CveDB cveDB = null;

    protected CveDB getCveDB() {
        return this.cveDB;
    }

    protected DatabaseProperties getProperties() {
        return this.properties;
    }

    protected void closeDataStores() {
        if (this.cveDB != null) {
            try {
                this.cveDB.close();
                this.cveDB = null;
                this.properties = null;
            }
            catch (Throwable ignore) {
                LOGGER.trace("Error closing the database", ignore);
            }
        }
    }

    protected final void openDataStores() throws UpdateException {
        if (this.cveDB != null) {
            return;
        }
        try {
            this.cveDB = new CveDB();
            this.cveDB.open();
            this.properties = this.cveDB.getDatabaseProperties();
        }
        catch (DatabaseException ex) {
            this.closeDataStores();
            LOGGER.debug("Database Exception opening databases", (Throwable)ex);
            throw new UpdateException("Error updating the database, please see the log file for more details.");
        }
    }
}

