/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.analyzer;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.commons.io.FileUtils;
import org.owasp.dependencycheck.Engine;
import org.owasp.dependencycheck.analyzer.AbstractFileTypeAnalyzer;
import org.owasp.dependencycheck.analyzer.AnalysisPhase;
import org.owasp.dependencycheck.analyzer.FileTypeAnalyzer;
import org.owasp.dependencycheck.analyzer.RubyGemspecAnalyzer;
import org.owasp.dependencycheck.analyzer.exception.AnalysisException;
import org.owasp.dependencycheck.dependency.Confidence;
import org.owasp.dependencycheck.dependency.Dependency;
import org.owasp.dependencycheck.dependency.Reference;
import org.owasp.dependencycheck.dependency.Vulnerability;
import org.owasp.dependencycheck.utils.FileFilterBuilder;
import org.owasp.dependencycheck.utils.Settings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RubyBundleAuditAnalyzer
extends AbstractFileTypeAnalyzer {
    private static final Logger LOGGER = LoggerFactory.getLogger(RubyBundleAuditAnalyzer.class);
    private static final String ANALYZER_NAME = "Ruby Bundle Audit Analyzer";
    private static final AnalysisPhase ANALYSIS_PHASE = AnalysisPhase.PRE_INFORMATION_COLLECTION;
    private static final FileFilter FILTER = FileFilterBuilder.newInstance().addFilenames("Gemfile.lock").build();
    public static final String NAME = "Name: ";
    public static final String VERSION = "Version: ";
    public static final String ADVISORY = "Advisory: ";
    public static final String CRITICALITY = "Criticality: ";
    private boolean needToDisableGemspecAnalyzer = true;

    @Override
    protected FileFilter getFileFilter() {
        return FILTER;
    }

    private Process launchBundleAudit(File folder) throws AnalysisException {
        if (!folder.isDirectory()) {
            throw new AnalysisException(String.format("%s should have been a directory.", folder.getAbsolutePath()));
        }
        ArrayList<String> args = new ArrayList<String>();
        String bundleAuditPath = Settings.getString((String)"analyzer.bundle.audit.path");
        args.add(null == bundleAuditPath ? "bundle-audit" : bundleAuditPath);
        args.add("check");
        args.add("--verbose");
        ProcessBuilder builder = new ProcessBuilder(args);
        builder.directory(folder);
        try {
            return builder.start();
        }
        catch (IOException ioe) {
            throw new AnalysisException("bundle-audit failure", ioe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initializeFileTypeAnalyzer() throws Exception {
        Process process = this.launchBundleAudit(Settings.getTempDirectory());
        int exitValue = process.waitFor();
        if (0 == exitValue) {
            LOGGER.warn("Unexpected exit code from bundle-audit process. Disabling {}: {}", (Object)ANALYZER_NAME, (Object)exitValue);
            this.setEnabled(false);
            throw new AnalysisException("Unexpected exit code from bundle-audit process.");
        }
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new InputStreamReader(process.getErrorStream(), "UTF-8"));
            if (!reader.ready()) {
                LOGGER.warn("Bundle-audit error stream unexpectedly not ready. Disabling Ruby Bundle Audit Analyzer");
                this.setEnabled(false);
                throw new AnalysisException("Bundle-audit error stream unexpectedly not ready.");
            }
            String line = reader.readLine();
            if (!line.contains("Errno::ENOENT")) {
                LOGGER.warn("Unexpected bundle-audit output. Disabling {}: {}", (Object)ANALYZER_NAME, (Object)line);
                this.setEnabled(false);
                throw new AnalysisException("Unexpected bundle-audit output.");
            }
        }
        finally {
            if (null != reader) {
                reader.close();
            }
        }
        if (this.isEnabled()) {
            LOGGER.info("Ruby Bundle Audit Analyzer is enabled. It is necessary to manually run \"bundle-audit update\" occasionally to keep its database up to date.");
        }
    }

    @Override
    public String getName() {
        return ANALYZER_NAME;
    }

    @Override
    public AnalysisPhase getAnalysisPhase() {
        return ANALYSIS_PHASE;
    }

    @Override
    protected String getAnalyzerEnabledSettingKey() {
        return "analyzer.bundle.audit.enabled";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void analyzeFileType(Dependency dependency, Engine engine) throws AnalysisException {
        if (this.needToDisableGemspecAnalyzer) {
            boolean failed = true;
            String className = RubyGemspecAnalyzer.class.getName();
            for (FileTypeAnalyzer analyzer : engine.getFileTypeAnalyzers()) {
                if (!(analyzer instanceof RubyGemspecAnalyzer)) continue;
                ((RubyGemspecAnalyzer)analyzer).setEnabled(false);
                LOGGER.info("Disabled " + className + " to avoid noisy duplicate results.");
                failed = false;
            }
            if (failed) {
                LOGGER.warn("Did not find" + className + '.');
            }
            this.needToDisableGemspecAnalyzer = false;
        }
        File parentFile = dependency.getActualFile().getParentFile();
        Process process = this.launchBundleAudit(parentFile);
        try {
            process.waitFor();
        }
        catch (InterruptedException ie) {
            throw new AnalysisException("bundle-audit process interrupted", ie);
        }
        BufferedReader rdr = null;
        try {
            rdr = new BufferedReader(new InputStreamReader(process.getInputStream(), "UTF-8"));
            this.processBundlerAuditOutput(dependency, engine, rdr);
        }
        catch (IOException ioe) {
            LOGGER.warn("bundle-audit failure", (Throwable)ioe);
        }
        finally {
            if (null != rdr) {
                try {
                    rdr.close();
                }
                catch (IOException ioe) {
                    LOGGER.warn("bundle-audit close failure", (Throwable)ioe);
                }
            }
        }
    }

    private void processBundlerAuditOutput(Dependency original, Engine engine, BufferedReader rdr) throws IOException {
        String nextLine;
        String parentName = original.getActualFile().getParentFile().getName();
        String fileName = original.getFileName();
        Dependency dependency = null;
        Vulnerability vulnerability = null;
        String gem = null;
        HashMap<String, Dependency> map = new HashMap<String, Dependency>();
        boolean appendToDescription = false;
        while (rdr.ready() && null != (nextLine = rdr.readLine())) {
            if (nextLine.startsWith(NAME)) {
                appendToDescription = false;
                gem = nextLine.substring(NAME.length());
                if (!map.containsKey(gem)) {
                    map.put(gem, this.createDependencyForGem(engine, parentName, fileName, gem));
                }
                dependency = (Dependency)map.get(gem);
                LOGGER.debug(String.format("bundle-audit (%s): %s", parentName, nextLine));
                continue;
            }
            if (nextLine.startsWith(VERSION)) {
                vulnerability = this.createVulnerability(parentName, dependency, vulnerability, gem, nextLine);
                continue;
            }
            if (nextLine.startsWith(ADVISORY)) {
                this.setVulnerabilityName(parentName, dependency, vulnerability, nextLine);
                continue;
            }
            if (nextLine.startsWith(CRITICALITY)) {
                this.addCriticalityToVulnerability(parentName, vulnerability, nextLine);
                continue;
            }
            if (nextLine.startsWith("URL: ")) {
                this.addReferenceToVulnerability(parentName, vulnerability, nextLine);
                continue;
            }
            if (nextLine.startsWith("Description:")) {
                appendToDescription = true;
                if (null == vulnerability) continue;
                vulnerability.setDescription("*** Vulnerability obtained from bundle-audit verbose report. Title link may not work. CPE below is guessed. CVSS score is estimated (-1.0 indicates unknown). See link below for full details. *** ");
                continue;
            }
            if (!appendToDescription || null == vulnerability) continue;
            vulnerability.setDescription(vulnerability.getDescription() + nextLine + "\n");
        }
    }

    private void setVulnerabilityName(String parentName, Dependency dependency, Vulnerability vulnerability, String nextLine) {
        String advisory = nextLine.substring(ADVISORY.length());
        if (null != vulnerability) {
            vulnerability.setName(advisory);
        }
        if (null != dependency) {
            dependency.getVulnerabilities().add(vulnerability);
        }
        LOGGER.debug(String.format("bundle-audit (%s): %s", parentName, nextLine));
    }

    private void addReferenceToVulnerability(String parentName, Vulnerability vulnerability, String nextLine) {
        String url = nextLine.substring("URL: ".length());
        if (null != vulnerability) {
            Reference ref = new Reference();
            ref.setName(vulnerability.getName());
            ref.setSource("bundle-audit");
            ref.setUrl(url);
            vulnerability.getReferences().add(ref);
        }
        LOGGER.debug(String.format("bundle-audit (%s): %s", parentName, nextLine));
    }

    private void addCriticalityToVulnerability(String parentName, Vulnerability vulnerability, String nextLine) {
        if (null != vulnerability) {
            String criticality = nextLine.substring(CRITICALITY.length()).trim();
            if ("High".equals(criticality)) {
                vulnerability.setCvssScore(8.5f);
            } else if ("Medium".equals(criticality)) {
                vulnerability.setCvssScore(5.5f);
            } else if ("Low".equals(criticality)) {
                vulnerability.setCvssScore(2.0f);
            } else {
                vulnerability.setCvssScore(-1.0f);
            }
        }
        LOGGER.debug(String.format("bundle-audit (%s): %s", parentName, nextLine));
    }

    private Vulnerability createVulnerability(String parentName, Dependency dependency, Vulnerability vulnerability, String gem, String nextLine) {
        if (null != dependency) {
            String version = nextLine.substring(VERSION.length());
            dependency.getVersionEvidence().addEvidence("bundler-audit", "Version", version, Confidence.HIGHEST);
            vulnerability = new Vulnerability();
            vulnerability.setMatchedCPE(String.format("cpe:/a:%1$s_project:%1$s:%2$s::~~~ruby~~", gem, version), null);
            vulnerability.setCvssAccessVector("-");
            vulnerability.setCvssAccessComplexity("-");
            vulnerability.setCvssAuthentication("-");
            vulnerability.setCvssAvailabilityImpact("-");
            vulnerability.setCvssConfidentialityImpact("-");
            vulnerability.setCvssIntegrityImpact("-");
        }
        LOGGER.debug(String.format("bundle-audit (%s): %s", parentName, nextLine));
        return vulnerability;
    }

    private Dependency createDependencyForGem(Engine engine, String parentName, String fileName, String gem) throws IOException {
        File tempFile = File.createTempFile("Gemfile-" + gem, ".lock", Settings.getTempDirectory());
        String displayFileName = String.format("%s%c%s:%s", parentName, Character.valueOf(File.separatorChar), fileName, gem);
        FileUtils.write((File)tempFile, (CharSequence)displayFileName);
        Dependency dependency = new Dependency(tempFile);
        dependency.getProductEvidence().addEvidence("bundler-audit", "Name", gem, Confidence.HIGHEST);
        dependency.setDisplayFileName(displayFileName);
        engine.getDependencies().add(dependency);
        return dependency;
    }
}

