/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.data.cpe;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;

public class IndexEntry
implements Serializable {
    static final long serialVersionUID = 8011924485946326934L;
    private String vendor;
    private String documentId;
    private String product;
    private float searchScore;

    public String getDocumentId() {
        if (this.documentId == null && this.vendor != null && this.product != null) {
            this.documentId = this.vendor + ':' + this.product;
        }
        return this.documentId;
    }

    public void setDocumentId(String documentId) {
        this.documentId = documentId;
    }

    public String getVendor() {
        return this.vendor;
    }

    public void setVendor(String vendor) {
        this.vendor = vendor;
    }

    public String getProduct() {
        return this.product;
    }

    public void setProduct(String product) {
        this.product = product;
    }

    public float getSearchScore() {
        return this.searchScore;
    }

    public void setSearchScore(float searchScore) {
        this.searchScore = searchScore;
    }

    public void parseName(String cpeName) throws UnsupportedEncodingException {
        String[] data;
        if (cpeName != null && cpeName.length() > 7 && (data = cpeName.substring(7).split(":")).length >= 1) {
            this.vendor = URLDecoder.decode(data[0].replace("+", "%2B"), "UTF-8");
            if (data.length >= 2) {
                this.product = URLDecoder.decode(data[1].replace("+", "%2B"), "UTF-8");
            }
        }
    }

    public int hashCode() {
        int hash = 7;
        hash = 97 * hash + (this.getDocumentId() != null ? this.getDocumentId().hashCode() : 0);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        IndexEntry other = (IndexEntry)obj;
        if (this.vendor == null ? other.vendor != null : !this.vendor.equals(other.vendor)) {
            return false;
        }
        return !(this.product == null ? other.product != null : !this.product.equals(other.product));
    }

    public String toString() {
        return "IndexEntry{vendor=" + this.vendor + ", product=" + this.product + '}';
    }
}

