/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.data.nvdcve;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.owasp.dependencycheck.data.nvdcve.DatabaseException;
import org.owasp.dependencycheck.data.nvdcve.DriverLoadException;
import org.owasp.dependencycheck.data.nvdcve.DriverLoader;
import org.owasp.dependencycheck.utils.DBUtils;
import org.owasp.dependencycheck.utils.Settings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ConnectionFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConnectionFactory.class);
    public static final String DB_SCHEMA_VERSION = Settings.getString((String)"data.version");
    public static final String DB_STRUCTURE_RESOURCE = "data/initialize.sql";
    public static final String DB_STRUCTURE_UPDATE_RESOURCE = "data/upgrade_%s.sql";
    private static Driver driver = null;
    private static String connectionString = null;
    private static String userName = null;
    private static String password = null;

    private ConnectionFactory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void initialize() throws DatabaseException {
        if (connectionString != null) {
            return;
        }
        Connection conn = null;
        try {
            String driverName = Settings.getString((String)"data.driver_name", (String)"");
            if (!driverName.isEmpty()) {
                LOGGER.debug("Loading driver: {}", (Object)driverName);
                String driverPath = Settings.getString((String)"data.driver_path", (String)"");
                try {
                    if (!driverPath.isEmpty()) {
                        LOGGER.debug("Loading driver from: {}", (Object)driverPath);
                        driver = DriverLoader.load(driverName, driverPath);
                    } else {
                        driver = DriverLoader.load(driverName);
                    }
                }
                catch (DriverLoadException ex) {
                    LOGGER.debug("Unable to load database driver", (Throwable)ex);
                    throw new DatabaseException("Unable to load database driver");
                }
            }
            userName = Settings.getString((String)"data.user", (String)"dcuser");
            password = Settings.getString((String)"data.password", (String)"DC-Pass1337!");
            try {
                connectionString = Settings.getConnectionString((String)"data.connection_string", (String)"data.file_name");
            }
            catch (IOException ex) {
                LOGGER.debug("Unable to retrieve the database connection string", (Throwable)ex);
                throw new DatabaseException("Unable to retrieve the database connection string");
            }
            boolean shouldCreateSchema = false;
            try {
                if (connectionString.startsWith("jdbc:h2:file:")) {
                    shouldCreateSchema = !ConnectionFactory.h2DataFileExists();
                    LOGGER.debug("Need to create DB Structure: {}", (Object)shouldCreateSchema);
                }
            }
            catch (IOException ioex) {
                LOGGER.debug("Unable to verify database exists", (Throwable)ioex);
                throw new DatabaseException("Unable to verify database exists");
            }
            LOGGER.debug("Loading database connection");
            LOGGER.debug("Connection String: {}", (Object)connectionString);
            LOGGER.debug("Database User: {}", (Object)userName);
            try {
                conn = DriverManager.getConnection(connectionString, userName, password);
            }
            catch (SQLException ex) {
                if (ex.getMessage().contains("java.net.UnknownHostException") && connectionString.contains("AUTO_SERVER=TRUE;")) {
                    connectionString = connectionString.replace("AUTO_SERVER=TRUE;", "");
                    try {
                        conn = DriverManager.getConnection(connectionString, userName, password);
                        Settings.setString((String)"data.connection_string", (String)connectionString);
                        LOGGER.debug("Unable to start the database in server mode; reverting to single user mode");
                    }
                    catch (SQLException sqlex) {
                        LOGGER.debug("Unable to connect to the database", (Throwable)ex);
                        throw new DatabaseException("Unable to connect to the database");
                    }
                }
                LOGGER.debug("Unable to connect to the database", (Throwable)ex);
                throw new DatabaseException("Unable to connect to the database");
            }
            if (shouldCreateSchema) {
                try {
                    ConnectionFactory.createTables(conn);
                }
                catch (DatabaseException dex) {
                    LOGGER.debug("", (Throwable)dex);
                    throw new DatabaseException("Unable to create the database structure");
                }
            }
            try {
                ConnectionFactory.ensureSchemaVersion(conn);
            }
            catch (DatabaseException dex) {
                LOGGER.debug("", (Throwable)dex);
                throw new DatabaseException("Database schema does not match this version of dependency-check", dex);
            }
        }
        finally {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException ex) {
                    LOGGER.debug("An error occurred closing the connection", (Throwable)ex);
                }
            }
        }
    }

    public static synchronized void cleanup() {
        if (driver != null) {
            try {
                DriverManager.deregisterDriver(driver);
            }
            catch (SQLException ex) {
                LOGGER.debug("An error occurred unloading the database driver", (Throwable)ex);
            }
            catch (Throwable unexpected) {
                LOGGER.debug("An unexpected throwable occurred unloading the database driver", unexpected);
            }
            driver = null;
        }
        connectionString = null;
        userName = null;
        password = null;
    }

    public static Connection getConnection() throws DatabaseException {
        ConnectionFactory.initialize();
        Connection conn = null;
        try {
            conn = DriverManager.getConnection(connectionString, userName, password);
        }
        catch (SQLException ex) {
            LOGGER.debug("", (Throwable)ex);
            throw new DatabaseException("Unable to connect to the database");
        }
        return conn;
    }

    private static boolean h2DataFileExists() throws IOException {
        File dir = Settings.getDataDirectory();
        String fileName = Settings.getString((String)"data.file_name");
        File file = new File(dir, fileName);
        return file.exists();
    }

    private static void createTables(Connection conn) throws DatabaseException {
        LOGGER.debug("Creating database structure");
        BufferedReader in = null;
        try {
            String tmp;
            InputStream is = ConnectionFactory.class.getClassLoader().getResourceAsStream(DB_STRUCTURE_RESOURCE);
            InputStreamReader reader = new InputStreamReader(is, "UTF-8");
            in = new BufferedReader(reader);
            StringBuilder sb = new StringBuilder(2110);
            while ((tmp = in.readLine()) != null) {
                sb.append(tmp);
            }
            Statement statement = null;
            try {
                statement = conn.createStatement();
                statement.execute(sb.toString());
            }
            catch (SQLException ex) {
                LOGGER.debug("", (Throwable)ex);
                throw new DatabaseException("Unable to create database statement", ex);
            }
            finally {
                DBUtils.closeStatement(statement);
            }
        }
        catch (IOException ex) {
            throw new DatabaseException("Unable to create database schema", ex);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException ex) {
                    LOGGER.trace("", (Throwable)ex);
                }
            }
        }
    }

    private static void updateSchema(Connection conn, String schema) throws DatabaseException {
        LOGGER.debug("Updating database structure");
        BufferedReader in = null;
        String updateFile = null;
        try {
            String tmp;
            updateFile = String.format(DB_STRUCTURE_UPDATE_RESOURCE, schema);
            InputStream is = ConnectionFactory.class.getClassLoader().getResourceAsStream(updateFile);
            if (is == null) {
                throw new DatabaseException(String.format("Unable to load update file '%s'", updateFile));
            }
            InputStreamReader reader = new InputStreamReader(is, "UTF-8");
            in = new BufferedReader(reader);
            StringBuilder sb = new StringBuilder(2110);
            while ((tmp = in.readLine()) != null) {
                sb.append(tmp);
            }
            Statement statement = null;
            try {
                statement = conn.createStatement();
                statement.execute(sb.toString());
            }
            catch (SQLException ex) {
                LOGGER.debug("", (Throwable)ex);
                throw new DatabaseException("Unable to update database schema", ex);
            }
            finally {
                DBUtils.closeStatement(statement);
            }
        }
        catch (IOException ex) {
            String msg = String.format("Upgrade SQL file does not exist: %s", updateFile);
            throw new DatabaseException(msg, ex);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException ex) {
                    LOGGER.trace("", (Throwable)ex);
                }
            }
        }
    }

    private static void ensureSchemaVersion(Connection conn) throws DatabaseException {
        CallableStatement cs;
        ResultSet rs;
        block6: {
            rs = null;
            cs = null;
            try {
                cs = conn.prepareCall("SELECT value FROM properties WHERE id = 'version'");
                rs = cs.executeQuery();
                if (rs.next()) {
                    if (!DB_SCHEMA_VERSION.equals(rs.getString(1))) {
                        LOGGER.debug("Current Schema: " + DB_SCHEMA_VERSION);
                        LOGGER.debug("DB Schema: " + rs.getString(1));
                        ConnectionFactory.updateSchema(conn, rs.getString(1));
                    }
                    break block6;
                }
                throw new DatabaseException("Database schema is missing");
            }
            catch (SQLException ex) {
                try {
                    LOGGER.debug("", (Throwable)ex);
                    throw new DatabaseException("Unable to check the database schema version");
                }
                catch (Throwable throwable) {
                    DBUtils.closeResultSet(rs);
                    DBUtils.closeStatement(cs);
                    throw throwable;
                }
            }
        }
        DBUtils.closeResultSet(rs);
        DBUtils.closeStatement(cs);
    }
}

