/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.analyzer;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.owasp.dependencycheck.Engine;
import org.owasp.dependencycheck.analyzer.AbstractFileTypeAnalyzer;
import org.owasp.dependencycheck.analyzer.AnalysisPhase;
import org.owasp.dependencycheck.analyzer.exception.AnalysisException;
import org.owasp.dependencycheck.dependency.Confidence;
import org.owasp.dependencycheck.dependency.Dependency;
import org.owasp.dependencycheck.dependency.EvidenceCollection;
import org.owasp.dependencycheck.utils.FileFilterBuilder;

public class RubyGemspecAnalyzer
extends AbstractFileTypeAnalyzer {
    private static final String ANALYZER_NAME = "Ruby Gemspec Analyzer";
    private static final AnalysisPhase ANALYSIS_PHASE = AnalysisPhase.INFORMATION_COLLECTION;
    private static final FileFilter FILTER = FileFilterBuilder.newInstance().addExtensions("gemspec").addFilenames("Rakefile").build();
    private static final String EMAIL = "email";
    private static final String GEMSPEC = "gemspec";
    private static final Pattern GEMSPEC_BLOCK_INIT = Pattern.compile("Gem::Specification\\.new\\s+?do\\s+?\\|(.+?)\\|");

    @Override
    protected FileFilter getFileFilter() {
        return FILTER;
    }

    @Override
    protected void initializeFileTypeAnalyzer() throws Exception {
    }

    @Override
    public String getName() {
        return ANALYZER_NAME;
    }

    @Override
    public AnalysisPhase getAnalysisPhase() {
        return ANALYSIS_PHASE;
    }

    @Override
    protected String getAnalyzerEnabledSettingKey() {
        return "analyzer.ruby.gemspec.enabled";
    }

    @Override
    protected void analyzeFileType(Dependency dependency, Engine engine) throws AnalysisException {
        String contents;
        try {
            contents = FileUtils.readFileToString((File)dependency.getActualFile());
        }
        catch (IOException e) {
            throw new AnalysisException("Problem occurred while reading dependency file.", e);
        }
        Matcher matcher = GEMSPEC_BLOCK_INIT.matcher(contents);
        if (matcher.find()) {
            contents = contents.substring(matcher.end());
            String blockVariable = matcher.group(1);
            EvidenceCollection vendor = dependency.getVendorEvidence();
            this.addStringEvidence(vendor, contents, blockVariable, "author", Confidence.HIGHEST);
            this.addListEvidence(vendor, contents, blockVariable, "authors", Confidence.HIGHEST);
            String email = this.addStringEvidence(vendor, contents, blockVariable, EMAIL, Confidence.MEDIUM);
            if (email.isEmpty()) {
                this.addListEvidence(vendor, contents, blockVariable, EMAIL, Confidence.MEDIUM);
            }
            this.addStringEvidence(vendor, contents, blockVariable, "homepage", Confidence.MEDIUM);
            EvidenceCollection product = dependency.getProductEvidence();
            String name = this.addStringEvidence(product, contents, blockVariable, "name", Confidence.HIGHEST);
            if (!name.isEmpty()) {
                vendor.addEvidence(GEMSPEC, "name_project", name + "_project", Confidence.LOW);
            }
            this.addStringEvidence(product, contents, blockVariable, "summary", Confidence.LOW);
            this.addStringEvidence(dependency.getVersionEvidence(), contents, blockVariable, "version", Confidence.HIGHEST);
        }
    }

    private void addListEvidence(EvidenceCollection evidences, String contents, String blockVariable, String field, Confidence confidence) {
        Matcher matcher = Pattern.compile(String.format("\\s+?%s\\.%s\\s*?=\\s*?\\[(.*?)\\]", blockVariable, field)).matcher(contents);
        if (matcher.find()) {
            String value = matcher.group(1).replaceAll("['\"]", " ").trim();
            evidences.addEvidence(GEMSPEC, field, value, confidence);
        }
    }

    private String addStringEvidence(EvidenceCollection evidences, String contents, String blockVariable, String field, Confidence confidence) {
        Matcher matcher = Pattern.compile(String.format("\\s+?%s\\.%s\\s*?=\\s*?(['\"])(.*?)\\1", blockVariable, field)).matcher(contents);
        String value = "";
        if (matcher.find()) {
            value = matcher.group(2);
            evidences.addEvidence(GEMSPEC, field, value, confidence);
        }
        return value;
    }
}

