/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.analyzer;

import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveInputStream;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.apache.commons.compress.compressors.CompressorInputStream;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorInputStream;
import org.apache.commons.compress.compressors.bzip2.BZip2Utils;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.apache.commons.compress.compressors.gzip.GzipUtils;
import org.apache.commons.compress.utils.IOUtils;
import org.apache.commons.io.FileUtils;
import org.owasp.dependencycheck.Engine;
import org.owasp.dependencycheck.analyzer.AbstractFileTypeAnalyzer;
import org.owasp.dependencycheck.analyzer.AnalysisPhase;
import org.owasp.dependencycheck.analyzer.exception.AnalysisException;
import org.owasp.dependencycheck.analyzer.exception.ArchiveExtractionException;
import org.owasp.dependencycheck.dependency.Dependency;
import org.owasp.dependencycheck.utils.FileFilterBuilder;
import org.owasp.dependencycheck.utils.Settings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArchiveAnalyzer
extends AbstractFileTypeAnalyzer {
    private static final Logger LOGGER = LoggerFactory.getLogger(ArchiveAnalyzer.class);
    private static int dirCount = 0;
    private File tempFileLocation = null;
    private static final int MAX_SCAN_DEPTH = Settings.getInt((String)"archive.scan.depth", (int)3);
    private int scanDepth = 0;
    private static final String ANALYZER_NAME = "Archive Analyzer";
    private static final AnalysisPhase ANALYSIS_PHASE = AnalysisPhase.INITIAL;
    private static final Set<String> ZIPPABLES = ArchiveAnalyzer.newHashSet("zip", "ear", "war", "jar", "sar", "apk", "nupkg");
    private static final Set<String> EXTENSIONS = ArchiveAnalyzer.newHashSet("tar", "gz", "tgz", "bz2", "tbz2");
    private static final FileFilter REMOVE_FROM_ANALYSIS = FileFilterBuilder.newInstance().addExtensions("zip", "tar", "gz", "tgz", "bz2", "tbz2").build();
    private static final FileFilter FILTER;
    private static final FileFilter ZIP_FILTER;
    private static final Set<Dependency> EMPTY_DEPENDENCY_SET;

    @Override
    protected FileFilter getFileFilter() {
        return FILTER;
    }

    @Override
    public String getName() {
        return ANALYZER_NAME;
    }

    @Override
    public AnalysisPhase getAnalysisPhase() {
        return ANALYSIS_PHASE;
    }

    @Override
    protected String getAnalyzerEnabledSettingKey() {
        return "analyzer.archive.enabled";
    }

    @Override
    public void initializeFileTypeAnalyzer() throws Exception {
        File baseDir = Settings.getTempDirectory();
        this.tempFileLocation = File.createTempFile("check", "tmp", baseDir);
        if (!this.tempFileLocation.delete()) {
            String msg = String.format("Unable to delete temporary file '%s'.", this.tempFileLocation.getAbsolutePath());
            throw new AnalysisException(msg);
        }
        if (!this.tempFileLocation.mkdirs()) {
            String msg = String.format("Unable to create directory '%s'.", this.tempFileLocation.getAbsolutePath());
            throw new AnalysisException(msg);
        }
    }

    @Override
    public void close() throws Exception {
        if (this.tempFileLocation != null && this.tempFileLocation.exists()) {
            LOGGER.debug("Attempting to delete temporary files");
            boolean success = org.owasp.dependencycheck.utils.FileUtils.delete((File)this.tempFileLocation);
            if (!success && this.tempFileLocation.exists() && this.tempFileLocation.list().length > 0) {
                LOGGER.warn("Failed to delete some temporary files, see the log for more details");
            }
        }
    }

    @Override
    public void analyzeFileType(Dependency dependency, Engine engine) throws AnalysisException {
        File f = new File(dependency.getActualFilePath());
        File tmpDir = this.getNextTempDirectory();
        this.extractFiles(f, tmpDir, engine);
        Set<Dependency> dependencySet = ArchiveAnalyzer.findMoreDependencies(engine, tmpDir);
        if (!dependencySet.isEmpty()) {
            for (Dependency d : dependencySet) {
                String displayPath = String.format("%s%s", dependency.getFilePath(), d.getActualFilePath().substring(tmpDir.getAbsolutePath().length()));
                String displayName = String.format("%s: %s", dependency.getFileName(), d.getFileName());
                d.setFilePath(displayPath);
                d.setFileName(displayName);
                if (!this.accept(d.getActualFile()) || this.scanDepth >= MAX_SCAN_DEPTH) continue;
                ++this.scanDepth;
                this.analyze(d, engine);
                --this.scanDepth;
            }
        }
        if (REMOVE_FROM_ANALYSIS.accept(dependency.getActualFile())) {
            this.addDisguisedJarsToDependencies(dependency, engine);
            engine.getDependencies().remove(dependency);
        }
        Collections.sort(engine.getDependencies());
    }

    private void addDisguisedJarsToDependencies(Dependency dependency, Engine engine) throws AnalysisException {
        if (ZIP_FILTER.accept(dependency.getActualFile()) && this.isZipFileActuallyJarFile(dependency)) {
            File tdir = this.getNextTempDirectory();
            String fileName = dependency.getFileName();
            LOGGER.info("The zip file '{}' appears to be a JAR file, making a copy and analyzing it as a JAR.", (Object)fileName);
            File tmpLoc = new File(tdir, fileName.substring(0, fileName.length() - 3) + "jar");
            try {
                FileUtils.copyFile((File)tdir, (File)tmpLoc);
                Set<Dependency> dependencySet = ArchiveAnalyzer.findMoreDependencies(engine, tmpLoc);
                if (!dependencySet.isEmpty()) {
                    if (dependencySet.size() != 1) {
                        LOGGER.info("Deep copy of ZIP to JAR file resulted in more than one dependency?");
                    }
                    for (Dependency d : dependencySet) {
                        d.setFilePath(dependency.getFilePath());
                        d.setDisplayFileName(dependency.getFileName());
                    }
                }
            }
            catch (IOException ex) {
                LOGGER.debug("Unable to perform deep copy on '{}'", (Object)dependency.getActualFile().getPath(), (Object)ex);
            }
        }
    }

    private static Set<Dependency> findMoreDependencies(Engine engine, File file) {
        Set<Dependency> newDependencies;
        boolean sizeChanged;
        ArrayList<Dependency> before = new ArrayList<Dependency>(engine.getDependencies());
        engine.scan(file);
        List<Dependency> after = engine.getDependencies();
        boolean bl = sizeChanged = before.size() != after.size();
        if (sizeChanged) {
            newDependencies = new HashSet<Dependency>(after);
            newDependencies.removeAll(before);
        } else {
            newDependencies = EMPTY_DEPENDENCY_SET;
        }
        return newDependencies;
    }

    private File getNextTempDirectory() throws AnalysisException {
        File directory;
        if ((directory = new File(this.tempFileLocation, String.valueOf(++dirCount))).exists()) {
            return this.getNextTempDirectory();
        }
        if (!directory.mkdirs()) {
            String msg = String.format("Unable to create temp directory '%s'.", directory.getAbsolutePath());
            throw new AnalysisException(msg);
        }
        return directory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void extractFiles(File archive, File destination, Engine engine) throws AnalysisException {
        if (archive != null && destination != null) {
            FileInputStream fis;
            try {
                fis = new FileInputStream(archive);
            }
            catch (FileNotFoundException ex) {
                LOGGER.debug("", (Throwable)ex);
                throw new AnalysisException("Archive file was not found.", ex);
            }
            String archiveExt = org.owasp.dependencycheck.utils.FileUtils.getFileExtension((String)archive.getName()).toLowerCase();
            try {
                String uncompressedName;
                File f;
                if (ZIPPABLES.contains(archiveExt)) {
                    this.extractArchive((ArchiveInputStream)new ZipArchiveInputStream((InputStream)new BufferedInputStream(fis)), destination, engine);
                } else if ("tar".equals(archiveExt)) {
                    this.extractArchive((ArchiveInputStream)new TarArchiveInputStream((InputStream)new BufferedInputStream(fis)), destination, engine);
                } else if ("gz".equals(archiveExt) || "tgz".equals(archiveExt)) {
                    String uncompressedName2 = GzipUtils.getUncompressedFilename((String)archive.getName());
                    File f2 = new File(destination, uncompressedName2);
                    if (engine.accept(f2)) {
                        this.decompressFile((CompressorInputStream)new GzipCompressorInputStream((InputStream)new BufferedInputStream(fis)), f2);
                    }
                } else if (("bz2".equals(archiveExt) || "tbz2".equals(archiveExt)) && engine.accept(f = new File(destination, uncompressedName = BZip2Utils.getUncompressedFilename((String)archive.getName())))) {
                    this.decompressFile((CompressorInputStream)new BZip2CompressorInputStream((InputStream)new BufferedInputStream(fis)), f);
                }
            }
            catch (ArchiveExtractionException ex) {
                LOGGER.warn("Exception extracting archive '{}'.", (Object)archive.getName());
                LOGGER.debug("", (Throwable)ex);
            }
            catch (IOException ex) {
                LOGGER.warn("Exception reading archive '{}'.", (Object)archive.getName());
                LOGGER.debug("", (Throwable)ex);
            }
            finally {
                ArchiveAnalyzer.close(fis);
            }
        }
    }

    private void extractArchive(ArchiveInputStream input, File destination, Engine engine) throws ArchiveExtractionException {
        try {
            ArchiveEntry entry;
            while ((entry = input.getNextEntry()) != null) {
                File file = new File(destination, entry.getName());
                if (entry.isDirectory()) {
                    if (file.exists() || file.mkdirs()) continue;
                    String msg = String.format("Unable to create directory '%s'.", file.getAbsolutePath());
                    throw new AnalysisException(msg);
                }
                if (!engine.accept(file)) continue;
                ArchiveAnalyzer.extractAcceptedFile(input, file);
            }
        }
        catch (Throwable ex) {
            throw new ArchiveExtractionException(ex);
        }
        finally {
            ArchiveAnalyzer.close((Closeable)input);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void extractAcceptedFile(ArchiveInputStream input, File file) throws AnalysisException {
        LOGGER.debug("Extracting '{}'", (Object)file.getPath());
        FileOutputStream fos = null;
        try {
            File parent = file.getParentFile();
            if (!parent.isDirectory() && !parent.mkdirs()) {
                String msg = String.format("Unable to build directory '%s'.", parent.getAbsolutePath());
                throw new AnalysisException(msg);
            }
            fos = new FileOutputStream(file);
            IOUtils.copy((InputStream)input, (OutputStream)fos);
        }
        catch (FileNotFoundException ex) {
            try {
                LOGGER.debug("", (Throwable)ex);
                String msg = String.format("Unable to find file '%s'.", file.getName());
                throw new AnalysisException(msg, ex);
                catch (IOException ex2) {
                    LOGGER.debug("", (Throwable)ex2);
                    msg = String.format("IO Exception while parsing file '%s'.", file.getName());
                    throw new AnalysisException(msg, ex2);
                }
            }
            catch (Throwable throwable) {
                ArchiveAnalyzer.close(fos);
                throw throwable;
            }
        }
        ArchiveAnalyzer.close(fos);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void decompressFile(CompressorInputStream inputStream, File outputFile) throws ArchiveExtractionException {
        LOGGER.debug("Decompressing '{}'", (Object)outputFile.getPath());
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(outputFile);
            IOUtils.copy((InputStream)inputStream, (OutputStream)out);
        }
        catch (FileNotFoundException ex) {
            try {
                LOGGER.debug("", (Throwable)ex);
                throw new ArchiveExtractionException(ex);
                catch (IOException ex2) {
                    LOGGER.debug("", (Throwable)ex2);
                    throw new ArchiveExtractionException(ex2);
                }
            }
            catch (Throwable throwable) {
                ArchiveAnalyzer.close(out);
                throw throwable;
            }
        }
        ArchiveAnalyzer.close(out);
    }

    private static void close(Closeable closeable) {
        if (null != closeable) {
            try {
                closeable.close();
            }
            catch (IOException ex) {
                LOGGER.trace("", (Throwable)ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isZipFileActuallyJarFile(Dependency dependency) {
        ZipFile zip;
        boolean isJar;
        block5: {
            isJar = false;
            zip = null;
            try {
                zip = new ZipFile(dependency.getActualFilePath());
                if (zip.getEntry("META-INF/MANIFEST.MF") == null && zip.getEntry("META-INF/maven") == null) break block5;
                Enumeration entries = zip.getEntries();
                while (entries.hasMoreElements()) {
                    String name;
                    ZipArchiveEntry entry = (ZipArchiveEntry)entries.nextElement();
                    if (entry.isDirectory() || !(name = entry.getName().toLowerCase()).endsWith(".class")) continue;
                    isJar = true;
                    break;
                }
            }
            catch (IOException ex) {
                try {
                    LOGGER.debug("Unable to unzip zip file '{}'", (Object)dependency.getFilePath(), (Object)ex);
                }
                catch (Throwable throwable) {
                    ZipFile.closeQuietly(zip);
                    throw throwable;
                }
                ZipFile.closeQuietly((ZipFile)zip);
            }
        }
        ZipFile.closeQuietly((ZipFile)zip);
        return isJar;
    }

    static {
        String additionalZipExt = Settings.getString((String)"extensions.zip");
        if (additionalZipExt != null) {
            HashSet<String> ext = new HashSet<String>(Collections.singletonList(additionalZipExt));
            ZIPPABLES.addAll(ext);
        }
        EXTENSIONS.addAll(ZIPPABLES);
        FILTER = FileFilterBuilder.newInstance().addExtensions(EXTENSIONS).build();
        ZIP_FILTER = FileFilterBuilder.newInstance().addExtensions("zip").build();
        EMPTY_DEPENDENCY_SET = Collections.emptySet();
    }
}

