/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.analyzer;

import java.io.File;
import java.io.FileFilter;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.owasp.dependencycheck.Engine;
import org.owasp.dependencycheck.analyzer.AbstractAnalyzer;
import org.owasp.dependencycheck.analyzer.FileTypeAnalyzer;
import org.owasp.dependencycheck.analyzer.exception.AnalysisException;
import org.owasp.dependencycheck.dependency.Dependency;
import org.owasp.dependencycheck.utils.InvalidSettingException;
import org.owasp.dependencycheck.utils.Settings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractFileTypeAnalyzer
extends AbstractAnalyzer
implements FileTypeAnalyzer {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractFileTypeAnalyzer.class);
    private boolean filesMatched = false;
    private boolean enabled = true;

    public AbstractFileTypeAnalyzer() {
        this.reset();
    }

    protected boolean isFilesMatched() {
        return this.filesMatched;
    }

    protected void setFilesMatched(boolean filesMatched) {
        this.filesMatched = filesMatched;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    protected abstract FileFilter getFileFilter();

    protected abstract void initializeFileTypeAnalyzer() throws Exception;

    protected abstract void analyzeFileType(Dependency var1, Engine var2) throws AnalysisException;

    protected abstract String getAnalyzerEnabledSettingKey();

    @Override
    public final void initialize() throws Exception {
        if (this.filesMatched) {
            this.initializeFileTypeAnalyzer();
        } else {
            this.enabled = false;
        }
    }

    @Override
    public final void reset() {
        String key = this.getAnalyzerEnabledSettingKey();
        try {
            this.enabled = Settings.getBoolean((String)key, (boolean)true);
        }
        catch (InvalidSettingException ex) {
            LOGGER.warn("Invalid setting for property '{}'", (Object)key);
            LOGGER.debug("", (Throwable)ex);
            LOGGER.warn("{} has been disabled", (Object)this.getName());
        }
    }

    @Override
    public final void analyze(Dependency dependency, Engine engine) throws AnalysisException {
        if (this.enabled) {
            this.analyzeFileType(dependency, engine);
        }
    }

    @Override
    public boolean accept(File pathname) {
        FileFilter filter = this.getFileFilter();
        boolean accepted = false;
        if (null == filter) {
            LOGGER.error("The '{}' analyzer is misconfigured and does not have a file filter; it will be disabled", (Object)this.getName());
        } else if (this.enabled && (accepted = filter.accept(pathname))) {
            this.filesMatched = true;
        }
        return accepted;
    }

    protected static Set<String> newHashSet(String ... strings) {
        HashSet<String> set = new HashSet<String>();
        Collections.addAll(set, strings);
        return set;
    }
}

