/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.agent;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.owasp.dependencycheck.Engine;
import org.owasp.dependencycheck.data.nvdcve.CveDB;
import org.owasp.dependencycheck.data.nvdcve.DatabaseException;
import org.owasp.dependencycheck.data.nvdcve.DatabaseProperties;
import org.owasp.dependencycheck.dependency.Dependency;
import org.owasp.dependencycheck.dependency.Identifier;
import org.owasp.dependencycheck.dependency.Vulnerability;
import org.owasp.dependencycheck.exception.ScanAgentException;
import org.owasp.dependencycheck.reporting.ReportGenerator;
import org.owasp.dependencycheck.utils.Settings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DependencyCheckScanAgent {
    private static final String NEW_LINE = System.getProperty("line.separator", "\n").intern();
    private static final Logger LOGGER = LoggerFactory.getLogger(DependencyCheckScanAgent.class);
    private String applicationName = "Dependency-Check";
    private List<Dependency> dependencies;
    private String dataDirectory = null;
    private String reportOutputDirectory;
    private float failBuildOnCVSS = 11.0f;
    private boolean autoUpdate = true;
    private boolean generateReport = true;
    private ReportGenerator.Format reportFormat = ReportGenerator.Format.HTML;
    private String proxyServer;
    private String proxyPort;
    private String proxyUsername;
    private String proxyPassword;
    private String connectionTimeout;
    private String logFile = null;
    private String suppressionFile;
    private boolean showSummary = true;
    private boolean centralAnalyzerEnabled = true;
    private String centralUrl;
    private boolean nexusAnalyzerEnabled = true;
    private String nexusUrl;
    private boolean nexusUsesProxy = true;
    private String databaseDriverName;
    private String databaseDriverPath;
    private String connectionString;
    private String databaseUser;
    private String databasePassword;
    private String zipExtensions;
    private String cveUrl12Modified;
    private String cveUrl20Modified;
    private String cveUrl12Base;
    private String cveUrl20Base;
    private String pathToMono;

    public String getApplicationName() {
        return this.applicationName;
    }

    public void setApplicationName(String applicationName) {
        this.applicationName = applicationName;
    }

    public List<Dependency> getDependencies() {
        return this.dependencies;
    }

    public void setDependencies(List<Dependency> dependencies) {
        this.dependencies = dependencies;
    }

    public String getDataDirectory() {
        return this.dataDirectory;
    }

    public void setDataDirectory(String dataDirectory) {
        this.dataDirectory = dataDirectory;
    }

    public String getReportOutputDirectory() {
        return this.reportOutputDirectory;
    }

    public void setReportOutputDirectory(String reportOutputDirectory) {
        this.reportOutputDirectory = reportOutputDirectory;
    }

    public float getFailBuildOnCVSS() {
        return this.failBuildOnCVSS;
    }

    public void setFailBuildOnCVSS(float failBuildOnCVSS) {
        this.failBuildOnCVSS = failBuildOnCVSS;
    }

    public boolean isAutoUpdate() {
        return this.autoUpdate;
    }

    public void setAutoUpdate(boolean autoUpdate) {
        this.autoUpdate = autoUpdate;
    }

    public boolean isGenerateReport() {
        return this.generateReport;
    }

    public void setGenerateReport(boolean generateReport) {
        this.generateReport = generateReport;
    }

    public ReportGenerator.Format getReportFormat() {
        return this.reportFormat;
    }

    public void setReportFormat(ReportGenerator.Format reportFormat) {
        this.reportFormat = reportFormat;
    }

    public String getProxyServer() {
        return this.proxyServer;
    }

    public void setProxyServer(String proxyServer) {
        this.proxyServer = proxyServer;
    }

    @Deprecated
    public String getProxyUrl() {
        return this.proxyServer;
    }

    @Deprecated
    public void setProxyUrl(String proxyUrl) {
        this.proxyServer = proxyUrl;
    }

    public String getProxyPort() {
        return this.proxyPort;
    }

    public void setProxyPort(String proxyPort) {
        this.proxyPort = proxyPort;
    }

    public String getProxyUsername() {
        return this.proxyUsername;
    }

    public void setProxyUsername(String proxyUsername) {
        this.proxyUsername = proxyUsername;
    }

    public String getProxyPassword() {
        return this.proxyPassword;
    }

    public void setProxyPassword(String proxyPassword) {
        this.proxyPassword = proxyPassword;
    }

    public String getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public void setConnectionTimeout(String connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public String getLogFile() {
        return this.logFile;
    }

    public void setLogFile(String logFile) {
        this.logFile = logFile;
    }

    public String getSuppressionFile() {
        return this.suppressionFile;
    }

    public void setSuppressionFile(String suppressionFile) {
        this.suppressionFile = suppressionFile;
    }

    public boolean isShowSummary() {
        return this.showSummary;
    }

    public void setShowSummary(boolean showSummary) {
        this.showSummary = showSummary;
    }

    public boolean isCentralAnalyzerEnabled() {
        return this.centralAnalyzerEnabled;
    }

    public void setCentralAnalyzerEnabled(boolean centralAnalyzerEnabled) {
        this.centralAnalyzerEnabled = centralAnalyzerEnabled;
    }

    public String getCentralUrl() {
        return this.centralUrl;
    }

    public void setCentralUrl(String centralUrl) {
        this.centralUrl = centralUrl;
    }

    public boolean isNexusAnalyzerEnabled() {
        return this.nexusAnalyzerEnabled;
    }

    public void setNexusAnalyzerEnabled(boolean nexusAnalyzerEnabled) {
        this.nexusAnalyzerEnabled = nexusAnalyzerEnabled;
    }

    public String getNexusUrl() {
        return this.nexusUrl;
    }

    public void setNexusUrl(String nexusUrl) {
        this.nexusUrl = nexusUrl;
    }

    public boolean isNexusUsesProxy() {
        return this.nexusUsesProxy;
    }

    public void setNexusUsesProxy(boolean nexusUsesProxy) {
        this.nexusUsesProxy = nexusUsesProxy;
    }

    public String getDatabaseDriverName() {
        return this.databaseDriverName;
    }

    public void setDatabaseDriverName(String databaseDriverName) {
        this.databaseDriverName = databaseDriverName;
    }

    public String getDatabaseDriverPath() {
        return this.databaseDriverPath;
    }

    public void setDatabaseDriverPath(String databaseDriverPath) {
        this.databaseDriverPath = databaseDriverPath;
    }

    public String getConnectionString() {
        return this.connectionString;
    }

    public void setConnectionString(String connectionString) {
        this.connectionString = connectionString;
    }

    public String getDatabaseUser() {
        return this.databaseUser;
    }

    public void setDatabaseUser(String databaseUser) {
        this.databaseUser = databaseUser;
    }

    public String getDatabasePassword() {
        return this.databasePassword;
    }

    public void setDatabasePassword(String databasePassword) {
        this.databasePassword = databasePassword;
    }

    public String getZipExtensions() {
        return this.zipExtensions;
    }

    public void setZipExtensions(String zipExtensions) {
        this.zipExtensions = zipExtensions;
    }

    public String getCveUrl12Modified() {
        return this.cveUrl12Modified;
    }

    public void setCveUrl12Modified(String cveUrl12Modified) {
        this.cveUrl12Modified = cveUrl12Modified;
    }

    public String getCveUrl20Modified() {
        return this.cveUrl20Modified;
    }

    public void setCveUrl20Modified(String cveUrl20Modified) {
        this.cveUrl20Modified = cveUrl20Modified;
    }

    public String getCveUrl12Base() {
        return this.cveUrl12Base;
    }

    public void setCveUrl12Base(String cveUrl12Base) {
        this.cveUrl12Base = cveUrl12Base;
    }

    public String getCveUrl20Base() {
        return this.cveUrl20Base;
    }

    public void setCveUrl20Base(String cveUrl20Base) {
        this.cveUrl20Base = cveUrl20Base;
    }

    public String getPathToMono() {
        return this.pathToMono;
    }

    public void setPathToMono(String pathToMono) {
        this.pathToMono = pathToMono;
    }

    private Engine executeDependencyCheck() throws DatabaseException {
        this.populateSettings();
        Engine engine = null;
        engine = new Engine();
        engine.setDependencies(this.dependencies);
        engine.analyzeDependencies();
        return engine;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateExternalReports(Engine engine, File outDirectory) {
        DatabaseProperties prop = null;
        CveDB cve = null;
        try {
            cve = new CveDB();
            cve.open();
            prop = cve.getDatabaseProperties();
        }
        catch (DatabaseException ex) {
            LOGGER.debug("Unable to retrieve DB Properties", (Throwable)ex);
        }
        finally {
            if (cve != null) {
                cve.close();
            }
        }
        ReportGenerator r = new ReportGenerator(this.applicationName, engine.getDependencies(), engine.getAnalyzers(), prop);
        try {
            r.generateReports(outDirectory.getCanonicalPath(), this.reportFormat.name());
        }
        catch (IOException ex) {
            LOGGER.error("Unexpected exception occurred during analysis; please see the verbose error log for more details.");
            LOGGER.debug("", (Throwable)ex);
        }
        catch (Throwable ex) {
            LOGGER.error("Unexpected exception occurred during analysis; please see the verbose error log for more details.");
            LOGGER.debug("", ex);
        }
    }

    private void populateSettings() {
        Settings.initialize();
        if (this.dataDirectory != null) {
            Settings.setString((String)"data.directory", (String)this.dataDirectory);
        } else {
            File jarPath = new File(DependencyCheckScanAgent.class.getProtectionDomain().getCodeSource().getLocation().getPath());
            File base = jarPath.getParentFile();
            String sub = Settings.getString((String)"data.directory");
            File dataDir = new File(base, sub);
            Settings.setString((String)"data.directory", (String)dataDir.getAbsolutePath());
        }
        Settings.setBoolean((String)"autoupdate", (boolean)this.autoUpdate);
        if (this.proxyServer != null && !this.proxyServer.isEmpty()) {
            Settings.setString((String)"proxy.server", (String)this.proxyServer);
        }
        if (this.proxyPort != null && !this.proxyPort.isEmpty()) {
            Settings.setString((String)"proxy.port", (String)this.proxyPort);
        }
        if (this.proxyUsername != null && !this.proxyUsername.isEmpty()) {
            Settings.setString((String)"proxy.username", (String)this.proxyUsername);
        }
        if (this.proxyPassword != null && !this.proxyPassword.isEmpty()) {
            Settings.setString((String)"proxy.password", (String)this.proxyPassword);
        }
        if (this.connectionTimeout != null && !this.connectionTimeout.isEmpty()) {
            Settings.setString((String)"connection.timeout", (String)this.connectionTimeout);
        }
        if (this.suppressionFile != null && !this.suppressionFile.isEmpty()) {
            Settings.setString((String)"suppression.file", (String)this.suppressionFile);
        }
        Settings.setBoolean((String)"analyzer.central.enabled", (boolean)this.centralAnalyzerEnabled);
        if (this.centralUrl != null && !this.centralUrl.isEmpty()) {
            Settings.setString((String)"analyzer.central.url", (String)this.centralUrl);
        }
        Settings.setBoolean((String)"analyzer.nexus.enabled", (boolean)this.nexusAnalyzerEnabled);
        if (this.nexusUrl != null && !this.nexusUrl.isEmpty()) {
            Settings.setString((String)"analyzer.nexus.url", (String)this.nexusUrl);
        }
        Settings.setBoolean((String)"analyzer.nexus.proxy", (boolean)this.nexusUsesProxy);
        if (this.databaseDriverName != null && !this.databaseDriverName.isEmpty()) {
            Settings.setString((String)"data.driver_name", (String)this.databaseDriverName);
        }
        if (this.databaseDriverPath != null && !this.databaseDriverPath.isEmpty()) {
            Settings.setString((String)"data.driver_path", (String)this.databaseDriverPath);
        }
        if (this.connectionString != null && !this.connectionString.isEmpty()) {
            Settings.setString((String)"data.connection_string", (String)this.connectionString);
        }
        if (this.databaseUser != null && !this.databaseUser.isEmpty()) {
            Settings.setString((String)"data.user", (String)this.databaseUser);
        }
        if (this.databasePassword != null && !this.databasePassword.isEmpty()) {
            Settings.setString((String)"data.password", (String)this.databasePassword);
        }
        if (this.zipExtensions != null && !this.zipExtensions.isEmpty()) {
            Settings.setString((String)"extensions.zip", (String)this.zipExtensions);
        }
        if (this.cveUrl12Modified != null && !this.cveUrl12Modified.isEmpty()) {
            Settings.setString((String)"cve.url-1.2.modified", (String)this.cveUrl12Modified);
        }
        if (this.cveUrl20Modified != null && !this.cveUrl20Modified.isEmpty()) {
            Settings.setString((String)"cve.url-2.0.modified", (String)this.cveUrl20Modified);
        }
        if (this.cveUrl12Base != null && !this.cveUrl12Base.isEmpty()) {
            Settings.setString((String)"cve.url-1.2.base", (String)this.cveUrl12Base);
        }
        if (this.cveUrl20Base != null && !this.cveUrl20Base.isEmpty()) {
            Settings.setString((String)"cve.url-2.0.base", (String)this.cveUrl20Base);
        }
        if (this.pathToMono != null && !this.pathToMono.isEmpty()) {
            Settings.setString((String)"analyzer.assembly.mono.path", (String)this.pathToMono);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Engine execute() throws ScanAgentException {
        Engine engine = null;
        try {
            engine = this.executeDependencyCheck();
            if (this.generateReport) {
                this.generateExternalReports(engine, new File(this.reportOutputDirectory));
            }
            if (this.showSummary) {
                this.showSummary(engine.getDependencies());
            }
            if (this.failBuildOnCVSS <= 10.0f) {
                this.checkForFailure(engine.getDependencies());
            }
        }
        catch (DatabaseException ex) {
            LOGGER.error("Unable to connect to the dependency-check database; analysis has stopped");
            LOGGER.debug("", (Throwable)ex);
        }
        finally {
            Settings.cleanup((boolean)true);
            if (engine != null) {
                engine.cleanup();
            }
        }
        return engine;
    }

    private void checkForFailure(List<Dependency> dependencies) throws ScanAgentException {
        StringBuilder ids = new StringBuilder();
        for (Dependency d : dependencies) {
            boolean addName = true;
            for (Vulnerability v : d.getVulnerabilities()) {
                if (!(v.getCvssScore() >= this.failBuildOnCVSS)) continue;
                if (addName) {
                    addName = false;
                    ids.append(NEW_LINE).append(d.getFileName()).append(": ");
                    ids.append(v.getName());
                    continue;
                }
                ids.append(", ").append(v.getName());
            }
        }
        if (ids.length() > 0) {
            String msg = String.format("%n%nDependency-Check Failure:%nOne or more dependencies were identified with vulnerabilities that have a CVSS score greater then '%.1f': %s%nSee the dependency-check report for more details.%n%n", Float.valueOf(this.failBuildOnCVSS), ids.toString());
            throw new ScanAgentException(msg);
        }
    }

    private void showSummary(List<Dependency> dependencies) {
        StringBuilder summary = new StringBuilder();
        for (Dependency d : dependencies) {
            boolean firstEntry = true;
            StringBuilder ids = new StringBuilder();
            for (Vulnerability v : d.getVulnerabilities()) {
                if (firstEntry) {
                    firstEntry = false;
                } else {
                    ids.append(", ");
                }
                ids.append(v.getName());
            }
            if (ids.length() <= 0) continue;
            summary.append(d.getFileName()).append(" (");
            firstEntry = true;
            for (Identifier id : d.getIdentifiers()) {
                if (firstEntry) {
                    firstEntry = false;
                } else {
                    summary.append(", ");
                }
                summary.append(id.getValue());
            }
            summary.append(") : ").append((CharSequence)ids).append(NEW_LINE);
        }
        if (summary.length() > 0) {
            LOGGER.warn("\n\nOne or more dependencies were identified with known vulnerabilities:\n\n{}\n\nSee the dependency-check report for more details.\n\n", (Object)summary.toString());
        }
    }
}

