/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.utils;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveInputStream;
import org.owasp.dependencycheck.Engine;
import org.owasp.dependencycheck.analyzer.exception.AnalysisException;
import org.owasp.dependencycheck.analyzer.exception.ArchiveExtractionException;
import org.owasp.dependencycheck.utils.ExtractionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ExtractionUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExtractionUtil.class);
    private static final int BUFFER_SIZE = 4096;

    private ExtractionUtil() {
    }

    public static void extractFiles(File archive, File extractTo) throws ExtractionException {
        ExtractionUtil.extractFiles(archive, extractTo, null);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void extractFiles(File archive, File extractTo, Engine engine) throws ExtractionException {
        if (archive == null) return;
        if (extractTo == null) {
            return;
        }
        FileInputStream fis = null;
        ZipInputStream zis = null;
        try {
            fis = new FileInputStream(archive);
        }
        catch (FileNotFoundException ex) {
            LOGGER.debug("", (Throwable)ex);
            throw new ExtractionException("Archive file was not found.", (Throwable)ex);
        }
        zis = new ZipInputStream(new BufferedInputStream(fis));
        try {
            ZipEntry entry;
            while ((entry = zis.getNextEntry()) != null) {
                if (entry.isDirectory()) {
                    File d = new File(extractTo, entry.getName());
                    if (d.exists() || d.mkdirs()) continue;
                    String msg = String.format("Unable to create '%s'.", d.getAbsolutePath());
                    throw new ExtractionException(msg);
                }
                File file = new File(extractTo, entry.getName());
                if (engine != null && !engine.accept(file)) continue;
                BufferedOutputStream bos = null;
                try {
                    FileOutputStream fos = new FileOutputStream(file);
                    bos = new BufferedOutputStream(fos, 4096);
                    ExtractionUtil.transferUsingBuffer(zis, bos);
                }
                catch (FileNotFoundException ex) {
                    try {
                        LOGGER.debug("", (Throwable)ex);
                        String msg = String.format("Unable to find file '%s'.", file.getName());
                        throw new ExtractionException(msg, (Throwable)ex);
                        catch (IOException ex2) {
                            LOGGER.debug("", (Throwable)ex2);
                            msg = String.format("IO Exception while parsing file '%s'.", file.getName());
                            throw new ExtractionException(msg, (Throwable)ex2);
                        }
                    }
                    catch (Throwable throwable) {
                        ExtractionUtil.closeStream(bos);
                        throw throwable;
                    }
                }
                ExtractionUtil.closeStream(bos);
            }
            return;
        }
        catch (IOException ex) {
            String msg = String.format("Exception reading archive '%s'.", archive.getName());
            LOGGER.debug("", (Throwable)ex);
            throw new ExtractionException(msg, (Throwable)ex);
        }
        finally {
            ExtractionUtil.closeStream(zis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void extractFilesUsingFilter(File archive, File destination, FilenameFilter filter) throws ExtractionException {
        if (archive == null || destination == null) {
            return;
        }
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(archive);
        }
        catch (FileNotFoundException ex) {
            LOGGER.debug("", (Throwable)ex);
            throw new ExtractionException("Archive file was not found.", (Throwable)ex);
        }
        try {
            ExtractionUtil.extractArchive((ArchiveInputStream)new ZipArchiveInputStream((InputStream)new BufferedInputStream(fis)), destination, filter);
        }
        catch (ArchiveExtractionException ex) {
            LOGGER.warn("Exception extracting archive '{}'.", (Object)archive.getName());
            LOGGER.debug("", (Throwable)ex);
        }
        finally {
            try {
                fis.close();
            }
            catch (IOException ex) {
                LOGGER.debug("", (Throwable)ex);
            }
        }
    }

    private static void extractArchive(ArchiveInputStream input, File destination, FilenameFilter filter) throws ArchiveExtractionException {
        try {
            ArchiveEntry entry;
            while ((entry = input.getNextEntry()) != null) {
                if (entry.isDirectory()) {
                    File dir = new File(destination, entry.getName());
                    if (dir.exists() || dir.mkdirs()) continue;
                    String msg = String.format("Unable to create directory '%s'.", dir.getAbsolutePath());
                    throw new AnalysisException(msg);
                }
                ExtractionUtil.extractFile(input, destination, filter, entry);
            }
        }
        catch (IOException ex) {
            throw new ArchiveExtractionException(ex);
        }
        catch (Throwable ex) {
            throw new ArchiveExtractionException(ex);
        }
        finally {
            ExtractionUtil.closeStream((Closeable)input);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void extractFile(ArchiveInputStream input, File destination, FilenameFilter filter, ArchiveEntry entry) throws ExtractionException {
        File file = new File(destination, entry.getName());
        if (!filter.accept(file.getParentFile(), file.getName())) return;
        LOGGER.debug("Extracting '{}'", (Object)file.getPath());
        BufferedOutputStream bos = null;
        FileOutputStream fos = null;
        try {
            ExtractionUtil.createParentFile(file);
            fos = new FileOutputStream(file);
            bos = new BufferedOutputStream(fos, 4096);
            ExtractionUtil.transferUsingBuffer((InputStream)input, bos);
        }
        catch (FileNotFoundException ex) {
            try {
                LOGGER.debug("", (Throwable)ex);
                String msg = String.format("Unable to find file '%s'.", file.getName());
                throw new ExtractionException(msg, (Throwable)ex);
                catch (IOException ex2) {
                    LOGGER.debug("", (Throwable)ex2);
                    msg = String.format("IO Exception while parsing file '%s'.", file.getName());
                    throw new ExtractionException(msg, (Throwable)ex2);
                }
            }
            catch (Throwable throwable) {
                ExtractionUtil.closeStream(bos);
                ExtractionUtil.closeStream(fos);
                throw throwable;
            }
        }
        ExtractionUtil.closeStream(bos);
        ExtractionUtil.closeStream(fos);
    }

    private static void transferUsingBuffer(InputStream input, BufferedOutputStream bos) throws IOException {
        int count;
        byte[] data = new byte[4096];
        while ((count = input.read(data, 0, 4096)) != -1) {
            bos.write(data, 0, count);
        }
        bos.flush();
    }

    private static void closeStream(Closeable stream) {
        if (stream != null) {
            try {
                stream.close();
            }
            catch (IOException ex) {
                LOGGER.trace("", (Throwable)ex);
            }
        }
    }

    private static void createParentFile(File file) throws ExtractionException {
        File parent = file.getParentFile();
        if (!parent.isDirectory() && !parent.mkdirs()) {
            String msg = String.format("Unable to build directory '%s'.", parent.getAbsolutePath());
            throw new ExtractionException(msg);
        }
    }
}

