/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.reporting;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import org.apache.commons.lang.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EscapeTool {
    private static final Logger LOGGER = LoggerFactory.getLogger(EscapeTool.class);

    public String url(String text) {
        try {
            return URLEncoder.encode(text, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            LOGGER.warn("UTF-8 is not supported?");
            LOGGER.info("", (Throwable)ex);
            return "";
        }
    }

    public String html(String text) {
        return StringEscapeUtils.escapeHtml((String)text);
    }

    public String xml(String text) {
        return StringEscapeUtils.escapeXml((String)text);
    }
}

