/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.dependency;

import java.io.Serializable;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.owasp.dependencycheck.dependency.Confidence;

public class Evidence
implements Serializable,
Comparable<Evidence> {
    private static final int MAGIC_HASH_INIT_VALUE = 3;
    private static final int MAGIC_HASH_MULTIPLIER = 67;
    private String name;
    private String source;
    private String value;
    private boolean used;
    private Confidence confidence;

    public Evidence() {
    }

    public Evidence(String source, String name, String value, Confidence confidence) {
        this.source = source;
        this.name = name;
        this.value = value;
        this.confidence = confidence;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public String getValue() {
        this.used = true;
        return this.value;
    }

    public String getValue(Boolean setUsed) {
        this.used = this.used || setUsed != false;
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public boolean isUsed() {
        return this.used;
    }

    public void setUsed(boolean used) {
        this.used = used;
    }

    public Confidence getConfidence() {
        return this.confidence;
    }

    public void setConfidence(Confidence confidence) {
        this.confidence = confidence;
    }

    public int hashCode() {
        int hash = 3;
        hash = 67 * hash + ObjectUtils.hashCode((Object)StringUtils.lowerCase((String)this.name));
        hash = 67 * hash + ObjectUtils.hashCode((Object)StringUtils.lowerCase((String)this.source));
        hash = 67 * hash + ObjectUtils.hashCode((Object)StringUtils.lowerCase((String)this.value));
        hash = 67 * hash + ObjectUtils.hashCode((Object)((Object)this.confidence));
        return hash;
    }

    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (!(that instanceof Evidence)) {
            return false;
        }
        Evidence e = (Evidence)that;
        return StringUtils.equalsIgnoreCase((String)this.name, (String)e.name) && StringUtils.equalsIgnoreCase((String)this.source, (String)e.source) && StringUtils.equalsIgnoreCase((String)this.value, (String)e.value) && ObjectUtils.equals((Object)((Object)this.confidence), (Object)((Object)e.confidence));
    }

    @Override
    public int compareTo(Evidence o) {
        if (o == null) {
            return 1;
        }
        if (StringUtils.equalsIgnoreCase((String)this.source, (String)o.source)) {
            if (StringUtils.equalsIgnoreCase((String)this.name, (String)o.name)) {
                if (StringUtils.equalsIgnoreCase((String)this.value, (String)o.value)) {
                    if (ObjectUtils.equals((Object)((Object)this.confidence), (Object)((Object)o.confidence))) {
                        return 0;
                    }
                    return ObjectUtils.compare((Comparable)((Object)this.confidence), (Comparable)((Object)o.confidence));
                }
                return this.compareToIgnoreCaseWithNullCheck(this.value, o.value);
            }
            return this.compareToIgnoreCaseWithNullCheck(this.name, o.name);
        }
        return this.compareToIgnoreCaseWithNullCheck(this.source, o.source);
    }

    private int compareToIgnoreCaseWithNullCheck(String me, String other) {
        if (me == null && other == null) {
            return 0;
        }
        if (me == null) {
            return -1;
        }
        if (other == null) {
            return 1;
        }
        return me.compareToIgnoreCase(other);
    }

    public String toString() {
        return "Evidence{name=" + this.name + ", source=" + this.source + ", value=" + this.value + ", confidence=" + (Object)((Object)this.confidence) + '}';
    }
}

