/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.data.update;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Date;
import java.util.List;
import java.util.zip.GZIPInputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.io.FileUtils;
import org.owasp.dependencycheck.data.update.BaseUpdater;
import org.owasp.dependencycheck.data.update.CachedWebDataSource;
import org.owasp.dependencycheck.data.update.cpe.CPEHandler;
import org.owasp.dependencycheck.data.update.cpe.Cpe;
import org.owasp.dependencycheck.data.update.exception.UpdateException;
import org.owasp.dependencycheck.utils.DateUtil;
import org.owasp.dependencycheck.utils.DownloadFailedException;
import org.owasp.dependencycheck.utils.Downloader;
import org.owasp.dependencycheck.utils.Settings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class CpeUpdater
extends BaseUpdater
implements CachedWebDataSource {
    private static final Logger LOGGER = LoggerFactory.getLogger(CpeUpdater.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update() throws UpdateException {
        try {
            this.openDataStores();
            if (this.updateNeeded()) {
                LOGGER.info("Updating the Common Platform Enumeration (CPE)");
                File xml = this.downloadCpe();
                List<Cpe> cpes = this.processXML(xml);
                this.getCveDB().deleteUnusedCpe();
                for (Cpe cpe : cpes) {
                    this.getCveDB().addCpe(cpe.getValue(), cpe.getVendor(), cpe.getProduct());
                }
                Date now = new Date();
                this.getProperties().save("LAST_CPE_UPDATE", Long.toString(now.getTime()));
                LOGGER.info("CPE update complete");
            }
        }
        finally {
            this.closeDataStores();
        }
    }

    private File downloadCpe() throws UpdateException {
        File xml;
        try {
            URL url = new URL(Settings.getString((String)"cpe.url"));
            xml = File.createTempFile("cpe", ".xml", Settings.getTempDirectory());
            Downloader.fetchFile((URL)url, (File)xml);
            if (url.toExternalForm().endsWith(".xml.gz")) {
                this.extractGzip(xml);
            }
        }
        catch (MalformedURLException ex) {
            throw new UpdateException("Invalid CPE URL", ex);
        }
        catch (DownloadFailedException ex) {
            throw new UpdateException("Unable to download CPE XML file", ex);
        }
        catch (IOException ex) {
            throw new UpdateException("Unable to create temporary file to download CPE", ex);
        }
        return xml;
    }

    private List<Cpe> processXML(File xml) throws UpdateException {
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            SAXParser saxParser = factory.newSAXParser();
            CPEHandler handler = new CPEHandler();
            saxParser.parse(xml, (DefaultHandler)handler);
            return handler.getData();
        }
        catch (ParserConfigurationException ex) {
            throw new UpdateException("Unable to parse CPE XML file due to SAX Parser Issue", ex);
        }
        catch (SAXException ex) {
            throw new UpdateException("Unable to parse CPE XML file due to SAX Parser Exception", ex);
        }
        catch (IOException ex) {
            throw new UpdateException("Unable to parse CPE XML file due to IO Failure", ex);
        }
    }

    private boolean updateNeeded() {
        Date now = new Date();
        int days = Settings.getInt((String)"cve.url.modified.validfordays", (int)30);
        long timestamp = 0L;
        String ts = this.getProperties().getProperty("LAST_CPE_UPDATE");
        if (ts != null && ts.matches("^[0-9]+$")) {
            timestamp = Long.parseLong(ts);
        }
        return !DateUtil.withinDateRange(timestamp, now.getTime(), days);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void extractGzip(File file) throws FileNotFoundException, IOException {
        String originalPath = file.getPath();
        File gzip = new File(originalPath + ".gz");
        if (gzip.isFile() && !gzip.delete()) {
            gzip.deleteOnExit();
        }
        if (!file.renameTo(gzip)) {
            throw new IOException("Unable to rename '" + file.getPath() + "'");
        }
        File newfile = new File(originalPath);
        byte[] buffer = new byte[4096];
        GZIPInputStream cin = null;
        FileOutputStream out = null;
        try {
            int len;
            cin = new GZIPInputStream(new FileInputStream(gzip));
            out = new FileOutputStream(newfile);
            while ((len = cin.read(buffer)) > 0) {
                out.write(buffer, 0, len);
            }
        }
        finally {
            if (cin != null) {
                try {
                    cin.close();
                }
                catch (IOException ex) {
                    LOGGER.trace("ignore", (Throwable)ex);
                }
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException ex) {
                    LOGGER.trace("ignore", (Throwable)ex);
                }
            }
            if (gzip.isFile()) {
                FileUtils.deleteQuietly((File)gzip);
            }
        }
    }
}

