/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.data.cwe;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class CweDB {
    private static final Logger LOGGER = Logger.getLogger(CweDB.class.getName());
    private static final HashMap<String, String> CWE = CweDB.loadData();

    private CweDB() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static HashMap<String, String> loadData() {
        ObjectInputStream oin = null;
        try {
            HashMap ret;
            String filePath = "data/cwe.hashmap.serialized";
            InputStream input = CweDB.class.getClassLoader().getResourceAsStream("data/cwe.hashmap.serialized");
            oin = new ObjectInputStream(input);
            HashMap hashMap = ret = (HashMap)oin.readObject();
            return hashMap;
        }
        catch (ClassNotFoundException ex) {
            LOGGER.log(Level.WARNING, "Unable to load CWE data. This should not be an issue.");
            LOGGER.log(Level.FINE, null, ex);
        }
        catch (IOException ex) {
            LOGGER.log(Level.WARNING, "Unable to load CWE data due to an IO Error. This should not be an issue.");
            LOGGER.log(Level.FINE, null, ex);
        }
        finally {
            if (oin != null) {
                try {
                    oin.close();
                }
                catch (IOException ex) {
                    LOGGER.log(Level.FINEST, null, ex);
                }
            }
        }
        return null;
    }

    public static String getCweName(String cweId) {
        if (cweId != null) {
            return CWE.get(cweId);
        }
        return null;
    }
}

