/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.suppression;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.owasp.dependencycheck.dependency.Dependency;
import org.owasp.dependencycheck.dependency.Identifier;
import org.owasp.dependencycheck.dependency.Vulnerability;
import org.owasp.dependencycheck.suppression.PropertyType;

public class SuppressionRule {
    private PropertyType filePath;
    private String sha1;
    private List<PropertyType> cpe = new ArrayList<PropertyType>();
    private List<Float> cvssBelow = new ArrayList<Float>();
    private List<String> cwe = new ArrayList<String>();
    private List<String> cve = new ArrayList<String>();
    private PropertyType gav = null;
    private boolean base;

    public PropertyType getFilePath() {
        return this.filePath;
    }

    public void setFilePath(PropertyType filePath) {
        this.filePath = filePath;
    }

    public String getSha1() {
        return this.sha1;
    }

    public void setSha1(String sha1) {
        this.sha1 = sha1;
    }

    public List<PropertyType> getCpe() {
        return this.cpe;
    }

    public void setCpe(List<PropertyType> cpe) {
        this.cpe = cpe;
    }

    public void addCpe(PropertyType cpe) {
        this.cpe.add(cpe);
    }

    public boolean hasCpe() {
        return this.cpe.size() > 0;
    }

    public List<Float> getCvssBelow() {
        return this.cvssBelow;
    }

    public void setCvssBelow(List<Float> cvssBelow) {
        this.cvssBelow = cvssBelow;
    }

    public void addCvssBelow(Float cvss) {
        this.cvssBelow.add(cvss);
    }

    public boolean hasCvssBelow() {
        return this.cvssBelow.size() > 0;
    }

    public List<String> getCwe() {
        return this.cwe;
    }

    public void setCwe(List<String> cwe) {
        this.cwe = cwe;
    }

    public void addCwe(String cwe) {
        this.cwe.add(cwe);
    }

    public boolean hasCwe() {
        return this.cwe.size() > 0;
    }

    public List<String> getCve() {
        return this.cve;
    }

    public void setCve(List<String> cve) {
        this.cve = cve;
    }

    public void addCve(String cve) {
        this.cve.add(cve);
    }

    public boolean hasCve() {
        return this.cve.size() > 0;
    }

    public PropertyType getGav() {
        return this.gav;
    }

    public void setGav(PropertyType gav) {
        this.gav = gav;
    }

    public boolean hasGav() {
        return this.gav != null;
    }

    public boolean isBase() {
        return this.base;
    }

    public void setBase(boolean base) {
        this.base = base;
    }

    public void process(Dependency dependency) {
        Iterator<Identifier> itr;
        if (this.filePath != null && !this.filePath.matches(dependency.getFilePath())) {
            return;
        }
        if (this.sha1 != null && !this.sha1.equalsIgnoreCase(dependency.getSha1sum())) {
            return;
        }
        if (this.gav != null) {
            itr = dependency.getIdentifiers().iterator();
            boolean gavFound = false;
            while (itr.hasNext()) {
                Identifier i = itr.next();
                if (!this.identifierMatches("maven", this.gav, i)) continue;
                gavFound = true;
                break;
            }
            if (!gavFound) {
                return;
            }
        }
        if (this.hasCpe()) {
            itr = dependency.getIdentifiers().iterator();
            block1: while (itr.hasNext()) {
                Identifier i = itr.next();
                for (PropertyType c : this.cpe) {
                    if (!this.identifierMatches("cpe", c, i)) continue;
                    if (!this.isBase()) {
                        dependency.addSuppressedIdentifier(i);
                    }
                    itr.remove();
                    continue block1;
                }
            }
        }
        if (this.hasCve() || this.hasCwe() || this.hasCvssBelow()) {
            itr = dependency.getVulnerabilities().iterator();
            while (itr.hasNext()) {
                boolean remove = false;
                Vulnerability v = (Vulnerability)((Object)itr.next());
                for (String entry : this.cve) {
                    if (!entry.equalsIgnoreCase(v.getName())) continue;
                    remove = true;
                    break;
                }
                if (!remove) {
                    for (String entry : this.cwe) {
                        if (v.getCwe() == null) continue;
                        String toMatch = String.format("CWE-%s ", entry);
                        String toTest = v.getCwe().substring(0, toMatch.length()).toUpperCase();
                        if (!toTest.equals(toMatch)) continue;
                        remove = true;
                        break;
                    }
                }
                if (!remove) {
                    Iterator<Object> i$ = this.cvssBelow.iterator();
                    while (i$.hasNext()) {
                        float cvss = ((Float)i$.next()).floatValue();
                        if (!(v.getCvssScore() < cvss)) continue;
                        remove = true;
                        break;
                    }
                }
                if (!remove) continue;
                if (!this.isBase()) {
                    dependency.addSuppressedVulnerability(v);
                }
                itr.remove();
            }
        }
    }

    boolean cpeHasNoVersion(PropertyType c) {
        if (c.isRegex()) {
            return false;
        }
        return this.countCharacter(c.getValue(), ':') == 3;
    }

    int countCharacter(String str, char c) {
        int count = 0;
        int pos = str.indexOf(c) + 1;
        while (pos > 0) {
            ++count;
            pos = str.indexOf(c, pos) + 1;
        }
        return count;
    }

    boolean identifierMatches(String identifierType, PropertyType suppressionEntry, Identifier identifier) {
        if (identifierType.equals(identifier.getType())) {
            if (suppressionEntry.matches(identifier.getValue())) {
                return true;
            }
            if ("cpe".equals(identifierType) && this.cpeHasNoVersion(suppressionEntry)) {
                if (suppressionEntry.isCaseSensitive()) {
                    return identifier.getValue().startsWith(suppressionEntry.getValue());
                }
                String id = identifier.getValue().toLowerCase();
                String check = suppressionEntry.getValue().toLowerCase();
                return id.startsWith(check);
            }
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("SuppressionRule{");
        if (this.filePath != null) {
            sb.append("filePath=").append(this.filePath).append(",");
        }
        if (this.sha1 != null) {
            sb.append("sha1=").append(this.sha1).append(",");
        }
        if (this.gav != null) {
            sb.append("gav=").append(this.gav).append(",");
        }
        if (this.cpe != null && this.cpe.size() > 0) {
            sb.append("cpe={");
            for (PropertyType propertyType : this.cpe) {
                sb.append(propertyType).append(",");
            }
            sb.append("}");
        }
        if (this.cwe != null && this.cwe.size() > 0) {
            sb.append("cwe={");
            for (String string : this.cwe) {
                sb.append(string).append(",");
            }
            sb.append("}");
        }
        if (this.cve != null && this.cve.size() > 0) {
            sb.append("cve={");
            for (String string : this.cve) {
                sb.append(string).append(",");
            }
            sb.append("}");
        }
        if (this.cvssBelow != null && this.cvssBelow.size() > 0) {
            sb.append("cvssBelow={");
            for (Float f : this.cvssBelow) {
                sb.append(f).append(",");
            }
            sb.append("}");
        }
        sb.append("}");
        return sb.toString();
    }
}

