/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.reporting;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang.StringEscapeUtils;

public class EscapeTool {
    private static final Logger LOGGER = Logger.getLogger(EscapeTool.class.getName());

    public String url(String text) {
        try {
            return URLEncoder.encode(text, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            LOGGER.log(Level.WARNING, "UTF-8 is not supported?");
            LOGGER.log(Level.INFO, null, ex);
            return "";
        }
    }

    public String html(String text) {
        return StringEscapeUtils.escapeHtml((String)text);
    }

    public String xml(String text) {
        return StringEscapeUtils.escapeXml((String)text);
    }
}

