/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.data.nvdcve;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.owasp.dependencycheck.data.nvdcve.DatabaseException;
import org.owasp.dependencycheck.data.nvdcve.DriverLoadException;
import org.owasp.dependencycheck.data.nvdcve.DriverLoader;
import org.owasp.dependencycheck.utils.DBUtils;
import org.owasp.dependencycheck.utils.Settings;

public final class ConnectionFactory {
    private static final Logger LOGGER = Logger.getLogger(ConnectionFactory.class.getName());
    public static final String DB_SCHEMA_VERSION = "2.9";
    public static final String DB_STRUCTURE_RESOURCE = "data/initialize.sql";
    private static Driver driver = null;
    private static String connectionString = null;
    private static String userName = null;
    private static String password = null;

    private ConnectionFactory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void initialize() throws DatabaseException {
        block29: {
            if (connectionString != null) {
                return;
            }
            Connection conn = null;
            try {
                String driverName = Settings.getString((String)"data.driver_name", (String)"");
                if (!driverName.isEmpty()) {
                    LOGGER.log(Level.FINE, "Loading driver: {0}", driverName);
                    String driverPath = Settings.getString((String)"data.driver_path", (String)"");
                    try {
                        if (!driverPath.isEmpty()) {
                            LOGGER.log(Level.FINE, "Loading driver from: {0}", driverPath);
                            driver = DriverLoader.load(driverName, driverPath);
                        } else {
                            driver = DriverLoader.load(driverName);
                        }
                    }
                    catch (DriverLoadException ex) {
                        LOGGER.log(Level.FINE, "Unable to load database driver", ex);
                        throw new DatabaseException("Unable to load database driver");
                    }
                }
                userName = Settings.getString((String)"data.user", (String)"dcuser");
                password = Settings.getString((String)"data.password", (String)"DC-Pass1337!");
                try {
                    connectionString = ConnectionFactory.getConnectionString();
                }
                catch (IOException ex) {
                    LOGGER.log(Level.FINE, "Unable to retrieve the database connection string", ex);
                    throw new DatabaseException("Unable to retrieve the database connection string");
                }
                boolean shouldCreateSchema = false;
                try {
                    if (connectionString.startsWith("jdbc:h2:file:")) {
                        shouldCreateSchema = !ConnectionFactory.dbSchemaExists();
                        LOGGER.log(Level.FINE, "Need to create DB Structure: {0}", shouldCreateSchema);
                    }
                }
                catch (IOException ioex) {
                    LOGGER.log(Level.FINE, "Unable to verify database exists", ioex);
                    throw new DatabaseException("Unable to verify database exists");
                }
                LOGGER.log(Level.FINE, "Loading database connection");
                LOGGER.log(Level.FINE, "Connection String: {0}", connectionString);
                LOGGER.log(Level.FINE, "Database User: {0}", userName);
                try {
                    conn = DriverManager.getConnection(connectionString, userName, password);
                }
                catch (SQLException ex) {
                    if (ex.getMessage().contains("java.net.UnknownHostException") && connectionString.contains("AUTO_SERVER=TRUE;")) {
                        connectionString = connectionString.replace("AUTO_SERVER=TRUE;", "");
                        try {
                            conn = DriverManager.getConnection(connectionString, userName, password);
                            Settings.setString((String)"data.connection_string", (String)connectionString);
                            LOGGER.log(Level.FINE, "Unable to start the database in server mode; reverting to single user mode");
                        }
                        catch (SQLException sqlex) {
                            LOGGER.log(Level.FINE, "Unable to connect to the database", ex);
                            throw new DatabaseException("Unable to connect to the database");
                        }
                    }
                    LOGGER.log(Level.FINE, "Unable to connect to the database", ex);
                    throw new DatabaseException("Unable to connect to the database");
                }
                if (shouldCreateSchema) {
                    try {
                        ConnectionFactory.createTables(conn);
                        break block29;
                    }
                    catch (DatabaseException dex) {
                        LOGGER.log(Level.FINE, null, dex);
                        throw new DatabaseException("Unable to create the database structure");
                    }
                }
                try {
                    ConnectionFactory.ensureSchemaVersion(conn);
                }
                catch (DatabaseException dex) {
                    LOGGER.log(Level.FINE, null, dex);
                    throw new DatabaseException("Database schema does not match this version of dependency-check");
                }
            }
            finally {
                if (conn != null) {
                    try {
                        conn.close();
                    }
                    catch (SQLException ex) {
                        LOGGER.log(Level.FINE, "An error occurred closing the connection", ex);
                    }
                }
            }
        }
    }

    public static synchronized void cleanup() {
        if (driver != null) {
            try {
                DriverManager.deregisterDriver(driver);
            }
            catch (SQLException ex) {
                LOGGER.log(Level.FINE, "An error occurred unloading the database driver", ex);
            }
            catch (Throwable unexpected) {
                LOGGER.log(Level.FINE, "An unexpected throwable occurred unloading the database driver", unexpected);
            }
            driver = null;
        }
        connectionString = null;
        userName = null;
        password = null;
    }

    public static Connection getConnection() throws DatabaseException {
        ConnectionFactory.initialize();
        Connection conn = null;
        try {
            conn = DriverManager.getConnection(connectionString, userName, password);
        }
        catch (SQLException ex) {
            LOGGER.log(Level.FINE, null, ex);
            throw new DatabaseException("Unable to connect to the database");
        }
        return conn;
    }

    private static String getConnectionString() throws IOException {
        String connStr = Settings.getString((String)"data.connection_string", (String)"jdbc:h2:file:%s;AUTO_SERVER=TRUE");
        if (connStr.contains("%s")) {
            String directory = ConnectionFactory.getDataDirectory().getCanonicalPath();
            File dataFile = new File(directory, "cve.2.9");
            LOGGER.log(Level.FINE, String.format("File path for H2 file: '%s'", dataFile.toString()));
            return String.format(connStr, dataFile.getAbsolutePath());
        }
        return connStr;
    }

    public static File getDataDirectory() throws IOException {
        File path = Settings.getDataFile((String)"data.directory");
        if (!path.exists() && !path.mkdirs()) {
            throw new IOException("Unable to create NVD CVE Data directory");
        }
        return path;
    }

    private static boolean dbSchemaExists() throws IOException {
        File dir = ConnectionFactory.getDataDirectory();
        String name = String.format("cve.%s.h2.db", DB_SCHEMA_VERSION);
        File file = new File(dir, name);
        return file.exists();
    }

    private static void createTables(Connection conn) throws DatabaseException {
        LOGGER.log(Level.FINE, "Creating database structure");
        BufferedReader in = null;
        try {
            String tmp;
            InputStream is = ConnectionFactory.class.getClassLoader().getResourceAsStream(DB_STRUCTURE_RESOURCE);
            InputStreamReader reader = new InputStreamReader(is, "UTF-8");
            in = new BufferedReader(reader);
            StringBuilder sb = new StringBuilder(2110);
            while ((tmp = in.readLine()) != null) {
                sb.append(tmp);
            }
            Statement statement = null;
            try {
                statement = conn.createStatement();
                statement.execute(sb.toString());
            }
            catch (SQLException ex) {
                LOGGER.log(Level.FINE, null, ex);
                throw new DatabaseException("Unable to create database statement", ex);
            }
            finally {
                DBUtils.closeStatement(statement);
            }
        }
        catch (IOException ex) {
            throw new DatabaseException("Unable to create database schema", ex);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException ex) {
                    LOGGER.log(Level.FINEST, null, ex);
                }
            }
        }
    }

    private static void ensureSchemaVersion(Connection conn) throws DatabaseException {
        CallableStatement cs;
        ResultSet rs;
        block6: {
            rs = null;
            cs = null;
            try {
                cs = conn.prepareCall("SELECT value FROM properties WHERE id = 'version'");
                rs = cs.executeQuery();
                if (rs.next()) {
                    boolean isWrongSchema;
                    boolean bl = isWrongSchema = !DB_SCHEMA_VERSION.equals(rs.getString(1));
                    if (isWrongSchema) {
                        throw new DatabaseException("Incorrect database schema; unable to continue");
                    }
                    break block6;
                }
                throw new DatabaseException("Database schema is missing");
            }
            catch (SQLException ex) {
                try {
                    LOGGER.log(Level.FINE, null, ex);
                    throw new DatabaseException("Unable to check the database schema version");
                }
                catch (Throwable throwable) {
                    DBUtils.closeResultSet(rs);
                    DBUtils.closeStatement(cs);
                    throw throwable;
                }
            }
        }
        DBUtils.closeResultSet(rs);
        DBUtils.closeStatement(cs);
    }
}

