/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.xml.pom;

import java.io.File;
import java.io.IOException;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import org.owasp.dependencycheck.analyzer.JarAnalyzer;
import org.owasp.dependencycheck.analyzer.exception.AnalysisException;
import org.owasp.dependencycheck.dependency.Dependency;
import org.owasp.dependencycheck.xml.pom.Model;
import org.owasp.dependencycheck.xml.pom.PomParseException;
import org.owasp.dependencycheck.xml.pom.PomParser;

public final class PomUtils {
    private static final Logger LOGGER = Logger.getLogger(PomUtils.class.getName());

    private PomUtils() {
    }

    public static Model readPom(File file) throws AnalysisException {
        Model model = null;
        try {
            PomParser parser = new PomParser();
            model = parser.parse(file);
        }
        catch (PomParseException ex) {
            String msg = String.format("Unable to parse pom '%s'", file.getPath());
            LOGGER.log(Level.WARNING, msg);
            LOGGER.log(Level.FINE, "", ex);
            throw new AnalysisException(ex);
        }
        catch (IOException ex) {
            String msg = String.format("Unable to parse pom '%s'(IO Exception)", file.getPath());
            LOGGER.log(Level.WARNING, msg);
            LOGGER.log(Level.FINE, "", ex);
            throw new AnalysisException(ex);
        }
        catch (Throwable ex) {
            String msg = String.format("Unexpected error during parsing of the pom '%s'", file.getPath());
            LOGGER.log(Level.WARNING, msg);
            LOGGER.log(Level.FINE, "", ex);
            throw new AnalysisException(ex);
        }
        return model;
    }

    public static Model readPom(String path, JarFile jar) throws AnalysisException {
        ZipEntry entry = jar.getEntry(path);
        Model model = null;
        if (entry != null) {
            try {
                PomParser parser = new PomParser();
                model = parser.parse(jar.getInputStream(entry));
                LOGGER.fine(String.format("Read POM %s", path));
            }
            catch (SecurityException ex) {
                String msg = String.format("Unable to parse pom '%s' in jar '%s'; invalid signature", path, jar.getName());
                LOGGER.log(Level.WARNING, msg);
                LOGGER.log(Level.FINE, null, ex);
                throw new AnalysisException(ex);
            }
            catch (IOException ex) {
                String msg = String.format("Unable to parse pom '%s' in jar '%s' (IO Exception)", path, jar.getName());
                LOGGER.log(Level.WARNING, msg);
                LOGGER.log(Level.FINE, "", ex);
                throw new AnalysisException(ex);
            }
            catch (Throwable ex) {
                String msg = String.format("Unexpected error during parsing of the pom '%s' in jar '%s'", path, jar.getName());
                LOGGER.log(Level.WARNING, msg);
                LOGGER.log(Level.FINE, "", ex);
                throw new AnalysisException(ex);
            }
        }
        return model;
    }

    public static void analyzePOM(Dependency dependency, File pomFile) throws AnalysisException {
        Model pom = PomUtils.readPom(pomFile);
        JarAnalyzer.setPomEvidence(dependency, pom, null);
    }
}

