/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.xml.pom;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.owasp.dependencycheck.xml.pom.License;

public class Model {
    private String name;
    private String organization;
    private String description;
    private String groupId;
    private String artifactId;
    private String version;
    private String parentGroupId;
    private String parentArtifactId;
    private String parentVersion;
    private List<License> licenses = new ArrayList<License>();

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getOrganization() {
        return this.organization;
    }

    public void setOrganization(String organization) {
        this.organization = organization;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public void setArtifactId(String artifactId) {
        this.artifactId = artifactId;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getParentGroupId() {
        return this.parentGroupId;
    }

    public void setParentGroupId(String parentGroupId) {
        this.parentGroupId = parentGroupId;
    }

    public String getParentArtifactId() {
        return this.parentArtifactId;
    }

    public void setParentArtifactId(String parentArtifactId) {
        this.parentArtifactId = parentArtifactId;
    }

    public String getParentVersion() {
        return this.parentVersion;
    }

    public void setParentVersion(String parentVersion) {
        this.parentVersion = parentVersion;
    }

    public List<License> getLicenses() {
        return this.licenses;
    }

    public void addLicense(License license) {
        this.licenses.add(license);
    }

    public void processProperties(Properties properties) {
        this.groupId = Model.interpolateString(this.groupId, properties);
        this.artifactId = Model.interpolateString(this.artifactId, properties);
        this.version = Model.interpolateString(this.version, properties);
        this.description = Model.interpolateString(this.description, properties);
        for (License l : this.getLicenses()) {
            l.setName(Model.interpolateString(l.getName(), properties));
            l.setUrl(Model.interpolateString(l.getUrl(), properties));
        }
        this.name = Model.interpolateString(this.name, properties);
        this.organization = Model.interpolateString(this.organization, properties);
        this.parentGroupId = Model.interpolateString(this.parentGroupId, properties);
        this.parentArtifactId = Model.interpolateString(this.parentArtifactId, properties);
        this.parentVersion = Model.interpolateString(this.parentVersion, properties);
    }

    public static String interpolateString(String text, Properties properties) {
        Properties props = properties;
        if (text == null) {
            return text;
        }
        if (props == null) {
            return text;
        }
        int pos = text.indexOf("${");
        if (pos < 0) {
            return text;
        }
        int end = text.indexOf("}");
        if (end < pos) {
            return text;
        }
        String propName = text.substring(pos + 2, end);
        String propValue = Model.interpolateString(props.getProperty(propName), props);
        if (propValue == null) {
            propValue = "";
        }
        StringBuilder sb = new StringBuilder(propValue.length() + text.length());
        sb.append(text.subSequence(0, pos));
        sb.append(propValue);
        sb.append(text.substring(end + 1));
        return Model.interpolateString(sb.toString(), props);
    }
}

