/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.analyzer;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.NameFileFilter;
import org.apache.commons.io.filefilter.SuffixFileFilter;
import org.owasp.dependencycheck.Engine;
import org.owasp.dependencycheck.analyzer.AbstractFileTypeAnalyzer;
import org.owasp.dependencycheck.analyzer.AnalysisPhase;
import org.owasp.dependencycheck.analyzer.JarAnalyzer;
import org.owasp.dependencycheck.analyzer.PythonDistributionAnalyzer;
import org.owasp.dependencycheck.analyzer.exception.AnalysisException;
import org.owasp.dependencycheck.dependency.Confidence;
import org.owasp.dependencycheck.dependency.Dependency;
import org.owasp.dependencycheck.dependency.EvidenceCollection;
import org.owasp.dependencycheck.utils.UrlStringUtils;

public class PythonPackageAnalyzer
extends AbstractFileTypeAnalyzer {
    private static final int REGEX_OPTIONS = 34;
    private static final Logger LOGGER = Logger.getLogger(PythonDistributionAnalyzer.class.getName());
    private static final Set<String> EXTENSIONS = Collections.unmodifiableSet(Collections.singleton("py"));
    private static final Pattern MODULE_DOCSTRING = Pattern.compile("^(['\\\"]{3})(.*?)\\1", 34);
    private static final Pattern VERSION_PATTERN = Pattern.compile("\\b(__)?version(__)? *= *(['\"]+)(\\d+\\.\\d+.*?)\\3", 34);
    private static final Pattern TITLE_PATTERN = PythonPackageAnalyzer.compileAssignPattern("title");
    private static final Pattern SUMMARY_PATTERN = PythonPackageAnalyzer.compileAssignPattern("summary");
    private static final Pattern URI_PATTERN = PythonPackageAnalyzer.compileAssignPattern("ur[il]");
    private static final Pattern HOMEPAGE_PATTERN = PythonPackageAnalyzer.compileAssignPattern("home_?page");
    private static final Pattern AUTHOR_PATTERN = PythonPackageAnalyzer.compileAssignPattern("author");
    private static final FileFilter INIT_PY_FILTER = new NameFileFilter("__init__.py");
    private static final FileFilter PY_FILTER = new SuffixFileFilter(".py");

    @Override
    public String getName() {
        return "Python Package Analyzer";
    }

    @Override
    public AnalysisPhase getAnalysisPhase() {
        return AnalysisPhase.INFORMATION_COLLECTION;
    }

    @Override
    protected Set<String> getSupportedExtensions() {
        return EXTENSIONS;
    }

    @Override
    protected void initializeFileTypeAnalyzer() throws Exception {
    }

    private static Pattern compileAssignPattern(String name) {
        return Pattern.compile(String.format("\\b(__)?%s(__)?\\b *= *(['\"]+)(.*?)\\3", name), 34);
    }

    @Override
    protected void analyzeFileType(Dependency dependency, Engine engine) throws AnalysisException {
        File file = dependency.getActualFile();
        File parent = file.getParentFile();
        String parentName = parent.getName();
        boolean found = false;
        if (INIT_PY_FILTER.accept(file)) {
            for (File sourcefile : parent.listFiles(PY_FILTER)) {
                found |= this.analyzeFileContents(dependency, sourcefile);
            }
        }
        if (found) {
            dependency.setDisplayFileName(parentName + "/__init__.py");
            dependency.getProductEvidence().addEvidence(file.getName(), "PackageName", parentName, Confidence.MEDIUM);
        } else {
            ArrayList<Dependency> deps = new ArrayList<Dependency>(engine.getDependencies());
            deps.remove(dependency);
            engine.setDependencies(deps);
        }
    }

    private boolean analyzeFileContents(Dependency dependency, File file) throws AnalysisException {
        String contents = "";
        try {
            contents = FileUtils.readFileToString((File)file).trim();
        }
        catch (IOException e) {
            throw new AnalysisException("Problem occured while reading dependency file.", e);
        }
        boolean found = false;
        if (!contents.isEmpty()) {
            String source = file.getName();
            found = this.gatherEvidence(VERSION_PATTERN, contents, source, dependency.getVersionEvidence(), "SourceVersion", Confidence.MEDIUM);
            found |= this.addSummaryInfo(dependency, SUMMARY_PATTERN, 4, contents, source, "summary");
            if (INIT_PY_FILTER.accept(file)) {
                found |= this.addSummaryInfo(dependency, MODULE_DOCSTRING, 2, contents, source, "docstring");
            }
            found |= this.gatherEvidence(TITLE_PATTERN, contents, source, dependency.getProductEvidence(), "SourceTitle", Confidence.LOW);
            EvidenceCollection vendorEvidence = dependency.getVendorEvidence();
            found |= this.gatherEvidence(AUTHOR_PATTERN, contents, source, vendorEvidence, "SourceAuthor", Confidence.MEDIUM);
            try {
                found |= this.gatherHomePageEvidence(URI_PATTERN, vendorEvidence, source, "URL", contents);
                found |= this.gatherHomePageEvidence(HOMEPAGE_PATTERN, vendorEvidence, source, "HomePage", contents);
            }
            catch (MalformedURLException e) {
                LOGGER.warning(e.getMessage());
            }
        }
        return found;
    }

    private boolean addSummaryInfo(Dependency dependency, Pattern pattern, int group, String contents, String source, String key) {
        Matcher matcher = pattern.matcher(contents);
        boolean found = matcher.find();
        if (found) {
            JarAnalyzer.addDescription(dependency, matcher.group(group), source, key);
        }
        return found;
    }

    private boolean gatherHomePageEvidence(Pattern pattern, EvidenceCollection evidence, String source, String name, String contents) throws MalformedURLException {
        String url;
        Matcher matcher = pattern.matcher(contents);
        boolean found = false;
        if (matcher.find() && UrlStringUtils.isUrl(url = matcher.group(4))) {
            found = true;
            evidence.addEvidence(source, name, url, Confidence.MEDIUM);
        }
        return found;
    }

    private boolean gatherEvidence(Pattern pattern, String contents, String source, EvidenceCollection evidence, String name, Confidence confidence) {
        Matcher matcher = pattern.matcher(contents);
        boolean found = matcher.find();
        if (found) {
            evidence.addEvidence(source, name, matcher.group(4), confidence);
        }
        return found;
    }

    @Override
    protected String getAnalyzerEnabledSettingKey() {
        return "analyzer.python.package.enabled";
    }
}

