/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.data.central;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.owasp.dependencycheck.data.nexus.MavenArtifact;
import org.owasp.dependencycheck.utils.Settings;
import org.owasp.dependencycheck.utils.URLConnectionFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

public class CentralSearch {
    private final URL rootURL;
    private boolean useProxy;
    private static final Logger LOGGER = Logger.getLogger(CentralSearch.class.getName());

    public CentralSearch(URL rootURL) {
        this.rootURL = rootURL;
        if (null != Settings.getString((String)"proxy.server")) {
            this.useProxy = true;
            LOGGER.fine("Using proxy");
        } else {
            this.useProxy = false;
            LOGGER.fine("Not using proxy");
        }
    }

    public List<MavenArtifact> searchSha1(String sha1) throws IOException {
        if (null == sha1 || !sha1.matches("^[0-9A-Fa-f]{40}$")) {
            throw new IllegalArgumentException("Invalid SHA1 format");
        }
        URL url = new URL(this.rootURL + String.format("?q=1:\"%s\"&wt=xml", sha1));
        LOGGER.fine(String.format("Searching Central url %s", url.toString()));
        HttpURLConnection conn = URLConnectionFactory.createHttpURLConnection((URL)url, (boolean)this.useProxy);
        conn.setDoOutput(true);
        conn.addRequestProperty("Accept", "application/xml");
        conn.connect();
        if (conn.getResponseCode() == 200) {
            boolean missing = false;
            try {
                DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                Document doc = builder.parse(conn.getInputStream());
                XPath xpath = XPathFactory.newInstance().newXPath();
                String numFound = xpath.evaluate("/response/result/@numFound", doc);
                if (!"0".equals(numFound)) {
                    ArrayList<MavenArtifact> result = new ArrayList<MavenArtifact>();
                    NodeList docs = (NodeList)xpath.evaluate("/response/result/doc", doc, XPathConstants.NODESET);
                    for (int i = 0; i < docs.getLength(); ++i) {
                        String g = xpath.evaluate("./str[@name='g']", docs.item(i));
                        LOGGER.finest(String.format("GroupId: %s", g));
                        String a = xpath.evaluate("./str[@name='a']", docs.item(i));
                        LOGGER.finest(String.format("ArtifactId: %s", a));
                        String v = xpath.evaluate("./str[@name='v']", docs.item(i));
                        NodeList atts = (NodeList)xpath.evaluate("./arr[@name='ec']/str", docs.item(i), XPathConstants.NODESET);
                        boolean pomAvailable = false;
                        boolean jarAvailable = false;
                        for (int x = 0; x < atts.getLength(); ++x) {
                            String tmp = xpath.evaluate(".", atts.item(x));
                            if (".pom".equals(tmp)) {
                                pomAvailable = true;
                                continue;
                            }
                            if (!".jar".equals(tmp)) continue;
                            jarAvailable = true;
                        }
                        LOGGER.finest(String.format("Version: %s", v));
                        result.add(new MavenArtifact(g, a, v, jarAvailable, pomAvailable));
                    }
                    return result;
                }
                missing = true;
            }
            catch (Throwable e) {
                throw new IOException(e.getMessage(), e);
            }
            if (missing) {
                throw new FileNotFoundException("Artifact not found in Central");
            }
        } else {
            String msg = String.format("Could not connect to Central received response code: %d %s", conn.getResponseCode(), conn.getResponseMessage());
            LOGGER.fine(msg);
            throw new IOException(msg);
        }
        return null;
    }
}

