/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.analyzer;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.io.FileUtils;
import org.owasp.dependencycheck.Engine;
import org.owasp.dependencycheck.analyzer.AbstractFileTypeAnalyzer;
import org.owasp.dependencycheck.analyzer.AnalysisPhase;
import org.owasp.dependencycheck.analyzer.exception.AnalysisException;
import org.owasp.dependencycheck.data.central.CentralSearch;
import org.owasp.dependencycheck.data.nexus.MavenArtifact;
import org.owasp.dependencycheck.dependency.Confidence;
import org.owasp.dependencycheck.dependency.Dependency;
import org.owasp.dependencycheck.dependency.Evidence;
import org.owasp.dependencycheck.utils.DownloadFailedException;
import org.owasp.dependencycheck.utils.Downloader;
import org.owasp.dependencycheck.utils.InvalidSettingException;
import org.owasp.dependencycheck.utils.Settings;
import org.owasp.dependencycheck.xml.pom.PomUtils;

public class CentralAnalyzer
extends AbstractFileTypeAnalyzer {
    private static final Logger LOGGER = Logger.getLogger(CentralAnalyzer.class.getName());
    private static final String ANALYZER_NAME = "Central Analyzer";
    private static final AnalysisPhase ANALYSIS_PHASE = AnalysisPhase.INFORMATION_COLLECTION;
    private static final Set<String> SUPPORTED_EXTENSIONS = CentralAnalyzer.newHashSet("jar");
    private boolean errorFlag = false;
    private CentralSearch searcher;
    private final boolean enabled = this.checkEnabled();

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    private boolean checkEnabled() {
        boolean retval = false;
        try {
            if (Settings.getBoolean((String)"analyzer.central.enabled")) {
                if (!Settings.getBoolean((String)"analyzer.nexus.enabled") || "https://repository.sonatype.org/service/local/".equals(Settings.getString((String)"analyzer.nexus.url"))) {
                    LOGGER.fine("Enabling the Central analyzer");
                    retval = true;
                } else {
                    LOGGER.info("Nexus analyzer is enabled, disabling the Central Analyzer");
                }
            } else {
                LOGGER.info("Central analyzer disabled");
            }
        }
        catch (InvalidSettingException ise) {
            LOGGER.warning("Invalid setting. Disabling the Central analyzer");
        }
        return retval;
    }

    @Override
    public void initializeFileTypeAnalyzer() throws Exception {
        LOGGER.fine("Initializing Central analyzer");
        LOGGER.fine(String.format("Central analyzer enabled: %s", this.isEnabled()));
        if (this.isEnabled()) {
            String searchUrl = Settings.getString((String)"analyzer.central.url");
            LOGGER.fine(String.format("Central Analyzer URL: %s", searchUrl));
            this.searcher = new CentralSearch(new URL(searchUrl));
        }
    }

    @Override
    public String getName() {
        return ANALYZER_NAME;
    }

    @Override
    protected String getAnalyzerEnabledSettingKey() {
        return "analyzer.central.enabled";
    }

    @Override
    public AnalysisPhase getAnalysisPhase() {
        return ANALYSIS_PHASE;
    }

    @Override
    public Set<String> getSupportedExtensions() {
        return SUPPORTED_EXTENSIONS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void analyzeFileType(Dependency dependency, Engine engine) throws AnalysisException {
        if (this.errorFlag || !this.isEnabled()) {
            return;
        }
        try {
            List<MavenArtifact> mas = this.searcher.searchSha1(dependency.getSha1sum());
            Confidence confidence = mas.size() > 1 ? Confidence.HIGH : Confidence.HIGHEST;
            for (MavenArtifact ma : mas) {
                String msg;
                LOGGER.fine(String.format("Central analyzer found artifact (%s) for dependency (%s)", ma.toString(), dependency.getFileName()));
                dependency.addAsEvidence("central", ma, confidence);
                boolean pomAnalyzed = false;
                for (Evidence e : dependency.getVendorEvidence()) {
                    if (!"pom".equals(e.getSource())) continue;
                    pomAnalyzed = true;
                    break;
                }
                if (pomAnalyzed || ma.getPomUrl() == null) continue;
                File pomFile = null;
                try {
                    File baseDir = Settings.getTempDirectory();
                    pomFile = File.createTempFile("pom", ".xml", baseDir);
                    if (!pomFile.delete()) {
                        msg = String.format("Unable to fetch pom.xml for %s from Central; this could result in undetected CPE/CVEs.", dependency.getFileName());
                        LOGGER.warning(msg);
                        LOGGER.fine("Unable to delete temp file");
                    }
                    LOGGER.fine(String.format("Downloading %s", ma.getPomUrl()));
                    Downloader.fetchFile((URL)new URL(ma.getPomUrl()), (File)pomFile);
                    PomUtils.analyzePOM(dependency, pomFile);
                }
                catch (DownloadFailedException ex) {
                    msg = String.format("Unable to download pom.xml for %s from Central; this could result in undetected CPE/CVEs.", dependency.getFileName());
                    LOGGER.warning(msg);
                }
                finally {
                    if (pomFile == null || FileUtils.deleteQuietly((File)pomFile)) continue;
                    pomFile.deleteOnExit();
                }
            }
        }
        catch (IllegalArgumentException iae) {
            LOGGER.info(String.format("invalid sha1-hash on %s", dependency.getFileName()));
        }
        catch (FileNotFoundException fnfe) {
            LOGGER.fine(String.format("Artifact not found in repository: '%s", dependency.getFileName()));
        }
        catch (IOException ioe) {
            LOGGER.log(Level.FINE, "Could not connect to Central search", ioe);
            this.errorFlag = true;
        }
    }
}

